/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcErrorHandler;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnAll;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnFailure;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcOnSuccess;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcSuccessHandler;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHostMessage;
import org.eclipse.vjet.dsf.dap.svc.IDapHostSvcCallback;
import org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback;
import org.eclipse.vjet.dsf.services.ServiceError;
import org.eclipse.vjet.dsf.services.ServiceResponse;
import org.mozilla.mod.javascript.ScriptableObject;

public class DapHostSvcHandler
extends BaseScriptable
implements IDapHostSvcCallback {
    private IDapSvcCallback m_respHandler;
    public static final String[] MTD_NAMES = new String[]{"onResponse"};

    public DapHostSvcHandler() {
    }

    public ScriptableObject onResponse(ScriptableObject src) {
        if (src instanceof DapHostMessage) {
            DapHostMessage msg = (DapHostMessage)src;
            msg.setResponse(DapCtx.ctx().getXmlHttpReq().getResponseText());
            this.handle(msg);
        }
        return null;
    }

    protected void handle(DapHostMessage msg) {
        ServiceResponse resp = msg.getSvcResponse();
        if (resp == null) {
            throw new DsfRuntimeException("resp is null");
        }
        String svcName = msg.getSvcId();
        String opName = msg.getOpName();
        List error = resp.getErrors();
        Class<?> cls = this.m_respHandler.getClass();
        DapCtx dapCtx = DapCtx.ctx();
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> itf = classArray[n2];
            if (IDapSvcCallback.class.isAssignableFrom(itf)) {
                Method[] methodArray = itf.getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.getAnnotation(ADapSvcOnAll.class) != null) {
                        try {
                            m.invoke((Object)this.m_respHandler, resp.getData(), error);
                        }
                        catch (Exception e) {
                            dapCtx.getDapConfig().getInfoCollector().log("fail to invoke " + m.getName(), e);
                        }
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (error != null && error.size() > 0) {
            this.handleError(msg.getSvcId(), opName, error);
        } else {
            this.handleResponse(svcName, opName, resp.getData());
        }
    }

    DapHostSvcHandler(IDapSvcCallback respHandler) {
        this.m_respHandler = respHandler;
        this.defineFunctionProperties(MTD_NAMES);
    }

    private void handleResponse(String svcName, String opName, Object data) {
        Class<?> cls = this.m_respHandler.getClass();
        DapCtx dapCtx = DapCtx.ctx();
        GenericDeclaration[] genericDeclarationArray = cls.getMethods();
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = genericDeclarationArray[n2];
            ADapSvcSuccessHandler callback = m.getAnnotation(ADapSvcSuccessHandler.class);
            if (callback != null && callback.toString().contains("=" + opName)) {
                try {
                    m.invoke((Object)this.m_respHandler, data);
                }
                catch (Exception e) {
                    dapCtx.getDapConfig().getInfoCollector().log("fail to invoke " + m.getName(), e);
                }
                return;
            }
            ++n2;
        }
        genericDeclarationArray = cls.getInterfaces();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration itf = genericDeclarationArray[n2];
            if (IDapSvcCallback.class.isAssignableFrom((Class<?>)itf)) {
                Method[] methodArray = ((Class)itf).getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.getAnnotation(ADapSvcOnSuccess.class) != null) {
                        try {
                            m.invoke((Object)this.m_respHandler, data);
                        }
                        catch (Exception e) {
                            dapCtx.getDapConfig().getInfoCollector().log("fail to invoke " + m.getName(), e);
                        }
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void handleError(String svcName, String opName, List<ServiceError> error) {
        DapCtx dapCtx = DapCtx.ctx();
        Class<?> cls = this.m_respHandler.getClass();
        GenericDeclaration[] genericDeclarationArray = cls.getInterfaces();
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> itf = genericDeclarationArray[n2];
            if (IDapSvcCallback.class.isAssignableFrom(itf)) {
                Method[] methodArray = itf.getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.getAnnotation(ADapSvcOnFailure.class) != null) {
                        try {
                            m.invoke((Object)this.m_respHandler, error);
                        }
                        catch (Exception e) {
                            dapCtx.getDapConfig().getInfoCollector().log("fail to invoke " + m.getName(), e);
                        }
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        genericDeclarationArray = cls.getMethods();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration m = genericDeclarationArray[n2];
            ADapSvcErrorHandler a = ((Method)m).getAnnotation(ADapSvcErrorHandler.class);
            if (a != null) {
                try {
                    ((Method)m).invoke(this.m_respHandler, error);
                }
                catch (Exception e) {
                    dapCtx.getDapConfig().getInfoCollector().log("fail to invoke " + ((Method)m).getName(), e);
                }
            }
            ++n2;
        }
    }
}

