/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlAnchor;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlImage;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInput;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInternal;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTextArea;
import org.eclipse.vjet.dsf.active.dom.html.AImage;
import org.eclipse.vjet.dsf.active.dom.html.AJavaScriptHandlerHolder;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.event.IEventListenersCollector;
import org.eclipse.vjet.dsf.dap.api.util.DapEventHelper;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlAnchor;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.eclipse.vjet.dsf.liveconnect.client.NativeEvent;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.Scriptable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DapEventDispatcher {
    private static DapEventDispatcher s_instance = new DapEventDispatcher();
    private static final String JAVASCRIPT = "javascript:";
    private boolean m_anchorReturnValue = true;
    private final String ON = "on";

    private DapEventDispatcher() {
    }

    static DapEventDispatcher getInstance() {
        return s_instance;
    }

    boolean dispatchEvent(DapEvent event) {
        this.setAnchorReturnValue(true);
        if (event == null) {
            return false;
        }
        return this.executeJsHandler(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeJsHandler(DapEvent event) {
        String script;
        AWindow window = DapCtx.ctx().getWindow();
        if (window.getBrowserType().isIE()) {
            window.setEvent((Object)event);
        }
        if ((script = this.getInlineEventCode(event)) == null) {
            AHtmlElement elem = (AHtmlElement)event.getTarget();
            Object object = window.getJsExcutionLock();
            synchronized (object) {
                boolean returnValue;
                block7: {
                    returnValue = this.executeListeners(elem, event, true);
                    if (!(elem instanceof AHtmlAnchor)) break block7;
                    if (this.getAnchorReturnValue()) {
                        return this.executeHref((AHtmlAnchor)elem);
                    }
                    return false;
                }
                return returnValue;
            }
        }
        return this.executeJavaScript(script);
    }

    private boolean executeHref(HtmlAnchor elem) {
        String href = elem.getHref();
        int ind = href.indexOf(JAVASCRIPT);
        if (ind != -1) {
            String hrefScript = href.substring(ind + JAVASCRIPT.length());
            if (!"".equals(hrefScript)) {
                this.executeJavaScript(hrefScript);
                return false;
            }
        } else if (href != null && "".equals(href.trim())) {
            return false;
        }
        return true;
    }

    private boolean executeJavaScript(String script) {
        AWindow window = DapCtx.ctx().getWindow();
        DapCtx.ctx().getDapConfig().getInfoCollector().log("Rhino => " + script);
        Object ret = ScriptExecutor.executeScript(script, window);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        return true;
    }

    private String getInlineEventCode(DapEvent event) {
        String js = null;
        org.eclipse.vjet.dsf.jsnative.Node node = DapEventHelper.getInstance().getSrcNode(event);
        if (node != null && node instanceof ANode) {
            Node n1;
            DNode dNode = ADomHelper.getDNode((ANode)node);
            NamedNodeMap map = dNode.getAttributes();
            String eventName = event.getType();
            if (eventName != null && eventName.indexOf("on") == -1) {
                eventName = "on" + eventName;
            }
            if (map != null && (n1 = map.getNamedItem(eventName)) != null) {
                js = n1.getNodeValue();
            }
        }
        return js;
    }

    private boolean executeListeners(ANode elem, DapEvent evt, boolean enableBodyLoad) {
        if (!this.isValidEvent(evt)) {
            return true;
        }
        String eventType = evt.getType();
        boolean cancelBubble = false;
        boolean preventDefault = false;
        boolean isLoadEvent = eventType.equals(NativeEvent.load.toString());
        boolean bubbleUp = this.bubbleUpEvent(elem, eventType);
        Map<String, List<AJavaScriptHandlerHolder>> listeners = null;
        if (elem instanceof IEventListenersCollector) {
            listeners = ((IEventListenersCollector)((Object)elem)).getListeners();
        }
        cancelBubble = this.executeListenersList(listeners, evt);
        if (isLoadEvent && elem instanceof AHtmlDocument) {
            this.executeDocumentReadyListeners((AHtmlDocument)elem, evt);
        }
        if (!cancelBubble && !evt.isStopPropagation() && !preventDefault && elem.getParentNode() != null && bubbleUp) {
            ANode parent = (ANode)elem.getParentNode();
            cancelBubble = !this.executeListeners(parent, evt, false);
        }
        return !cancelBubble;
    }

    private boolean bubbleUpEvent(ANode elem, String eventType) {
        return !eventType.equals(NativeEvent.load.toString()) || !(elem instanceof AHtmlImage) && !(elem instanceof AImage);
    }

    private void executeDocumentReadyListeners(AHtmlDocument doc, DapEvent evt) {
        String eventType = evt.getType();
        boolean isLoadEvent = eventType.equals("load");
        if (isLoadEvent) {
            DapEvent readyEvent = new DapEvent();
            if (DapCtx.ctx().getWindow().getBrowserType().isIE()) {
                readyEvent.setEventType(EventType.READYSTATECHANGE);
            } else {
                readyEvent.setEventType(EventType.DOMCONTENTLOADED);
            }
            readyEvent.setTarget(doc);
            Map<String, List<AJavaScriptHandlerHolder>> listeners = doc.getListeners();
            this.executeListenersList(listeners, readyEvent);
        }
    }

    private boolean isValidEvent(DapEvent evt) {
        String eventType = evt.getType();
        return eventType != null && !"".equals(eventType.trim());
    }

    private boolean executeListenersList(Map<String, List<AJavaScriptHandlerHolder>> listeners, DapEvent evt) {
        AWindow win = DapCtx.ctx().getWindow();
        boolean cancelBubble = false;
        boolean preventDefault = false;
        boolean returnValue = false;
        String eventType = evt.getType();
        EventTarget target = evt.getTarget();
        boolean isElement = target instanceof AHtmlElement;
        eventType = AHtmlHelper.getCorrectType(eventType);
        if (listeners != null && listeners.get(eventType) != null) {
            List<AJavaScriptHandlerHolder> lst = listeners.get(eventType);
            for (AJavaScriptHandlerHolder handlerHolder : lst) {
                Object handler = handlerHolder.getHandler();
                if (handler instanceof IJsJavaProxy) {
                    handler = ((IJsJavaProxy)handler).getJsNative();
                }
                if (handler instanceof Function) {
                    Object ret;
                    Function f = (Function)handler;
                    Object[] args = new Object[]{evt};
                    Object this_ = win.getScope();
                    Scriptable functionScope = f.getParentScope();
                    if (handlerHolder.getHandlerType().equals((Object)AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE) && isElement) {
                        this_ = (AHtmlElement)target;
                    }
                    if ((ret = f.call(win.getContext(), functionScope, this_, args)) instanceof Boolean && target instanceof AHtmlAnchor) {
                        this.setAnchorReturnValue((Boolean)ret);
                    }
                    cancelBubble = evt.getCancelBubble() || evt.isStopPropagation();
                    preventDefault = evt.getDefaultPrevented();
                    returnValue = evt.getReturnValue();
                    if (evt.isStopImmediatePropagation() && isElement) {
                        return false;
                    }
                    if (cancelBubble && isElement) break;
                    if (!isElement) continue;
                    AHtmlElement elem = (AHtmlElement)target;
                    if (returnValue && !preventDefault) continue;
                    ANode parent = (ANode)elem.getParentNode();
                    this.executeListeners((AHtmlElement)parent, evt, false);
                    if (target instanceof AHtmlInput) {
                        String tagName = ((AHtmlInput)elem).getType().toLowerCase();
                        if (tagName.equals("radio") || tagName.equals("checkbox")) {
                            AHtmlInput ele;
                            ele.setChecked(!(ele = (AHtmlInput)elem).getChecked());
                        } else if (tagName.equals("text") || tagName.equals("textarea")) {
                            AHtmlInput ele = (AHtmlInput)elem;
                            ele.setValue(ele.getDefaultValue());
                        }
                    } else if (elem instanceof AHtmlTextArea) {
                        AHtmlTextArea ele = (AHtmlTextArea)elem;
                        ele.setValue(ele.getDefaultValue());
                    } else if (elem instanceof AHtmlAnchor) {
                        this.setAnchorReturnValue(false);
                    }
                    return false;
                }
                ScriptExecutor.executeScript(handler.toString(), win);
            }
        }
        return cancelBubble;
    }

    private boolean getAnchorReturnValue() {
        return this.m_anchorReturnValue;
    }

    private void setAnchorReturnValue(boolean returnValue) {
        this.m_anchorReturnValue = returnValue;
    }

    private static class ADomHelper
    extends AHtmlInternal {
        private ADomHelper() {
        }

        private static DNode getDNode(ANode aNode) {
            return ADomHelper.getInternalNode(aNode);
        }
    }
}

