/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.event.AKeyEvent;
import org.eclipse.vjet.dsf.dap.event.AMouseEvent;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.rt.DapEventInfo;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public final class DapEventCreator {
    private Map<String, EventType> s_eventTypes = new HashMap<String, EventType>(10);
    private static DapEventCreator s_instance = new DapEventCreator();

    private DapEventCreator() {
    }

    static DapEventCreator getInstance() {
        return s_instance;
    }

    DapEvent createEvent(DLCEvent dlcEvent) {
        DLCEvent.KeyInfo keyInfo;
        String srcId = dlcEvent.getSrcId();
        ANode jsElem = null;
        String srcByPath = dlcEvent.getSrcPath();
        if (srcId == null && srcByPath == null) {
            throw new DsfRuntimeException("both srcId and srcPath are null");
        }
        jsElem = AHtmlHelper.getElementReference(srcByPath, srcId);
        if (jsElem == null || !(jsElem instanceof EventTarget)) {
            throw new DsfRuntimeException("eventTarget is null at: " + srcByPath);
        }
        DapEventInfo evtInfo = new DapEventInfo();
        DLCEvent.Position position = dlcEvent.getPosition();
        if (position != null) {
            evtInfo.setClientX(position.getClientX());
            evtInfo.setClientY(position.getClientY());
            evtInfo.setScreenX(position.getScreenX());
            evtInfo.setScreenY(position.getScreenY());
            evtInfo.setPageX(position.getPageX());
            evtInfo.setPageY(position.getPageY());
        }
        if ((keyInfo = dlcEvent.getKeyInfo()) != null) {
            evtInfo.setAltKey(keyInfo.isAltKey());
            evtInfo.setCtrlKey(keyInfo.isCtrlKey());
            evtInfo.setShiftKey(keyInfo.isShiftKey());
            evtInfo.setMetaKey(keyInfo.isMetaKey());
            evtInfo.setKeyCode(keyInfo.getKeyCode());
            evtInfo.setCharCode(keyInfo.getCharCode());
            evtInfo.setKeyIdentifier(keyInfo.getKeyIdentifier());
            evtInfo.setKeyLocation(keyInfo.getKeyLocation());
        }
        evtInfo.setButton(dlcEvent.getButton());
        evtInfo.setModifierState(dlcEvent.isModifierState());
        evtInfo.setCancelable(dlcEvent.isCancelable());
        evtInfo.setCancelBubble(dlcEvent.isCancelBubble());
        evtInfo.setTimeStamp(dlcEvent.getTimeStamp());
        evtInfo.setDetail(dlcEvent.getDetail());
        evtInfo.setWhich(dlcEvent.getWhich());
        ANode relTarget = AHtmlHelper.getElementReference(dlcEvent.getRelatedTarget(), dlcEvent.getRelatedTargetId());
        if (relTarget != null && relTarget instanceof AHtmlElement) {
            evtInfo.setRelatedTarget((AHtmlElement)relTarget);
        }
        return this.createEvt((EventTarget)jsElem, dlcEvent.getType(), evtInfo);
    }

    DapEvent createEvent(EventTarget jsElem, String eventType, DapEventInfo evtInfo) {
        return this.createEvt(jsElem, eventType, evtInfo);
    }

    private DapEvent createEvt(EventTarget jsElem, String eventType, DapEventInfo evtInfo) {
        int onInd = eventType.indexOf("on");
        if (onInd != -1) {
            eventType = eventType.substring(onInd + "on".length());
        }
        if (EventType.FOCUS.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.FOCUS);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.BLUR.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.BLUR);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.CLICK.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.CLICK);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.DBLCLICK.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.DBLCLICK);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.MOUSEDOWN.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.MOUSEDOWN);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.MOUSEOVER.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.MOUSEOVER);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.MOUSEOUT.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.MOUSEOUT);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.MOUSEUP.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.MOUSEUP);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.MOUSEMOVE.getName().equals(eventType)) {
            AMouseEvent event = new AMouseEvent(jsElem, EventType.MOUSEMOVE);
            this.setMouseEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.KEYUP.getName().equals(eventType)) {
            AKeyEvent event = new AKeyEvent(jsElem, EventType.KEYUP);
            this.setKeyEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.KEYDOWN.getName().equals(eventType)) {
            AKeyEvent event = new AKeyEvent(jsElem, EventType.KEYDOWN);
            this.setKeyEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.KEYPRESS.getName().equals(eventType)) {
            AKeyEvent event = new AKeyEvent(jsElem, EventType.KEYPRESS);
            this.setKeyEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.LOAD.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.LOAD);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.UNLOAD.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.UNLOAD);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.RESIZE.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.RESIZE);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.SCROLL.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.SCROLL);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.SELECT.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.SELECT);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.SUBMIT.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.SUBMIT);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.RESET.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.RESET);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.ERROR.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.ERROR);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        if (EventType.READYSTATECHANGE.getName().equals(eventType)) {
            DapEvent event = new DapEvent(jsElem, EventType.READYSTATECHANGE);
            this.setDapEventInfo(event, evtInfo);
            return event;
        }
        DapEvent event = new DapEvent(jsElem, this.getEventType(eventType));
        this.setDapEventInfo(event, evtInfo);
        return event;
    }

    private EventType getEventType(String eventName) {
        EventType type = this.getET(eventName);
        if (type != null) {
            return type;
        }
        ListIterator itr = EventType.getIterator(EventType.class);
        while (itr.hasNext()) {
            type = (EventType)itr.next();
            if (!type.getName().equals(eventName)) continue;
            this.setET(eventName, type);
            return type;
        }
        return null;
    }

    private synchronized EventType getET(String name) {
        return this.s_eventTypes.get(name);
    }

    private synchronized void setET(String name, EventType type) {
        this.s_eventTypes.put(name, type);
    }

    private void setDapEventInfo(DapEvent event, DapEventInfo evtInfo) {
        if (evtInfo != null) {
            event.setCanBubble(!evtInfo.isCancelBubble());
            event.setCancelable(evtInfo.isCancelable());
            event.setTimestamp(evtInfo.getTimeStamp());
        }
    }

    private void setMouseEventInfo(AMouseEvent event, DapEventInfo evtInfo) {
        if (evtInfo != null) {
            event.setClientX(evtInfo.getClientX());
            event.setClientY(evtInfo.getClientY());
            event.setScreenX(evtInfo.getScreenX());
            event.setScreenY(evtInfo.getScreenY());
            event.setAltKey(evtInfo.isAltKey());
            event.setShiftKey(evtInfo.isShiftKey());
            event.setCtrlKey(evtInfo.isCtrlKey());
            event.setCanBubble(!evtInfo.isCancelBubble());
            event.setButton(evtInfo.getButton());
            event.setMetaKey(evtInfo.isMetaKey());
            event.setCancelable(evtInfo.isCancelable());
            event.setTimestamp(evtInfo.getTimeStamp());
            event.setDetail(evtInfo.getDetail());
            event.setRelatedTarget(evtInfo.getRelatedTarget());
            event.setPageX(evtInfo.getPageX());
            event.setPageY(evtInfo.getPageY());
        }
    }

    private void setKeyEventInfo(AKeyEvent event, DapEventInfo evtInfo) {
        if (evtInfo != null) {
            event.setCanBubble(!evtInfo.isCancelBubble());
            event.setMetaKey(evtInfo.isMetaKey());
            event.setKeyCode(evtInfo.getKeyCode());
            event.setWhich(evtInfo.getWhich());
            event.setCharCode(evtInfo.getCharCode());
            event.setKeyIdentifier(evtInfo.getKeyIdentifier());
            event.setKeyLocation(evtInfo.getKeyLocation());
            event.setModifierState(evtInfo.isModifierState());
            event.setCancelable(evtInfo.isCancelable());
            event.setTimestamp(evtInfo.getTimeStamp());
            event.setDetail(evtInfo.getDetail());
        }
    }
}

