/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.dap.proxy.ScriptEngineCtx;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapEventDispatcher;
import org.eclipse.vjet.dsf.dap.rt.DapEventListenerRegistry;
import org.eclipse.vjet.dsf.dap.rt.DapHost;
import org.eclipse.vjet.dsf.dap.rt.DapServiceEngine;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.XMLHttpRequestImpl;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.service.client.IClientServiceHandlerRegistry;
import org.mozilla.mod.javascript.Scriptable;

public final class DapCtx
extends BaseSubCtx {
    private ExeMode m_exeMode = ExeMode.WEB;
    private DapConfig m_dapConfig;
    private DapSession m_session;
    private DapHost m_dapHost;
    private AWindow m_window;
    private XMLHttpRequestImpl m_xmlHttpReq;
    private DapEventListenerRegistry m_evtListenerRegistry;
    private DapEventDispatcher m_eventDispatcher;
    private DapServiceEngine m_svcEngine;
    private IClientServiceHandlerRegistry m_dsfSvcRegistry;
    private String m_host = "localhost";

    private DapCtx() {
    }

    public static DapCtx create() {
        return new DapCtx();
    }

    public static DapCtx ctx() {
        DapCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = DapCtx.create();
            DapCtx.setCtx(context);
        }
        return context;
    }

    public DapConfig getDapConfig() {
        if (this.m_dapConfig == null) {
            this.m_dapConfig = new DapConfig();
        }
        return this.m_dapConfig;
    }

    public DapCtx setDapConfig(DapConfig dapConfig) {
        this.m_dapConfig = dapConfig;
        return this;
    }

    public void setExeMode(ExeMode exeMode) {
        if (exeMode != ExeMode.WEB) {
            HtmlCtx.ctx().setDisableInlineHandler(true);
        }
        this.m_exeMode = exeMode;
    }

    public ExeMode getExeMode() {
        return this.m_exeMode;
    }

    public boolean isActiveMode() {
        return this.m_exeMode == ExeMode.ACTIVE;
    }

    public boolean isTranslateMode() {
        return this.m_exeMode == ExeMode.TRANSLATE;
    }

    public boolean isWebMode() {
        return this.m_exeMode == ExeMode.WEB;
    }

    public AWindow getWindow() {
        return this.m_window;
    }

    public DapEventListenerRegistry getEventListenerRegistry() {
        if (this.m_evtListenerRegistry == null) {
            this.m_evtListenerRegistry = new DapEventListenerRegistry();
        }
        return this.m_evtListenerRegistry;
    }

    public DapServiceEngine getServiceEngine() {
        if (this.m_svcEngine == null) {
            this.m_svcEngine = new DapServiceEngine();
        }
        return this.m_svcEngine;
    }

    public static AWindow window() {
        return DapCtx.ctx().getWindow();
    }

    public static AHtmlDocument document() {
        AWindow w = DapCtx.window();
        return w == null ? null : (AHtmlDocument)w.getDocument();
    }

    public DapSession getSession() {
        return this.m_session;
    }

    public DapCtx setSession(DapSession session) {
        this.m_session = session;
        return this;
    }

    public DapCtx reset() {
        this.m_exeMode = ExeMode.WEB;
        this.m_dapConfig = null;
        this.m_session = null;
        this.m_dapHost = null;
        this.m_window = null;
        this.m_xmlHttpReq = null;
        this.m_evtListenerRegistry = null;
        this.m_eventDispatcher = null;
        this.m_svcEngine = null;
        this.m_dsfSvcRegistry = null;
        ScriptEngineCtx.ctx().reset();
        return this;
    }

    public static void setCtx(DapCtx context) {
        if (context != null) {
            context.setUpScriptEngineCtx();
        }
        CtxAssociator.setCtx(context);
    }

    public void setWindow(AWindow window) {
        this.m_window = window;
        this.setUpScriptEngineCtx();
    }

    DapCtx setEventListenerRegistry(DapEventListenerRegistry listenerRegistry) {
        this.m_evtListenerRegistry = listenerRegistry;
        return this;
    }

    DapCtx setServiceEngine(DapServiceEngine svcEngine) {
        this.m_svcEngine = svcEngine;
        return this;
    }

    DapCtx setEventDispatcher(DapEventDispatcher eventDispatcher) {
        this.m_eventDispatcher = eventDispatcher;
        return this;
    }

    DapEventDispatcher getEventDispatcher() {
        return this.m_eventDispatcher;
    }

    IClientServiceHandlerRegistry getDsfSvcRegistry() {
        return this.m_dsfSvcRegistry;
    }

    public DapCtx setDsfSvcRegistry(IClientServiceHandlerRegistry dsfSvcRegistry) {
        this.m_dsfSvcRegistry = dsfSvcRegistry;
        return this;
    }

    public XMLHttpRequestImpl getXmlHttpReq() {
        return this.m_xmlHttpReq;
    }

    void setXmlHttpReq(XMLHttpRequestImpl xmlHttpReq) {
        this.m_xmlHttpReq = xmlHttpReq;
    }

    String getHost() {
        return this.m_host;
    }

    void setHost(String host) {
        this.m_host = host;
    }

    DapHost getDapHost() {
        return this.m_dapHost;
    }

    void setDapHost(DapHost dapHost) {
        this.m_dapHost = dapHost;
    }

    public void setSameCxtForCurrentThread() {
        DapCtx.setCtx(this);
    }

    private void setUpScriptEngineCtx() {
        if (this.m_window != null) {
            ScriptEngineCtx scriptCtx = ScriptEngineCtx.ctx();
            scriptCtx.setScriptContext(this.m_window.getContext());
            scriptCtx.setScope((Scriptable)this.m_window);
        }
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = DapCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static DapCtx getCtx() {
            return (DapCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME));
        }

        protected static void setCtx(DapCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }
    }

    public static abstract class DapCtxHelper {
        protected static void setWindow(AWindow win) {
            DapCtx.ctx().setWindow(win);
        }
    }

    public static enum ExeMode {
        ACTIVE,
        TRANSLATE,
        WEB;

    }
}

