/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.jsnative.NamedNodeMap;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.mozilla.mod.javascript.Scriptable;
import org.w3c.dom.DOMException;

public class ANamedNodeMap
extends ActiveObject
implements NamedNodeMap,
Cloneable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, ANode> m_nodes = new LinkedHashMap();
    private short m_nodeType;

    public ANamedNodeMap(short nodeType) {
        this.m_nodeType = nodeType;
        this.populateScriptable(ANamedNodeMap.class, BrowserType.IE_6P);
    }

    public int getLength() {
        return this.m_nodes.size();
    }

    public Node getNamedItem(String name) {
        return this.m_nodes.get(name);
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        throw new ADOMException(new DOMException(9, "getNamedItemNS not supported"));
    }

    public Node item(int index) {
        if (index < 0 || index > this.getLength() - 1) {
            return null;
        }
        Iterator<Map.Entry<String, ANode>> entrySet = this.m_nodes.entrySet().iterator();
        int count = 0;
        while (entrySet.hasNext()) {
            Map.Entry<String, ANode> mapEntry = entrySet.next();
            if (count == index) {
                return mapEntry.getValue();
            }
            ++count;
        }
        return null;
    }

    public Node removeNamedItem(String name) {
        if (!this.m_nodes.containsKey(name)) {
            throw new ADOMException(new DOMException(8, "node not found - " + name));
        }
        return (Node)this.m_nodes.remove(name);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) {
        throw new ADOMException(new DOMException(9, "removeNamedItemNS not supported"));
    }

    public Node setNamedItem(Node node) {
        if (node == null) {
            throw new ADOMException(new DOMException(3, "null node not allowed"));
        }
        if (node.getNodeType() != this.m_nodeType) {
            throw new ADOMException(new DOMException(3, "node of type " + node.getNodeType() + "not allowed"));
        }
        return this.m_nodes.put(node.getNodeName(), (ANode)node);
    }

    public Node setNamedItemNS(Node arg) {
        throw new ADOMException(new DOMException(9, "setNamedItemNS not supported"));
    }

    public Object get(int index, Scriptable start) {
        Object obj = super.get(index, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        if (this.m_nodes == null) {
            return NOT_FOUND;
        }
        obj = this.item(index);
        if (obj != null) {
            return obj;
        }
        return NOT_FOUND;
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        if (this.m_nodes == null) {
            return NOT_FOUND;
        }
        obj = this.getNamedItem(name);
        if (obj != null) {
            return obj;
        }
        return NOT_FOUND;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getClass().getName();
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.cloneMap();
    }

    ANamedNodeMap cloneMap() {
        ANamedNodeMap copy = new ANamedNodeMap(this.m_nodeType);
        for (String key : this.m_nodes.keySet()) {
            ANode node = this.m_nodes.get(key);
            ANode newNode = (ANode)node.cloneNode(true);
            copy.m_nodes.put(key, newNode);
        }
        return copy;
    }
}

