/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DButton;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlButton;
import org.eclipse.vjet.dsf.jsnative.HtmlForm;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlButton
extends AHtmlElement
implements HtmlButton,
IDFormControl {
    private static final long serialVersionUID = 1L;
    private static final String FOCUS_JS_METHOD = "focus()";

    protected AHtmlButton(AHtmlDocument doc, DButton button) {
        super(doc, (BaseHtmlElement)button);
        this.populateScriptable(AHtmlButton.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    public void click() {
        this.dispatchEvent(EventType.CLICK.getName(), this);
    }

    @Override
    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDButton(), FOCUS_JS_METHOD);
        }
    }

    public String getAccessKey() {
        return this.getDButton().getHtmlAccessKey();
    }

    public boolean getDisabled() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.disabled, this.getHtmlAttribute(EHtmlAttr.disabled));
    }

    public HtmlForm getForm() {
        return super.getFormInternal();
    }

    public String getName() {
        return this.getDButton().getHtmlName();
    }

    public int getTabIndex() {
        return this.getDButton().getHtmlTabIndex();
    }

    public String getType() {
        return this.getDButton().getHtmlType();
    }

    public void setType(String type) {
        this.getDButton().setHtmlType(type);
        this.onAttrChange(EHtmlAttr.type, type);
    }

    public String getValue() {
        return this.getDButton().getHtmlValue();
    }

    public void setAccessKey(String accessKey) {
        this.getDButton().setHtmlAccessKey(accessKey);
        this.onAttrChange(EHtmlAttr.accesskey, accessKey);
    }

    public void setDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        this.onAttrChange(EHtmlAttr.disabled, disabled);
    }

    public void setName(String name) {
        this.getDButton().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setTabIndex(int tabIndex) {
        this.getDButton().setHtmlTabIndex(tabIndex);
        this.onAttrChange(EHtmlAttr.tabindex, String.valueOf(tabIndex));
    }

    public void setValue(String value) {
        this.getDButton().setHtmlValue(value);
        this.onValueChange(value);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DButton getDButton() {
        return (DButton)this.getDNode();
    }
}

