/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.vjet.dsf.active.client.APlugin;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.jsnative.Plugin;
import org.eclipse.vjet.dsf.jsnative.PluginArray;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.mozilla.mod.javascript.Scriptable;

public class APluginArray
extends ActiveObject
implements PluginArray {
    private static final long serialVersionUID = 1L;
    private ArrayList<APlugin> m_plugins = new ArrayList();

    public APluginArray() {
        this.populateScriptable(APluginArray.class, BrowserType.IE_6P);
    }

    public int getLength() {
        return this.m_plugins.size();
    }

    public Plugin item(int index) {
        return this.get(index);
    }

    public Plugin namedItem(String name) {
        return this.get(name);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return ((Object)((Object)this)).getClass().getName();
        }
        return null;
    }

    public Plugin get(String name) {
        if (name == null) {
            return null;
        }
        for (APlugin p : this.m_plugins) {
            if (p == null || !name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public APlugin get(int index) {
        if (index < 0 || index >= this.m_plugins.size()) {
            return null;
        }
        return this.m_plugins.get(index);
    }

    public Iterator<APlugin> iterator() {
        return this.m_plugins.iterator();
    }

    public Object get(int index, Scriptable start) {
        Object obj = super.get(index, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        if (this.m_plugins == null) {
            return NOT_FOUND;
        }
        obj = this.item(index);
        if (obj != null) {
            return obj;
        }
        return NOT_FOUND;
    }

    public Object get(String name, Scriptable start) {
        Plugin obj = this.get(name);
        if (obj != null) {
            return obj;
        }
        return NOT_FOUND;
    }

    public boolean add(APlugin plugin) {
        return this.m_plugins.add(plugin);
    }

    void remove(APlugin plugin) {
        this.m_plugins.remove((Object)plugin);
    }

    void remove(int index) {
        this.m_plugins.remove(index);
    }

    public boolean isEmpty() {
        return this.m_plugins.isEmpty();
    }

    int indexOf(APlugin plugin) {
        return this.m_plugins.indexOf((Object)plugin);
    }

    public int size() {
        return this.m_plugins.size();
    }

    void add(int index, APlugin plugin) {
        this.m_plugins.add(index, plugin);
    }

    public boolean addAll(Collection<? extends APlugin> c) {
        return this.m_plugins.addAll(c);
    }

    public void clear() {
        this.m_plugins.clear();
    }
}

