/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.corext.util.SearchUtils;
import org.eclipse.dltk.mod.internal.ui.search.DLTKElementMatch;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.PatternQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoSearchEngine;

public class VjoSearchQuery
extends DLTKSearchQuery {
    private QuerySpecification specification;
    private boolean isForSatisfier = false;

    public VjoSearchQuery(QuerySpecification specification) {
        super(specification);
        this.specification = specification;
    }

    public IStatus run(IProgressMonitor monitor) {
        DLTKSearchResult result = (DLTKSearchResult)this.getSearchResult();
        result.removeAll();
        SearchQueryParameters parameters = this.createQueryParameters();
        if (parameters.getStringPattern() == null) {
            return this.createErrorStatus(parameters.getStringPattern());
        }
        monitor.beginTask(Messages.format((String)SearchMessages.DLTKSearchQuery_task_label, (Object)parameters.getStringPattern()), 1);
        VjoSearchEngine engine = new VjoSearchEngine();
        List list = engine.search(parameters);
        for (VjoMatch vm : list) {
            if (this.isForSatisfier && vm.getElement() instanceof VjoSourceType) {
                try {
                    String satisfierName;
                    String[] satisfiers = ((VjoSourceType)vm.getElement()).getSuperInterfaceNames();
                    if (parameters.getElement() instanceof VjoSourceType && !this.isStringInArray(satisfiers, satisfierName = ((VjoSourceType)parameters.getElement()).getFullyQualifiedName())) {
                        continue;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
            DLTKElementMatch match = new DLTKElementMatch(vm.getElement(), vm.getMatchRule(), vm.getOffset(), vm.getLength(), vm.getAccuracy(), vm.isReadAccess(), vm.isWriteAccess(), vm.isScriptdoc());
            match.setIsImport(vm.isIsImport());
            match.setPublic(vm.isPublic());
            match.setStatic(vm.isStatic());
            result.addMatch((Match)match);
        }
        String message = this.createStatusMessage(result);
        return this.createSuccessStatus(message);
    }

    private boolean isStringInArray(String[] satisfiers, String satisfierName) {
        boolean isContainInSatisfiesAree = false;
        String[] stringArray = satisfiers;
        int n = satisfiers.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(satisfierName)) {
                isContainInSatisfiesAree = true;
            }
            ++n2;
        }
        return isContainInSatisfiesAree;
    }

    private SearchQueryParameters createQueryParameters() {
        SearchPattern pattern;
        String stringPattern;
        IDLTKLanguageToolkit toolkit = this.specification.getScope().getLanguageToolkit();
        SearchQueryParameters parameters = new SearchQueryParameters();
        int limitedTo = this.specification.getLimitTo();
        if (limitedTo == 8) {
            limitedTo = 1;
            this.isForSatisfier = true;
        }
        if (this.specification instanceof ElementQuerySpecification) {
            IModelElement element = ((ElementQuerySpecification)this.specification).getElement();
            stringPattern = ScriptElementLabels.getDefault().getElementLabel(element, ScriptElementLabels.ALL_DEFAULT);
            if (!element.exists()) {
                return new SearchQueryParameters(null, stringPattern);
            }
            if (element instanceof NativeVjoSourceModule) {
                element = ((NativeVjoSourceModule)element).getVjoType();
            }
            pattern = SearchPattern.createPattern((IModelElement)element, (int)limitedTo, (int)24, (IDLTKLanguageToolkit)toolkit);
            ElementQuerySpecification cfr_ignored_0 = (ElementQuerySpecification)this.specification;
            parameters.setElementSpecification(true);
            parameters.setElement((Object)element);
        } else {
            PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.specification;
            stringPattern = patternSpec.getPattern();
            int matchMode = this.getMatchMode(stringPattern) | 0x10;
            if (patternSpec.isCaseSensitive()) {
                matchMode |= 8;
            }
            pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)limitedTo, (int)matchMode, (IDLTKLanguageToolkit)toolkit);
        }
        parameters.setStringPattern(stringPattern);
        parameters.setPattern(pattern);
        parameters.setScope(this.specification.getScope());
        parameters.setLimitTo(limitedTo);
        return parameters;
    }

    private Status createErrorStatus(String stringPattern) {
        return new Status(4, DLTKUIPlugin.getPluginId(), 0, Messages.format((String)SearchMessages.DLTKSearchQuery_error_element_does_not_exist, (Object)stringPattern), null);
    }

    private Status createSuccessStatus(String message) {
        return new Status(0, DLTKUIPlugin.getPluginId(), 0, message, null);
    }

    private String createStatusMessage(DLTKSearchResult textResult) {
        return Messages.format((String)SearchMessages.DLTKSearchQuery_status_ok_message, (Object)String.valueOf(textResult.getMatchCount()));
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern((String)pattern)) {
            return 128;
        }
        return 0;
    }
}

