/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.properties;

import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;

public class AstNodePropertySourceAdapter
implements IPropertySource {
    private INodePrinter nodePrinter;
    private IPropertyDescriptor[] propertyDescriptors;
    private Object[] propertyValues;
    private IASTNode node;

    public AstNodePropertySourceAdapter(IASTNode astNode, INodePrinter nodePrinter) {
        this.node = astNode;
        this.nodePrinter = nodePrinter;
        this.propertyValues = nodePrinter.getPropertyValuies(astNode);
        String[] propertyNames = this.nodePrinter.getPropertyNames(astNode);
        this.propertyDescriptors = new PropertyDescriptor[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            this.propertyDescriptors[i] = new PropertyDescriptor((Object)propertyNames[i], propertyNames[i]);
            ++i;
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        int i = 0;
        while (i < this.propertyDescriptors.length) {
            if (this.propertyDescriptors[i].getId().equals(id)) {
                Object value = this.propertyValues[i];
                return value;
            }
            ++i;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return this.node.getClass().getName();
    }
}

