/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.text.completion.ScriptCompletionProposalComputer;
import org.eclipse.dltk.mod.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.mod.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalEclipsePresenter;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.engine.VjoCcEngine;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoTypeCompletionProposalComputerBaseJst
extends ScriptCompletionProposalComputer {
    private String fErrorMessage;

    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        return null;
    }

    protected List computeScriptCompletionProposals(int offset, ScriptContentAssistInvocationContext context, IProgressMonitor monitor) {
        ISourceModule sourceModule = context.getSourceModule();
        if (sourceModule == null) {
            return Collections.EMPTY_LIST;
        }
        VjoSourceModule vjoSourceModule = null;
        if (!(sourceModule instanceof VjoSourceModule)) {
            return Collections.emptyList();
        }
        vjoSourceModule = (VjoSourceModule)sourceModule;
        VjoCcEngine engine = new VjoCcEngine(TypeSpaceMgr.parser());
        String typeName = CodeassistUtils.getGroupName((VjoSourceModule)vjoSourceModule);
        List list = engine.complete(typeName, new String(vjoSourceModule.getFileName()), vjoSourceModule.getSourceContents(), offset);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        CodeCompletionUtils.printProposal((List)list);
        VjoProposalEclipsePresenter presenter = new VjoProposalEclipsePresenter(engine.getContext(), offset, context.getViewer().getSelectedRange(), context.getDocument());
        return presenter.doPresenter(list);
    }

    private void handleCodeCompletionException(ModelException e, ScriptContentAssistInvocationContext context) {
        ISourceModule module = context.getSourceModule();
        Shell shell = context.getViewer().getTextWidget().getShell();
        if (e.isDoesNotExist() && !module.getScriptProject().isOnBuildpath((IModelElement)module)) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean value = store.getBoolean("org.eclipse.dltk.mod.ui.notification.not_on_buildpath");
            if (!value) {
                MessageDialog.openInformation((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            store.setValue("org.eclipse.dltk.mod.ui.notification.not_on_buildpath", true);
        } else {
            ErrorDialog.openError((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_accessing_title, (String)ScriptTextMessages.CompletionProcessor_error_accessing_message, (IStatus)e.getStatus());
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }
}

