/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.ui.templates.IScriptTemplateIndenter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.eclipse.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.CompletionProposal;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.MethodCompletionProposal;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.TypeCompletionProposal;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalAditionalInfoGenerator;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalLabelProvider;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalLabelUtil;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcProposalData;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.AbstractVjoProposalPresenter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseCompletionProposal;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseContextInformationFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoMethodCompletionProposalFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalAditionalInfoGeneratorAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalLabelProviderAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoProposalLabelUtilAdapter;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoTypeCompletionProposalFactory;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.VjoProposalEclipsePresenterAdapter;

public class VjoProposalEclipsePresenter
extends AbstractVjoProposalPresenter {
    private static final IVjoProposalLabelUtilAdapter<IDocument, IScriptTemplateIndenter> LABEL_UTIL = new IVjoProposalLabelUtilAdapter<IDocument, IScriptTemplateIndenter>(){

        public String calculateIndent(IDocument document, int offset) {
            return VjoProposalLabelUtil.calculateIndent(document, offset);
        }

        public String evaluateIndent(String str, IDocument document, int replaceOffset) {
            return VjoProposalLabelUtil.evaluateIndent(str, document, replaceOffset);
        }

        public int getDltkModifyFlag(JstModifiers modifiers) {
            return VjoProposalLabelUtil.getDltkModifyFlag(modifiers);
        }

        public IScriptTemplateIndenter getIndenter() {
            return VjoProposalLabelUtil.getIndenter();
        }

        public JstModifiers getModifiers(IJstNode node) {
            return VjoProposalLabelUtil.getModifiers(node);
        }

        public int getVjoModifierForImage(JstModifiers modifiers) {
            return VjoProposalLabelUtil.getVjoModifierForImage(modifiers);
        }

        public int translateModifers(int jstModifer) {
            return VjoProposalLabelUtil.translateModifers(jstModifer);
        }
    };
    private static final IVjoProposalLabelProviderAdapter<ImageDescriptor, Image> LABEL_PROVIDER = new IVjoProposalLabelProviderAdapter<ImageDescriptor, Image>(){

        public Image getMethodImage(int flags) {
            return VjoProposalLabelProvider.getMethodImage(flags);
        }

        public Image getScriptImage(IJstNode node) {
            return VjoProposalLabelProvider.getScriptImage(node);
        }

        public ImageDescriptor getScriptImageDescriptor(IJstNode node) {
            return VjoProposalLabelProvider.getScriptImageDescriptor(node);
        }

        public Image getTypeImageDescriptor(int flags, boolean useLightIcons) {
            return VjoProposalLabelProvider.getTypeImageDescriptor(flags, useLightIcons);
        }
    };
    private static final IVjoProposalAditionalInfoGeneratorAdapter ADDITIONAL_INFO_GENERATOR = new IVjoProposalAditionalInfoGeneratorAdapter(){

        public boolean isBrowserNoneNode(IJstNode node) {
            return VjoProposalAditionalInfoGenerator.isBrowserNoneNode(node);
        }

        public String getModifierListStr(JstModifiers jstModifiers) {
            return VjoProposalAditionalInfoGenerator.getModifierListStr(jstModifiers);
        }

        public String getElementBriefDesc(IJstMethod method) {
            return VjoProposalAditionalInfoGenerator.getElementBriefDesc(method);
        }

        public String getElementBriefDesc(IJstProperty property) {
            return VjoProposalAditionalInfoGenerator.getElementBriefDesc(property);
        }

        public String getAdditionalPropesalInfo(IJstNode node) {
            return VjoProposalAditionalInfoGenerator.getAdditionalPropesalInfo(node);
        }
    };
    private static final IVjoEclipseContextInformationFactory<Image, IContextInformation> CONTEXT_INFORMATION_FACTORY = new IVjoEclipseContextInformationFactory<Image, IContextInformation>(){

        public IContextInformation buildContextInfo(String contextDisplayString, String informationDisplayString) {
            return new ContextInformation(contextDisplayString, informationDisplayString);
        }

        public IContextInformation buildContextInfo(Image image, String contextDisplayString, String informationDisplayString) {
            return new ContextInformation(image, contextDisplayString, informationDisplayString);
        }
    };
    private static final IVjoMethodCompletionProposalFactory<Image, IContextInformation> METHOD_COMPLETION_PROPOSAL_FACTORY = new IVjoMethodCompletionProposalFactory<Image, IContextInformation>(){

        public IVjoEclipseCompletionProposal<Image, IContextInformation> createMethodCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
            return new MethodCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
        }

        public IVjoEclipseCompletionProposal<Image, IContextInformation> createMethodCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, IJstMethod method) {
            return new MethodCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, method);
        }
    };
    private static final IVjoTypeCompletionProposalFactory<Image, IContextInformation> TYPE_COMPLETION_PROPOSAL_FACTORY = new IVjoTypeCompletionProposalFactory<Image, IContextInformation>(){

        public IVjoEclipseCompletionProposal<Image, IContextInformation> createTypeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int needsPosition, String typeName) {
            return new TypeCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, needsPosition, typeName);
        }

        public IVjoEclipseCompletionProposal<Image, IContextInformation> createTypeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int needsPosition, String typeName, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
            return new TypeCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, needsPosition, typeName, image, displayString, contextInformation, additionalProposalInfo);
        }
    };
    private final VjoProposalEclipsePresenterAdapter<IDocument, Point, ImageDescriptor, Image, IContextInformation, IScriptTemplateIndenter> m_presenterAdapter;

    public VjoProposalEclipsePresenter(VjoCcCtx ctx, int offset, Point selectedRange, IDocument document) {
        this.m_presenterAdapter = new VjoProposalEclipsePresenterAdapter(ctx, offset, (Object)selectedRange, (Object)document, ADDITIONAL_INFO_GENERATOR, LABEL_PROVIDER, LABEL_UTIL, CONTEXT_INFORMATION_FACTORY, METHOD_COMPLETION_PROPOSAL_FACTORY, TYPE_COMPLETION_PROPOSAL_FACTORY);
        this.init();
    }

    protected void init() {
        String token = this.m_presenterAdapter.getVjoCcCtx().getActingToken();
        if (token == null) {
            token = "";
        }
        String replacedToken = this.m_presenterAdapter.getVjoCcCtx().getReplacedToken();
        if (this.m_presenterAdapter.getDocument() != null) {
            this.m_presenterAdapter.setLineSeperator(TextUtilities.getDefaultLineDelimiter((IDocument)((IDocument)this.m_presenterAdapter.getDocument())));
        }
        if (this.m_presenterAdapter.getSelectedRange() == null || ((Point)this.m_presenterAdapter.getSelectedRange()).y == 0) {
            this.m_presenterAdapter.setReplaceLength(replacedToken.length());
        } else {
            int temp = ((Point)this.m_presenterAdapter.getSelectedRange()).x - this.m_presenterAdapter.getOffset() + ((Point)this.m_presenterAdapter.getSelectedRange()).y;
            this.m_presenterAdapter.setReplaceLength(replacedToken.length() + temp);
        }
        this.m_presenterAdapter.setReplaceOffset(this.m_presenterAdapter.getOffset() - token.length());
        String replacedPToken = this.m_presenterAdapter.getVjoCcCtx().getReplacedPackageToken();
        if (this.m_presenterAdapter.getSelectedRange() == null || ((Point)this.m_presenterAdapter.getSelectedRange()).y == 0) {
            this.m_presenterAdapter.setReplacePLength(replacedPToken.length());
        } else {
            int temp = ((Point)this.m_presenterAdapter.getSelectedRange()).x - this.m_presenterAdapter.getOffset() + ((Point)this.m_presenterAdapter.getSelectedRange()).y;
            this.m_presenterAdapter.setReplacePLength(replacedPToken.length() + temp);
        }
        this.m_presenterAdapter.setReplacePOffset(this.m_presenterAdapter.getOffset() - replacedPToken.length());
        JsPreferenceInterpreter prefs = new JsPreferenceInterpreter(VjetUIPlugin.getDefault().getPreferenceStore());
        this.m_presenterAdapter.setIndent(prefs.getIndent());
    }

    public List<ICompletionProposal> doPresenter(List<IVjoCcProposalData> datas) {
        List prepares = this.m_presenterAdapter.doPresenter(datas);
        ArrayList<ICompletionProposal> adaptedProposals = new ArrayList<ICompletionProposal>(prepares.size());
        for (IVjoEclipseCompletionProposal proposal : prepares) {
            if (proposal instanceof MethodCompletionProposal) {
                adaptedProposals.add((MethodCompletionProposal)proposal);
                continue;
            }
            CompletionProposal adaptedProposal = new CompletionProposal(proposal.getReplacementString(), proposal.getReplacementOffset(), proposal.getReplacementLength(), proposal.getCursorPosition(), (Image)proposal.getImage(), proposal.getDisplayString(), (IContextInformation)proposal.getContextInformation(), proposal.getAdditionalProposalInfo(), null);
            adaptedProposals.add(adaptedProposal);
        }
        return adaptedProposals;
    }
}

