/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import org.eclipse.dltk.mod.corext.documentation.SingleCharReader;

public class JavaDocCommentReader
extends SingleCharReader {
    private String fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(String buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public JavaDocCommentReader(String info) {
        this(info, 0, info.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fBuffer.charAt(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fBuffer.charAt(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            ch = this.fBuffer.charAt(this.fCurrPos++);
        }
        this.fWasNewLine = JavaDocCommentReader.isLineDelimiterChar(ch);
        return ch;
    }

    private static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

