/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.internal.ui.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.integration.IVjoEclipseCompletionProposal;

public class CompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
IVjoEclipseCompletionProposal<Image, IContextInformation> {
    protected String fDisplayString;
    protected String fReplacementString;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected Image fImage;
    protected IContextInformation fContextInformation;
    protected String fAdditionalProposalInfo;
    protected static final char[] TRIGGER_METHOD = new char[]{',', '.', ';'};
    protected static final char[] TRIGGER_METHOD_WITH_ARGS = new char[]{',', ';'};
    protected static final char[] TRIGGER_COMMON = new char[0];
    private IInformationControlCreator fCreator;
    private ITextViewer fTextViewer;
    protected Object fData;

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, null);
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, Object data) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fData = data;
    }

    public void apply(IDocument document) {
        try {
            this.preApply(document);
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            this.postApply(document);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void preApply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.fTextViewer = viewer;
        String strigger = String.valueOf(trigger);
        if (!StringUtils.isBlankOrEmpty((String)strigger)) {
            this.fReplacementString = String.valueOf(this.fReplacementString) + strigger;
            ++this.fCursorPosition;
        }
        if (trigger == ';') {
            this.appendComment();
        }
        this.apply(viewer.getDocument());
    }

    protected void appendComment() {
        IJstMethod method;
        String typeComment = "";
        if (this.fData instanceof IJstProperty) {
            IJstProperty property = (IJstProperty)this.fData;
            IJstType type = property.getType();
            if (type != null) {
                typeComment = type.getSimpleName();
            }
        } else if (this.fData instanceof IJstMethod && CodeCompletionUtils.hasReturnValue((IJstMethod)(method = (IJstMethod)this.fData))) {
            typeComment = CodeCompletionUtils.getReturnType((IJstMethod)method);
        }
        if (!StringUtils.isBlankOrEmpty((String)typeComment)) {
            typeComment = "//<" + typeComment;
            this.fReplacementString = String.valueOf(this.fReplacementString) + typeComment;
            this.fCursorPosition += typeComment.length();
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.isPrefix(this.getPrefix(document, offset), this.getReplacementString());
        if (!validated) {
            validated = this.isPrefix(this.getPrefix(document, offset), this.getDisplayString());
        }
        if (validated && event != null) {
            int newLength;
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            this.fReplacementLength = newLength = Math.max(this.fReplacementLength + delta, 0);
        }
        return validated;
    }

    protected String getPrefix(IDocument document, int offset) {
        try {
            int length = offset - this.fReplacementOffset;
            if (length > 0) {
                return document.get(this.fReplacementOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected boolean isPrefix(String prefix, String string) {
        if (prefix == null || string == null || prefix.length() > string.length()) {
            return false;
        }
        String start = string.substring(0, prefix.length());
        return start.equalsIgnoreCase(prefix) || CharOperation.camelCaseMatch((char[])prefix.toCharArray(), (char[])string.toCharArray());
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.fCreator == null) {
            this.fCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    return new BrowserInformationControl(parent, 12, 0, null);
                }
            };
        }
        return this.fCreator;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.fReplacementOffset;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }

    protected void postApply(IDocument document) {
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    protected IInformationControlCreator getCreator() {
        return this.fCreator;
    }

    protected VjoEditor getVjoEditor() {
        return VjetUIPlugin.getVjoEditor();
    }

    protected ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected void performChange(IEditorPart activeEditor, IDocument document, Change change) throws CoreException {
        if (change == null) {
            return;
        }
        IRewriteTarget rewriteTarget = null;
        try {
            if (change != null) {
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null && (rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class)) != null) {
                    rewriteTarget.beginCompoundChange();
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                IUndoManager manager = RefactoringCore.getUndoManager();
                manager.aboutToPerformChange(change);
                Change undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                manager.changePerformed(change, true);
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getReplacementString(), undoChange);
                }
            }
        }
        finally {
            if (rewriteTarget != null) {
                rewriteTarget.endCompoundChange();
            }
            if (change != null) {
                change.dispose();
            }
        }
    }

    protected TextChange createTextChange(IDocument document) throws CoreException {
        return null;
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fCursorPosition;
    }

    public char[] getTriggerCharacters() {
        if (this.fData == null) {
            return TRIGGER_COMMON;
        }
        if (this.fData instanceof IJstProperty) {
            return TRIGGER_METHOD;
        }
        if (this.fData instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)this.fData;
            List args = method.getArgs();
            if (args == null || args.isEmpty()) {
                return TRIGGER_METHOD;
            }
            return TRIGGER_METHOD_WITH_ARGS;
        }
        return TRIGGER_COMMON;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset > 0) {
                        try {
                            if (this.fDocument.getChar(offset - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

