/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.formatting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterMessages;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.SnippetPreview;

public final class WhiteSpaceOptions {
    private final SnippetPreview.PreviewSnippet FOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "for (i= 0, j= array.length; i < array.length; i++, j--) {}\nfor (s in MyData) {}");
    private final SnippetPreview.PreviewSnippet WHILE_PREVIEW = new SnippetPreview.PreviewSnippet(2, "while (condition) {}; do {} while (condition);");
    private final SnippetPreview.PreviewSnippet CATCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try {\n} catch (err) {\n}");
    private final SnippetPreview.PreviewSnippet IF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (condition) { return foo; } else {return bar;}");
    private final SnippetPreview.PreviewSnippet SWITCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "switch (number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}");
    private final SnippetPreview.PreviewSnippet CONSTRUCTOR_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "function Foo(x, y) {\n  this.x = 1;\n  this.y = 2;\n}\nobj1 = new Foo();\nobj2 = new Foo(3, 4);");
    private final SnippetPreview.PreviewSnippet METHOD_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "function foo() {};\nfunction bar(x,y){}");
    private final SnippetPreview.PreviewSnippet ARRAY_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "var arr2=[];\nvar arr3=[4];\nvar arr4=['one','two','three']");
    private final SnippetPreview.PreviewSnippet ARRAY_REF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "array[i];");
    private final SnippetPreview.PreviewSnippet METHOD_CALL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "foo();\nbar(x, y);");
    private final SnippetPreview.PreviewSnippet ALLOC_PREVIEW = new SnippetPreview.PreviewSnippet(2, "s= new Foo(); p= new Bar(x, y);");
    private final SnippetPreview.PreviewSnippet LABEL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "label: for (i= 0; i<list.length; i++) {for (j= 0; j < list[i].length; j++) continue label;}");
    private final SnippetPreview.PreviewSnippet CONDITIONAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "value= condition ? TRUE : FALSE;");
    private final SnippetPreview.PreviewSnippet OPERATOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "var arr= new Array();\nvar a= -4 + -9;\nvar b= a++ / --a;\na += 4;\nvar value= true && false;");
    private final SnippetPreview.PreviewSnippet MULT_LOCAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "var a= 0, b= 1, c= 2, d= 3;");
    private final SnippetPreview.PreviewSnippet BLOCK_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (true) { return 1; } else { return 2; }");
    private final SnippetPreview.PreviewSnippet PAREN_EXPR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "result= (a *( b +  c + d) * (e + f));");
    private final SnippetPreview.PreviewSnippet ASSERT_PREVIEW = new SnippetPreview.PreviewSnippet(2, "assert condition : reportError();");
    private final SnippetPreview.PreviewSnippet RETURN_PREVIEW = new SnippetPreview.PreviewSnippet(2, "return (o);");
    private final SnippetPreview.PreviewSnippet THROW_PREVIEW = new SnippetPreview.PreviewSnippet(2, "throw (e);");
    private final SnippetPreview.PreviewSnippet OBJECT_INITIALIZER_PREVIEW = new SnippetPreview.PreviewSnippet(2, "anObject = { color:'red', wheels:4, engine:{ cylinders:4, size:2.2 } };");

    public List createTreeBySyntaxElem(Map workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_paren);
        this.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_paren);
        this.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_brace);
        this.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_operator);
        this.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_comma);
        this.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_colon);
        this.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_semicolon);
        this.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_question_mark);
        this.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public List createAltTree(Map workingValues) {
        ArrayList roots = new ArrayList();
        InnerNode parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_paren);
        this.createBeforeOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_paren);
        this.createAfterOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_paren);
        this.createBeforeClosingParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_brace);
        this.createAfterOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_brace);
        this.createAfterCloseBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_bracket);
        this.createAfterOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_operator);
        this.createBeforeOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_operator);
        this.createAfterOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_comma);
        this.createBeforeCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_comma);
        this.createAfterCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_colon);
        this.createAfterColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_colon);
        this.createBeforeColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon);
        this.createBeforeSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_semicolon);
        this.createAfterSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_question_mark);
        this.createBeforeQuestionTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_question_mark);
        this.createAfterQuestionTree(workingValues, parent);
        return roots;
    }

    private InnerNode createParentNode(List roots, Map workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public ArrayList createTreeByJavaElement(Map workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_declarations);
        this.createLocalVariableTree(workingValues, declarations);
        this.createMethodDeclTree(workingValues, declarations);
        this.createLabelTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_statements);
        this.createBlockTree(workingValues, statements);
        this.createIfStatementTree(workingValues, statements);
        this.createForStatementTree(workingValues, statements);
        this.createSwitchStatementTree(workingValues, statements);
        this.createDoWhileTree(workingValues, statements);
        this.createTryStatementTree(workingValues, statements);
        this.createReturnTree(workingValues, statements);
        this.createThrowTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_expressions);
        this.createFunctionCallTree(workingValues, expressions);
        this.createAssignmentTree(workingValues, expressions);
        this.createOperatorTree(workingValues, expressions);
        this.createParenthesizedExpressionTree(workingValues, expressions);
        this.createConditionalTree(workingValues, expressions);
        this.createObjectInitializerTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_arrays);
        this.createArrayInitializerTree(workingValues, arrays);
        this.createArrayElementAccessTree(workingValues, arrays);
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        return roots;
    }

    private void createBeforeQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
    }

    private void createBeforeSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
    }

    private void createBeforeColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_assert", this.ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_object_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_object_initializer", this.OBJECT_INITIALIZER_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_case, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_default, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_for", this.FOR_PREVIEW);
    }

    private void createBeforeCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_for_increments", this.FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private void createBeforeOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createBeforeClosingBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createBeforeOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createBeforeOpenBraceTree(Map workingValues, InnerNode parent) {
        InnerNode functionDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
    }

    private void createBeforeClosingParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createBeforeOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return_with_parenthesized_expression, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_parenthesized_expression_in_return", this.RETURN_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throw_with_parenthesized_expression, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_parenthesized_expression_in_throw", this.THROW_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createAfterQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
    }

    private void createAfterSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
    }

    private void createAfterColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_assert", this.ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_object_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_object_initializer", this.OBJECT_INITIALIZER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_for", this.FOR_PREVIEW);
    }

    private void createAfterCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_for_increments", this.FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private void createAfterOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createAfterOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createAfterOpenBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private void createAfterCloseBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
    }

    private void createAfterOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createBetweenEmptyParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_constructor_decl, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
    }

    private void createBetweenEmptyBracketsTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_brackets_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
    }

    private void createBetweenEmptyBracesTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private InnerNode createAssignmentTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_before_assignment_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_after_assignment_operator, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createObjectInitializerTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_object_initializer);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_object_initializer_before_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_object_initializer", this.OBJECT_INITIALIZER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_object_initializer_after_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_object_initializer", this.OBJECT_INITIALIZER_PREVIEW);
        return root;
    }

    private InnerNode createOperatorTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_operators);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_binary_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_binary_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_unary_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_unary_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_prefix_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_prefix_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_postfix_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_postfix_operators, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createMethodDeclTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_methods);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        return root;
    }

    private InnerNode createLocalVariableTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_before_comma, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_after_comma, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        return root;
    }

    private InnerNode createArrayInitializerTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayinit);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_braces, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        return root;
    }

    private InnerNode createArrayElementAccessTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayelem);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        return root;
    }

    private InnerNode createFunctionCallTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_calls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.vjet.eclipse.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_method_args, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_method_args, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_alloc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        return root;
    }

    private InnerNode createBlockTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_blocks);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
        return root;
    }

    private InnerNode createSwitchStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_switch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_case_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_default_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        return root;
    }

    private InnerNode createDoWhileTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_do);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        return root;
    }

    private InnerNode createTryStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_try);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        return root;
    }

    private InnerNode createIfStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_if);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        return root;
    }

    private InnerNode createForStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_for);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_init, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_init, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_inc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_comma_in_for_increments", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_inc, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_comma_in_for_increments", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
        return root;
    }

    private InnerNode createReturnTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_parenthesized_expressions, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_parenthesized_expression_in_return", this.RETURN_PREVIEW);
        return root;
    }

    private InnerNode createThrowTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throw);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_parenthesized_expressions, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_parenthesized_expression_in_throw", this.THROW_PREVIEW);
        return root;
    }

    private InnerNode createLabelTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_labels);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        return root;
    }

    private InnerNode createConditionalTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_conditionals);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        return root;
    }

    private InnerNode createParenthesizedExpressionTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_parenexpr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.vjet.eclipse.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map workingValues, String message) {
        return new InnerNode(root, workingValues, message);
    }

    private static OptionNode createOption(InnerNode root, Map workingValues, String message, String key, SnippetPreview.PreviewSnippet snippet) {
        return new OptionNode(root, workingValues, message, key, snippet);
    }

    public static void makeIndexForNodes(List tree, List flatList) {
        for (Node node : tree) {
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        @Override
        public void setChecked(boolean checked) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        @Override
        public List getSnippets() {
            ArrayList snippets = new ArrayList(this.fChildren.size());
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                List childSnippets = ((Node)iter.next()).getSnippets();
                for (Object snippet : childSnippets) {
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        @Override
        public void getCheckedLeafs(List list) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).getCheckedLeafs(list);
            }
        }
    }

    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map fWorkingValues;
        protected final ArrayList fChildren;

        public Node(InnerNode parent, Map workingValues, String message) {
            if (workingValues == null || message == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = message;
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List getSnippets();

        public abstract void getCheckedLeafs(List var1);
    }

    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList fSnippets;

        public OptionNode(InnerNode parent, Map workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        @Override
        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "insert" : "do not insert");
        }

        public boolean getChecked() {
            return "insert".equals(this.fWorkingValues.get(this.fKey));
        }

        @Override
        public List getSnippets() {
            return this.fSnippets;
        }

        @Override
        public void getCheckedLeafs(List list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

