/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.formatting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.CompilationUnitPreview;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterMessages;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterTabPage;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.JavaPreview;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ModifyDialog;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ModifyDialogTabPage;

public class CommentsTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private static String[] DO_NOT_INSERT_INSERT = new String[]{"do not insert", "insert"};
    private final String PREVIEW = String.valueOf(CommentsTabPage.createPreviewHeader("An example for comment formatting. This example is meant to illustrate the various possibilities offered by <i>Eclipse</i> in order to format comments.")) + "/**\n" + " * This is the comment for the example function.\n" + " */\n" + " function foo(arg) {\n" + "   /**\n" + "   *\n" + "   * These possibilities include:\n" + "   * <ul><li>Formatting of header comments.</li><li>Formatting of JSdoc tags</li></ul>\n" + "   */\n" + "   var data;\n" + "   /**\n" + "   * The following is some sample code which illustrates source formatting within JSdoc comments:\n" + "   * <pre>function foo(a,b) { var a=1; var b=true; return a; }</pre>\n" + "   * Descriptions of parameters and return values are best appended at end of the JSdoc comment.\n" + "   * @param a The first parameter. This should be a number between 1 and 100.\n" + "   * @param b The second parameter. This should be a number between 1 and 5.\n" + "   * @return The result of the foo operation, usually within 1 and 100.\n" + "   */\n" + "   function foo2(a,b);\n" + "}";
    private CompilationUnitPreview fPreview;

    public CommentsTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group globalGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group1_title);
        final ModifyDialogTabPage.CheckboxPreference javadoc = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.commentsTabPage_enable_javadoc_comment_formatting, "org.eclipse.vjet.eclipse.core.formatter.comment.format_javadoc_comments");
        ModifyDialogTabPage.CheckboxPreference blockComment = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_block_comment_formatting, "org.eclipse.vjet.eclipse.core.formatter.comment.format_block_comments");
        ModifyDialogTabPage.CheckboxPreference singleLineComments = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_line_comment_formatting, "org.eclipse.vjet.eclipse.core.formatter.comment.format_line_comments");
        final ModifyDialogTabPage.CheckboxPreference header = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_header, "org.eclipse.vjet.eclipse.core.formatter.comment.format_header");
        this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_block_comments_on_first_column, "org.eclipse.vjet.eclipse.core.formatter.never_indent_block_comments_on_first_column");
        this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_line_comments_on_first_column, "org.eclipse.vjet.eclipse.core.formatter.never_indent_line_comments_on_first_column");
        Group settingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group2_title);
        ModifyDialogTabPage.CheckboxPreference html = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_format_html, "org.eclipse.vjet.eclipse.core.formatter.comment.format_html");
        ModifyDialogTabPage.CheckboxPreference code = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_format_code_snippets, "org.eclipse.vjet.eclipse.core.formatter.comment.format_source_code");
        ModifyDialogTabPage.CheckboxPreference blankJavadoc = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_blank_line_before_javadoc_tags, "org.eclipse.vjet.eclipse.core.formatter.comment.insert_new_line_before_root_tags");
        final ModifyDialogTabPage.CheckboxPreference indentJavadoc = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_javadoc_tags, "org.eclipse.vjet.eclipse.core.formatter.comment.indent_root_tags");
        ModifyDialogTabPage.CheckboxPreference indentDesc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_description_after_param, "org.eclipse.vjet.eclipse.core.formatter.comment.indent_parameter_description", FALSE_TRUE);
        ((GridData)indentDesc.getControl().getLayoutData()).horizontalIndent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        ModifyDialogTabPage.CheckboxPreference nlParam = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_line_after_param_tags, "org.eclipse.vjet.eclipse.core.formatter.comment.insert_new_line_for_parameter");
        ModifyDialogTabPage.CheckboxPreference blankLinesJavadoc = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_clear_blank_lines, "org.eclipse.vjet.eclipse.core.formatter.comment.clear_blank_lines_in_javadoc_comment");
        Group blockSettingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group4_title);
        ModifyDialogTabPage.CheckboxPreference blankLinesBlock = this.createPrefTrueFalse((Composite)blockSettingsGroup, numColumns, FormatterMessages.CommentsTabPage_remove_blank_block_comment_lines, "org.eclipse.vjet.eclipse.core.formatter.comment.clear_blank_lines_in_block_comment");
        Group widthGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group3_title);
        ModifyDialogTabPage.NumberPreference lineWidth = this.createNumberPref((Composite)widthGroup, numColumns, FormatterMessages.CommentsTabPage_line_width, "org.eclipse.vjet.eclipse.core.formatter.comment.line_length", 0, 9999);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> javaDocMaster = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        javaDocMaster.add(javadoc);
        javaDocMaster.add(header);
        ArrayList<Object> javaDocSlaves = new ArrayList<Object>();
        javaDocSlaves.add(settingsGroup);
        javaDocSlaves.add(html);
        javaDocSlaves.add(code);
        javaDocSlaves.add(blankJavadoc);
        javaDocSlaves.add(indentJavadoc);
        javaDocSlaves.add(nlParam);
        javaDocSlaves.add(blankLinesJavadoc);
        new OrController(javaDocMaster, javaDocSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentMasters.add(javadoc);
        indentMasters.add(header);
        indentMasters.add(indentJavadoc);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentSlaves.add(indentDesc);
        new Controller(indentMasters, indentSlaves){

            @Override
            protected boolean areSlavesEnabled() {
                return (javadoc.getChecked() || header.getChecked()) && indentJavadoc.getChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> blockMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        blockMasters.add(blockComment);
        blockMasters.add(header);
        ArrayList<Object> blockSlaves = new ArrayList<Object>();
        blockSlaves.add(blockSettingsGroup);
        blockSlaves.add(blankLinesBlock);
        new OrController(blockMasters, blockSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineWidthMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineWidthMasters.add(javadoc);
        lineWidthMasters.add(blockComment);
        lineWidthMasters.add(singleLineComments);
        lineWidthMasters.add(header);
        ArrayList<Object> lineWidthSlaves = new ArrayList<Object>();
        lineWidthSlaves.add(widthGroup);
        lineWidthSlaves.add(lineWidth);
        new OrController(lineWidthMasters, lineWidthSlaves);
    }

    @Override
    protected void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    @Override
    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefTrueFalse(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, FALSE_TRUE);
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefInsert(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, DO_NOT_INSERT_INSERT);
    }

    private static abstract class Controller
    implements Observer {
        private final Collection fMasters;
        private final Collection fSlaves;

        public Controller(Collection masters, Collection slaves) {
            this.fMasters = masters;
            this.fSlaves = slaves;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                ((ModifyDialogTabPage.CheckboxPreference)iter.next()).addObserver(this);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            boolean enabled = this.areSlavesEnabled();
            for (Object obj : this.fSlaves) {
                if (obj instanceof ModifyDialogTabPage.Preference) {
                    ((ModifyDialogTabPage.Preference)obj).setEnabled(enabled);
                    continue;
                }
                if (!(obj instanceof Control)) continue;
                ((Group)obj).setEnabled(enabled);
            }
        }

        public Collection getMasters() {
            return this.fMasters;
        }

        public Collection getSlaves() {
            return this.fSlaves;
        }

        protected abstract boolean areSlavesEnabled();
    }

    private static final class OrController
    extends Controller {
        public OrController(Collection masters, Collection slaves) {
            super(masters, slaves);
            this.update(null, null);
        }

        @Override
        protected boolean areSlavesEnabled() {
            Iterator iter = this.getMasters().iterator();
            while (iter.hasNext()) {
                if (!((ModifyDialogTabPage.CheckboxPreference)iter.next()).getChecked()) continue;
                return true;
            }
            return false;
        }
    }
}

