/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.TypeNameMatch;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.corext.util.OpenTypeHistory;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.dialogs.TypeSelectionExtension;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.vjet.eclipse.internal.ui.dialogs.VjoTypeSelectionComponent;

public class VjoTypeSelectionDialog
extends SelectionStatusDialog {
    private String fTitle;
    private boolean fMultipleSelection;
    private IRunnableContext fRunnableContext;
    private IDLTKSearchScope fScope;
    private int fElementKind;
    public static int typeFlag = 0;
    private String fInitialFilter;
    private int fSelectionMode;
    private ISelectionStatusValidator fValidator;
    private VjoTypeSelectionComponent fContent;
    private TypeSelectionExtension fExtension;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static boolean fgFirstTime = true;
    private IDLTKUILanguageToolkit fToolkit;

    public VjoTypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, IDLTKUILanguageToolkit toolkit) {
        this(parent, multi, context, scope, elementKinds, null, toolkit);
    }

    public VjoTypeSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, TypeSelectionExtension extension, IDLTKUILanguageToolkit toolkit) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMultipleSelection = multi;
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKind = elementKinds;
        this.fSelectionMode = 0;
        this.fExtension = extension;
        if (this.fExtension != null) {
            this.fValidator = this.fExtension.getSelectionValidator();
        }
        this.fToolkit = toolkit;
    }

    public void setFilter(String filter) {
        this.setFilter(filter, 2);
    }

    public void setFilter(String filter, int selectionMode) {
        this.fInitialFilter = filter;
        this.fSelectionMode = selectionMode;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected TypeNameMatch[] getSelectedTypes() {
        if (this.fContent == null || this.fContent.isDisposed()) {
            return null;
        }
        return this.fContent.getSelection();
    }

    public void create() {
        super.create();
        this.fContent.populate(this.fSelectionMode);
        this.getOkButton().setEnabled(this.fContent.getSelection().length > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fContent = new VjoTypeSelectionComponent(area, 0, this.getMessage(), this.fMultipleSelection, this.fScope, this.fElementKind, this.fInitialFilter, new TitleLabel(), this.fExtension, this.fToolkit);
        GridData gd = new GridData(1808);
        this.fContent.setLayoutData(gd);
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                VjoTypeSelectionDialog.this.handleDefaultSelected(VjoTypeSelectionDialog.this.fContent.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                VjoTypeSelectionDialog.this.handleWidgetSelected(VjoTypeSelectionDialog.this.fContent.getSelection());
            }
        });
        return area;
    }

    protected void handleDefaultSelected(TypeNameMatch[] selection) {
        if (selection.length == 0) {
            return;
        }
        this.okPressed();
    }

    protected void handleWidgetSelected(TypeNameMatch[] selection) {
        Status status = null;
        if (selection.length == 0) {
            status = new Status(4, DLTKUIPlugin.getPluginId(), 4, "", null);
        } else if (this.fValidator != null) {
            ArrayList<IType> jElements = new ArrayList<IType>();
            int i = 0;
            while (i < selection.length) {
                IType type = selection[i].getType();
                if (type == null) {
                    status = new Status(4, DLTKUIPlugin.getPluginId(), 4, Messages.format((String)DLTKUIMessages.TypeSelectionDialog_error_type_doesnot_exist, (Object)selection[i].getFullyQualifiedName()), null);
                    break;
                }
                jElements.add(type);
                ++i;
            }
            if (status == null) {
                status = this.fValidator.validate(jElements.toArray());
            }
        } else {
            status = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        }
        this.updateStatus((IStatus)status);
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)DLTKUIMessages.TypeSelectionDialog_error3Title, (String)DLTKUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (this.fInitialFilter == null && typeFlag == 0 && (window = DLTKUIPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0) {
            this.fInitialFilter = text;
            this.fSelectionMode = 2;
        }
        return super.open();
    }

    public boolean close() {
        boolean result;
        try {
            if (this.getReturnCode() == 0) {
                OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)this.fToolkit).save();
            }
        }
        finally {
            result = super.close();
        }
        return result;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    protected void computeResult() {
        TypeNameMatch[] selected = this.fContent.getSelection();
        if (selected == null || selected.length == 0) {
            this.setResult(null);
            return;
        }
        if (this.fScope == null) {
            this.fScope = this.fContent.getScope();
        }
        OpenTypeHistory history = OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)this.fToolkit);
        ArrayList<Object> result = new ArrayList<Object>(selected.length);
        int i = 0;
        while (i < selected.length) {
            TypeNameMatch typeInfo = selected[i];
            IType type = typeInfo.getType();
            if (!type.exists()) {
                ISourceModule module = type.getSourceModule();
                if (module.exists()) {
                    result.add(module);
                } else {
                    String title = DLTKUIMessages.TypeSelectionDialog_errorTitle;
                    IProjectFragment root = typeInfo.getProjectFragment();
                    ScriptElementLabels labels = this.fToolkit.getScriptElementLabels();
                    String containerName = labels.getElementLabel((IModelElement)root, 0x20000000000L);
                    String message = Messages.format((String)DLTKUIMessages.TypeSelectionDialog_dialogMessage, (Object[])new String[]{typeInfo.getFullyQualifiedName(), containerName});
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                    history.remove(typeInfo);
                    this.setResult(null);
                }
            } else {
                history.accessed(typeInfo);
                result.add(type);
            }
            ++i;
        }
        this.setResult(result);
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        class ConsistencyRunnable
        implements IRunnableWithProgress {
            ConsistencyRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (fgFirstTime) {
                    IJobManager manager = Job.getJobManager();
                    manager.join((Object)"org.eclipse.dltk.mod.ui", monitor);
                }
                OpenTypeHistory history = OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)VjoTypeSelectionDialog.this.fToolkit);
                if (fgFirstTime || history.isEmpty()) {
                    monitor.beginTask(DLTKUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    if (history.needConsistencyCheck()) {
                        this.loadTypes((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                        history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    } else {
                        this.loadTypes(monitor);
                    }
                    monitor.done();
                    fgFirstTime = false;
                } else {
                    history.checkConsistency(monitor);
                }
            }

            public boolean needsExecution() {
                OpenTypeHistory history = OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)VjoTypeSelectionDialog.this.fToolkit);
                return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
            }

            private void loadTypes(IProgressMonitor monitor) throws InvocationTargetException {
            }
        }
        ConsistencyRunnable runnable = new ConsistencyRunnable();
        if (!runnable.needsExecution()) {
            return;
        }
        IRunnableContext context = this.fRunnableContext != null ? this.fRunnableContext : PlatformUI.getWorkbench().getProgressService();
        context.run(true, true, (IRunnableWithProgress)runnable);
    }

    public static int getShownTypeFlag() {
        return typeFlag;
    }

    public static void setShownTypeFlag(int typeFlagP) {
        typeFlag = typeFlagP;
    }

    private class TitleLabel
    implements VjoTypeSelectionComponent.ITitleLabel {
        private TitleLabel() {
        }

        @Override
        public void setText(String text) {
            if (text == null || text.length() == 0) {
                VjoTypeSelectionDialog.this.getShell().setText(VjoTypeSelectionDialog.this.fTitle);
            } else {
                VjoTypeSelectionDialog.this.getShell().setText(Messages.format((String)DLTKUIMessages.TypeSelectionDialog2_title_format, (Object[])new String[]{VjoTypeSelectionDialog.this.fTitle, text}));
            }
        }
    }
}

