/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.compiler;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.compiler.ISourceElementRequestor;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceElementParserExtension;
import org.eclipse.dltk.mod.core.ISourceModuleInfoCache;
import org.eclipse.dltk.mod.core.search.indexing.VjoSourceIndexerRequestor;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.TopLevelVarTable;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.IfStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.TryStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeDependencyCollector;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.compiler.IJSSourceElementRequestor;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoSourceElementParser
implements ISourceElementParser,
ISourceElementParserExtension {
    private static final int ZERO_OFFSET = -1;
    private IJSSourceElementRequestor fRequestor = null;
    private ISourceModule sourceModule;
    private TypeSpaceMgr typeSpaceMgr = TypeSpaceMgr.getInstance();

    public void parseSourceModule(char[] contents, ISourceModuleInfoCache.ISourceModuleInfo info, char[] filename) {
        this.fRequestor.enterModule();
        try {
            IJstType type = this.getType(contents, filename);
            if (type == null) {
                return;
            }
            int length = contents != null ? contents.length : 0;
            this.processType(length, type);
            this.fRequestor.exitModule(length);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Error parsing source module", (Throwable)e);
            DLTKCore.getDefault().getLog().log((IStatus)status);
        }
    }

    public void parse(char[] contents, VjoSourceModule module) {
        TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
        IJstType type = mgr.findType((TypeName)module.getTypeName());
        if (type != null) {
            this.fRequestor.enterModule();
            this.processType(contents.length, type);
        }
    }

    private void processType(int contentsLength, IJstType type) {
        this.processPackage(type);
        JstTypeDependencyCollector c = new JstTypeDependencyCollector();
        Collection imports = c.getDependencyRefs(type).values();
        this.processImports(imports);
        this.processTypeBody(contentsLength, type);
    }

    private void processTypeBody(int contentsLength, IJstType type) {
        IJSSourceElementRequestor.JSTypeInfo typeInfo = new IJSSourceElementRequestor.JSTypeInfo();
        this.processTypeName(type, typeInfo);
        this.setTypeModifiers(type, typeInfo);
        this.processSupertypes(type, typeInfo);
        this.fRequestor.enterType(typeInfo);
        this.processTypeFields(type);
        this.processTypeMethods(type);
        this.processConstructor(type);
        this.processInitializer(type);
        this.processInnerTypes(type);
        this.processGlobals(type);
        this.fRequestor.exitType(contentsLength);
    }

    private void processGlobals(IJstType type) {
        List globalVars = type.getGlobalVars();
        this.processGlobalVars(globalVars);
    }

    private void processGlobalVars(List<? extends IJstGlobalVar> globalVars) {
        HashSet<IJstGlobalFunc> globalFunctions = new HashSet<IJstGlobalFunc>();
        for (IJstGlobalVar iJstGlobalVar : globalVars) {
            if (iJstGlobalVar.isFunc()) {
                IJstGlobalFunc globalFunction = iJstGlobalVar.getFunction();
                if (globalFunctions.contains(globalFunction)) {
                    this.processGlobalFunc(globalFunction, true);
                } else {
                    this.processGlobalFunc(globalFunction, false);
                }
                globalFunctions.add(globalFunction);
                continue;
            }
            this.processGlobalProp(iJstGlobalVar.getProperty());
        }
    }

    private void processGlobalProp(IJstGlobalProp globalProperty) {
        this.processField((IJstProperty)globalProperty, false, true);
    }

    private void processGlobalFunc(IJstGlobalFunc globalFunc, boolean overload) {
        this.processMethod((IJstMethod)globalFunc, overload, true);
    }

    private void processInnerTypes(IJstType type) {
        List innerTypes = type.getEmbededTypes();
        if (innerTypes != null && !innerTypes.isEmpty()) {
            for (IJstType innerType : innerTypes) {
                JstSource source = innerType.getSource();
                if (source == null) continue;
                this.processTypeBody(source.getEndOffSet(), innerType);
            }
        }
    }

    private void processInitializer(IJstType type) {
        JstBlock block = type.getInitBlock();
        if (block != null && block.getSource() != null) {
            int start = block.getSource().getStartOffSet();
            int end = block.getSource().getEndOffSet();
            this.fRequestor.enterInitializer(start, 256);
            this.processStatements(block);
            this.fRequestor.exitInitializer(end);
        }
    }

    private void processVarMap(Map<String, IJstNode> varMap) {
        for (Map.Entry<String, IJstNode> varz : varMap.entrySet()) {
            String varName = varz.getKey();
            IJstNode node = varz.getValue();
            if (node instanceof JstIdentifier) {
                IJstNode jstBinding = ((JstIdentifier)node).getJstBinding();
                if (!(jstBinding instanceof JstFuncType)) continue;
                this.processMethod(((JstFuncType)jstBinding).getFunction(), varName);
                continue;
            }
            if (!(node instanceof JstMethod)) continue;
            this.processMethod((IJstMethod)((JstMethod)node), varName);
        }
    }

    private void processConstructor(IJstType type) {
        IJstMethod orginalConstructor = type.getConstructor();
        List constructorList = JstTypeHelper.getSignatureConstructors((IJstType)type);
        ArrayList<IJstMethod> constructors = new ArrayList<IJstMethod>();
        for (IJstMethod constructor : constructorList) {
            if (constructor == null || CodeCompletionUtils.isSynthesizedElement((Object)constructor)) continue;
            constructors.add(constructor);
            if (constructor.getSource() == null) {
                ((JstMethod)constructor).setSource(orginalConstructor.getSource());
            }
            if (constructor.getName().getSource() != null) continue;
            constructor.getName().setSource(orginalConstructor.getName().getSource());
        }
        this.processMethods(constructors);
    }

    private void processTypeMethods(IJstType type) {
        ArrayList nonConstructorMethods = new ArrayList(JstTypeHelper.getSignatureMethods((IJstType)type));
        this.processMethods(nonConstructorMethods);
    }

    private List<IJstMethod> filterDispatchTypeMethod(IJstType type) {
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>();
        IJstMethod dispacthMethod = null;
        for (IJstMethod mtd : type.getMethods()) {
            if (mtd.isDispatcher()) {
                dispacthMethod = mtd;
                methods.addAll(mtd.getOverloaded());
            } else {
                methods.add(mtd);
            }
            methods.remove(dispacthMethod);
        }
        return methods;
    }

    private void processTypeFields(IJstType type) {
        List properties = type.getStaticProperties();
        this.processFields(properties, true);
        properties = type.getInstanceProperties();
        this.processFields(properties, false);
        properties = type.getEnumValues();
        this.processFields(properties, false);
    }

    private void processSupertypes(IJstType type, IJSSourceElementRequestor.JSTypeInfo typeInfo) {
        List inheritedTypes = type.getExtends();
        String[] inherits = VjoSourceElementParser.getTypesNames(inheritedTypes);
        if (type.isInterface()) {
            typeInfo.superinterfaces = inherits;
        } else {
            typeInfo.superclasses = inherits;
            List implementedInterfaces = type.getSatisfies();
            typeInfo.superinterfaces = VjoSourceElementParser.getTypesNames(implementedInterfaces);
        }
    }

    private void setTypeModifiers(IJstType type, IJSSourceElementRequestor.JSTypeInfo typeInfo) {
        JstModifiers modifiers = type.getModifiers();
        typeInfo.modifiers = 128;
        if (modifiers.isFinal()) {
            typeInfo.modifiers |= 8;
        }
        if (modifiers.isAbstract()) {
            typeInfo.modifiers |= 1;
        }
        if (type.isInterface()) {
            typeInfo.modifiers |= 0x200;
        } else if (type.isEnum()) {
            typeInfo.modifiers |= 0x4000;
        } else if (type.isMixin()) {
            typeInfo.modifiers |= 0x8000;
        } else if (type.getModifiers().isStatic()) {
            typeInfo.modifiers |= 0x100;
        }
    }

    private void processTypeName(IJstType type, IJSSourceElementRequestor.JSTypeInfo typeInfo) {
        String typeName;
        JstSource typeNameSource = type.getSource();
        if (typeNameSource != null) {
            typeInfo.declarationStart = typeNameSource.getStartOffSet();
            typeInfo.nameSourceStart = typeNameSource.getStartOffSet();
            typeInfo.nameSourceEnd = typeNameSource.getEndOffSet();
        }
        if ((typeName = type.getSimpleName()) == null) {
            typeName = "";
        }
        typeInfo.name = typeName;
    }

    private void processPackage(IJstType type) {
        JstPackage pack = type.getPackage();
        if (pack != null) {
            String packageName = pack.getName();
            JstSource source = pack.getSource();
            int declarationStart = source != null ? source.getStartOffSet() : -1;
            int declarationEnd = source != null ? source.getEndOffSet() : -1;
            this.fRequestor.acceptPackage(declarationStart, declarationEnd, packageName != null ? packageName.toCharArray() : new char[]{});
        }
    }

    private IJstType getType(char[] contents, char[] filename) {
        IJstType type = null;
        IVjoSourceModule module = (IVjoSourceModule)this.sourceModule;
        type = module.getJstType();
        if (type == null) {
            String name = String.valueOf(filename);
            TypeName typeName = new TypeName("JsNativeLib", name);
            TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
            type = mgr.findType(typeName);
        }
        this.fRequestor.enterModule();
        return type;
    }

    private void processFields(Collection<IJstProperty> properties, boolean isProps) {
        for (IJstProperty jsPropertyMeta : properties) {
            if (CodeCompletionUtils.isSynthesizedElement((Object)jsPropertyMeta)) continue;
            this.processField(jsPropertyMeta, isProps, false);
        }
    }

    private void processField(IJstProperty jsPropertyMeta, boolean isProps, boolean isGlobal) {
        IJSSourceElementRequestor.JSFieldInfo fieldInfo = new IJSSourceElementRequestor.JSFieldInfo();
        fieldInfo.name = jsPropertyMeta.getName().getName();
        IJstType propertyType = jsPropertyMeta.getType();
        if (propertyType != null) {
            String fieldType = null;
            fieldType = propertyType instanceof JstFuncType ? VjoSourceElementParser.getFullMethodString(fieldInfo.name, ((JstFuncType)propertyType).getFunction(), jsPropertyMeta.getOwnerType(), false) : jsPropertyMeta.getType().getName();
            fieldInfo.m_type = fieldType;
        } else {
            fieldInfo.m_type = "Object";
        }
        JstSource nameSource = jsPropertyMeta.getName().getSource();
        JstSource source = jsPropertyMeta.getSource();
        fieldInfo.declarationStart = source != null ? source.getStartOffSet() : -1;
        JstModifiers jstModifiers = jsPropertyMeta.getModifiers();
        int n = fieldInfo.modifiers = isGlobal ? 16384 : Util.getModifiers(jstModifiers);
        if (isProps) {
            fieldInfo.m_initializationSource = VjoSourceElementParser.getSourceWithoutQuates(jsPropertyMeta.getValue());
        }
        int start = nameSource != null ? nameSource.getStartOffSet() : -1;
        int end = this.getEndOffset(nameSource);
        fieldInfo.nameSourceStart = start;
        fieldInfo.nameSourceEnd = end;
        if (jsPropertyMeta instanceof JstProxyProperty) {
            IFile actualResource;
            IJstType actualOwnerType = jsPropertyMeta.getOwnerType();
            String groupName = actualOwnerType.getPackage().getGroupName();
            URI uri = (URI)this.typeSpaceMgr.getTypeToFileMap().get(String.valueOf(groupName) + "#" + actualOwnerType.getName());
            if (uri != null && (actualResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
                fieldInfo.resource = actualResource;
            }
        }
        this.fRequestor.enterField(fieldInfo);
        if (jsPropertyMeta instanceof JstProperty && jsPropertyMeta.getType() instanceof JstObjectLiteralType && jsPropertyMeta.getType().getRootType().isOType()) {
            List properties = jsPropertyMeta.getType().getProperties();
            for (IJstProperty iJstProperty : properties) {
                this.processField(iJstProperty, false, false);
            }
        }
        this.fRequestor.exitField(this.getEndOffset(source));
    }

    private int getEndOffset(JstSource source) {
        return source != null ? source.getEndOffSet() : -1;
    }

    private static String getSourceWithoutQuates(ISimpleTerm value) {
        char[] val;
        if (value != null && (val = value.toSimpleTermText().toCharArray()).length > 0) {
            if (val[0] == '\"' && val[val.length - 1] == '\"' || val[0] == '\'' && val[val.length - 1] == '\'') {
                return new String(val, 1, val.length - 2);
            }
            return value.toSimpleTermText();
        }
        return null;
    }

    private void processMethods(Collection<? extends IJstMethod> functions) {
        HashSet<String> methodSet = new HashSet<String>();
        for (IJstMethod iJstMethod : functions) {
            String methodName = iJstMethod.getName().getName();
            if (methodSet.contains(methodName)) {
                this.processMethod(iJstMethod, true);
            } else {
                this.processMethod(iJstMethod, false);
            }
            methodSet.add(methodName);
        }
    }

    private void processMethod(IJstMethod method, boolean overload) {
        this.processMethod(method, overload, false);
    }

    private void processMethod(IJstMethod method, String name) {
        IJSSourceElementRequestor.JSMethodInfo methodInfo = new IJSSourceElementRequestor.JSMethodInfo();
        methodInfo.name = name;
        methodInfo.m_returnType = method.getRtnType() != null ? method.getRtnType().getName() : "void";
        List parameters = method.getArgs();
        String[] paramNames = new String[parameters.size()];
        String[] paramTypes = new String[parameters.size()];
        boolean[] isVariables = new boolean[parameters.size()];
        int i = 0;
        ArrayList<IJSSourceElementRequestor.JSFieldInfo> args = new ArrayList<IJSSourceElementRequestor.JSFieldInfo>();
        for (JstArg jsParam : parameters) {
            IJSSourceElementRequestor.JSFieldInfo argInfo = new IJSSourceElementRequestor.JSFieldInfo();
            argInfo.name = jsParam.getName();
            argInfo.m_type = jsParam.getType().getName();
            JstSource source = jsParam.getSource();
            argInfo.declarationStart = this.getStartOffSet(source);
            argInfo.nameSourceStart = this.getStartOffSet(source);
            argInfo.nameSourceEnd = this.getEndOffSet(source);
            argInfo.declarationStart = this.getStartOffSet(source);
            args.add(argInfo);
            paramNames[i] = jsParam.getName();
            paramTypes[i] = jsParam.getType().getName();
            isVariables[i] = jsParam.isVariable();
            ++i;
        }
        methodInfo.parameterNames = paramNames;
        methodInfo.m_parameterTypes = paramTypes;
        methodInfo.b_isVariables = isVariables;
        JstSource source = method.getSource();
        methodInfo.declarationStart = this.getStartOffSet(source);
        JstSource nameSource = method.getName().getSource();
        if (nameSource == null) {
            nameSource = source;
        }
        methodInfo.nameSourceStart = this.getStartOffSet(nameSource);
        methodInfo.nameSourceEnd = this.getEndOffSet(nameSource);
        this.fRequestor.enterMethod(methodInfo);
        for (IJSSourceElementRequestor.JSFieldInfo fieldInfo : args) {
            if (fieldInfo.name == null) continue;
            this.fRequestor.enterField(fieldInfo);
            this.fRequestor.exitField(fieldInfo.nameSourceEnd);
        }
        this.processStatements(method.getBlock());
        this.fRequestor.exitMethod(this.getEndOffSet(source));
    }

    private void processMethod(IJstMethod method, boolean overload, boolean isGlobal) {
        IJSSourceElementRequestor.JSMethodInfo methodInfo = new IJSSourceElementRequestor.JSMethodInfo();
        methodInfo.m_isConstructor = "constructs".equals(method.getName().getName());
        if (methodInfo.m_isConstructor) {
            methodInfo.name = method.getName().getName();
            methodInfo.m_returnType = "void";
        } else {
            methodInfo.name = method.getName().getName();
            if (method.getRtnType() != null) {
                methodInfo.m_returnType = method.getRtnType().getName();
                if (methodInfo.m_returnType == null) {
                    methodInfo.m_returnType = "void";
                }
            } else {
                methodInfo.m_returnType = "void";
            }
        }
        List parameters = method.getArgs();
        String[] paramNames = new String[parameters.size()];
        String[] paramTypes = new String[parameters.size()];
        boolean[] isVariables = new boolean[parameters.size()];
        int i = 0;
        ArrayList<IJSSourceElementRequestor.JSFieldInfo> args = new ArrayList<IJSSourceElementRequestor.JSFieldInfo>();
        for (JstArg jsParam : parameters) {
            IJSSourceElementRequestor.JSFieldInfo argInfo = new IJSSourceElementRequestor.JSFieldInfo();
            argInfo.name = jsParam.getName();
            argInfo.m_type = jsParam.getType().getName();
            JstSource source = jsParam.getSource();
            argInfo.declarationStart = this.getStartOffSet(source);
            argInfo.nameSourceStart = this.getStartOffSet(source);
            argInfo.nameSourceEnd = this.getEndOffSet(source);
            argInfo.declarationStart = this.getStartOffSet(source);
            args.add(argInfo);
            paramNames[i] = jsParam.getName();
            paramTypes[i] = jsParam.getType().getName();
            isVariables[i] = jsParam.isVariable();
            ++i;
        }
        methodInfo.parameterNames = paramNames;
        methodInfo.m_parameterTypes = paramTypes;
        methodInfo.b_isVariables = isVariables;
        JstSource source = method.getSource();
        methodInfo.declarationStart = this.getStartOffSet(source);
        methodInfo.modifiers = isGlobal ? 16384 : Util.getModifiers(method.getModifiers());
        JstSource nameSource = method.getName().getSource();
        if (nameSource == null && method.getParentNode() != null) {
            String methodName = method.getName().getName();
            IJstType type = method.getOwnerType();
            if (type.getMethod(methodName) != null) {
                nameSource = type.getMethod(methodName).getName().getSource();
            }
            if (type.getConstructor() != null && type.getConstructor().getName().equals((Object)methodName)) {
                nameSource = type.getConstructor().getName().getSource();
            }
        }
        methodInfo.nameSourceStart = this.getStartOffSet(nameSource);
        methodInfo.nameSourceEnd = this.getEndOffSet(nameSource);
        if (method instanceof JstProxyMethod) {
            IFile actualResource;
            IJstType actualOwnerType = method.getOwnerType();
            String groupName = actualOwnerType.getPackage().getGroupName();
            URI uri = (URI)this.typeSpaceMgr.getTypeToFileMap().get(String.valueOf(groupName) + "#" + actualOwnerType.getName());
            if (uri != null && (actualResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()))).exists()) {
                methodInfo.resource = actualResource;
            }
        }
        this.fRequestor.enterMethod(methodInfo);
        for (IJSSourceElementRequestor.JSFieldInfo fieldInfo : args) {
            if (fieldInfo.name == null) continue;
            this.fRequestor.enterField(fieldInfo);
            this.fRequestor.exitField(fieldInfo.nameSourceEnd);
        }
        if (!overload) {
            this.processStatements(method.getBlock());
        }
        this.fRequestor.exitMethod(this.getEndOffSet(source));
    }

    private int getEndOffSet(JstSource source) {
        return source != null ? source.getEndOffSet() : -1;
    }

    private int getStartOffSet(JstSource source) {
        return source != null ? source.getStartOffSet() : -1;
    }

    private void processImports(Collection<? extends IJstTypeReference> imports) {
        for (IJstTypeReference iJstTypeReference : imports) {
            String importDecl = iJstTypeReference.getReferencedType().getName();
            boolean isOnDemand = false;
            int flag = 0;
            if (importDecl == null) continue;
            String[] segments = importDecl.split("\\.");
            int len = segments.length;
            char[][] tokens = new char[len][];
            int i = 0;
            while (i < len) {
                tokens[i] = segments[i].toCharArray();
                ++i;
            }
            JstSource source = iJstTypeReference.getSource();
            int start = source == null ? -1 : source.getStartOffSet();
            int end = source == null ? -1 : source.getEndOffSet();
            this.fRequestor.acceptImport(start, end, tokens, isOnDemand, flag);
        }
    }

    private void processStatements(JstBlock block) {
        if (block != null) {
            Map<String, IJstNode> varMap = this.getVarMap(block);
            if (varMap != null) {
                this.processVarMap(varMap);
            }
            List statements = block.getStmts();
            for (IStmt statement : statements) {
                this.processStatement((IJstNode)statement);
            }
        }
    }

    private Map<String, IJstNode> getVarMap(JstBlock block) {
        VarTable vars = block.getVarTable();
        Map varMap = null;
        varMap = vars instanceof TopLevelVarTable ? ((TopLevelVarTable)vars).getSelfVarNodes() : vars.getVarNodes();
        if (varMap.isEmpty()) {
            return null;
        }
        return varMap;
    }

    private void processStatement(IJstNode statement) {
        if (statement instanceof AssignExpr) {
            AssignExpr assign = (AssignExpr)statement;
            this.processAssignExpr(assign);
        } else if (statement instanceof ForStmt) {
            ForStmt forStatement = (ForStmt)statement;
            IInitializer initializer = forStatement.getInitializers();
            if (initializer != null) {
                List initializers = initializer.getAssignments();
                for (AssignExpr assignExpr : initializers) {
                    this.processAssignExpr(assignExpr);
                }
            }
            this.processStatement((IJstNode)forStatement.getCondition());
            List updaters = forStatement.getUpdaters();
            for (IExpr updater : updaters) {
                this.processExpression(updater);
            }
            this.processStatements(forStatement.getBody());
        } else if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            this.processExpression((IExpr)whileStmt.getCondition());
            this.processStatements(whileStmt.getBody());
        } else if (statement instanceof TryStmt) {
            TryStmt tryStmt = (TryStmt)statement;
            this.processStatements(tryStmt.getBody());
            List catchStmts = tryStmt.getCatchBlock(true).getStmts();
            for (IStmt catchStmt : catchStmts) {
                this.processStatement((IJstNode)catchStmt);
            }
            this.processStatements(tryStmt.getFinallyBlock(false));
        } else if (statement instanceof CatchStmt) {
            CatchStmt catchStmt = (CatchStmt)statement;
            this.processJstVar(catchStmt.getException());
            this.processStatements(catchStmt.getBody());
        } else if (statement instanceof SwitchStmt) {
            SwitchStmt switchStmt = (SwitchStmt)statement;
            this.processExpression(switchStmt.getExpr());
            List statements = switchStmt.getBody().getStmts();
            if (statements != null) {
                for (IStmt stmt : statements) {
                    this.processStatement((IJstNode)stmt);
                }
            }
        } else if (statement instanceof SwitchStmt.CaseStmt) {
            this.processExpression(((SwitchStmt.CaseStmt)statement).getExpr());
        } else if (statement instanceof IfStmt) {
            List elseIfStmts;
            IfStmt ifStmt = (IfStmt)statement;
            this.processExpression((IExpr)ifStmt.getCondition());
            this.processStatements(ifStmt.getBody());
            if (ifStmt.getElseIfBlock(false) != null && (elseIfStmts = ifStmt.getElseIfBlock(false).getStmts()) != null) {
                for (IStmt elseIfStmt : elseIfStmts) {
                    this.processStatement((IJstNode)elseIfStmt);
                }
            }
            this.processStatements(ifStmt.getElseBlock(false));
        } else if (statement instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)statement;
            this.processExpression(throwStmt.getExpression());
        } else if (statement instanceof RtnStmt) {
            RtnStmt returnStmt = (RtnStmt)statement;
            this.processExpression(returnStmt.getExpression());
        } else if (statement instanceof MtdInvocationExpr) {
            this.processExpression((IExpr)statement);
            if (((MtdInvocationExpr)statement).getQualifyExpr() != null) {
                this.processExpression(((MtdInvocationExpr)statement).getQualifyExpr());
            }
        } else if (statement instanceof JstVars) {
            this.processLocalVarDecl((JstVars)statement);
        } else if (statement instanceof ExprStmt) {
            this.processExpression(((ExprStmt)statement).getExpr());
        } else if (VjetPlugin.DEBUG) {
            System.err.println("DID NOT PROCESS STATEMENT: " + statement.getClass().getName() + ":" + statement);
        }
    }

    private void processJstVar(JstVar jstVar) {
        JstSource source = jstVar.getSource();
        IJSSourceElementRequestor.JSFieldInfo fieldInfo = new IJSSourceElementRequestor.JSFieldInfo();
        fieldInfo.name = jstVar.getName();
        fieldInfo.declarationStart = source.getStartOffSet();
        fieldInfo.nameSourceStart = source.getStartOffSet();
        fieldInfo.nameSourceEnd = source.getEndOffSet();
        IJstType type = jstVar.getType();
        String typeName = "Object";
        if (type != null) {
            typeName = type.getName();
        }
        fieldInfo.m_type = typeName;
        this.fRequestor.enterField(fieldInfo);
        this.fRequestor.exitField(fieldInfo.nameSourceEnd);
    }

    private void processLocalVarDecl(JstVars jstVars) {
        List inits = jstVars.getAssignments();
        int i = 0;
        while (i < inits.size()) {
            AssignExpr assignExpr = (AssignExpr)inits.get(i);
            JstIdentifier localVar = (JstIdentifier)assignExpr.getLHS();
            IJstType type = jstVars.getType();
            JstSource source = localVar.getSource();
            IJSSourceElementRequestor.JSFieldInfo fieldInfo = new IJSSourceElementRequestor.JSFieldInfo();
            fieldInfo.name = localVar.getName();
            fieldInfo.declarationStart = source.getStartOffSet();
            fieldInfo.nameSourceStart = source.getStartOffSet();
            fieldInfo.nameSourceEnd = source.getEndOffSet();
            String typeName = "Object";
            if (type != null) {
                typeName = type instanceof JstFuncType ? VjoSourceElementParser.getFullMethodString(localVar.getName(), ((JstFuncType)type).getFunction(), (IJstType)jstVars.getOwnerType(), false) : (type instanceof JstFunctionRefType ? VjoSourceElementParser.getFullMethodString(localVar.getName(), ((JstFunctionRefType)type).getMethodRef(), (IJstType)jstVars.getOwnerType(), false) : type.getName());
            }
            fieldInfo.m_type = typeName;
            this.fRequestor.enterField(fieldInfo);
            this.processExpression(assignExpr.getExpr());
            this.fRequestor.exitField(assignExpr.getSource().getEndOffSet());
            ++i;
        }
    }

    public static String getFullMethodString(IJstMethod method, IJstType ownerType, boolean optional) {
        return VjoSourceElementParser.getFullMethodString(method.getName().getName(), method, ownerType, optional);
    }

    public static String getFullMethodString(String name, IJstMethod method, IJstType ownerType, boolean optional) {
        String aname;
        StringBuilder strBldr = new StringBuilder();
        name = VjoSourceElementParser.renameInvoke(method, name);
        if (method instanceof JstConstructor) {
            JstConstructor c = (JstConstructor)method;
            name = c.getOwnerType().getName();
        }
        strBldr.append(name);
        strBldr.append("(");
        IJstType ref = method.getRtnType();
        String oname = "";
        if (ownerType != null) {
            oname = ownerType.getSimpleName();
        }
        if ((aname = VjoSourceElementParser.getJstArgsString(method)).length() > 0) {
            strBldr.append(aname);
        }
        strBldr.append(")");
        if (optional) {
            strBldr.append(" ? ");
        }
        if (ref != null) {
            String rname = ref.getSimpleName();
            strBldr.append(" ").append(rname);
        }
        strBldr.append(" - ");
        strBldr.append(oname);
        return strBldr.toString();
    }

    public static String renameInvoke(IJstMethod method, String name) {
        IJstType ownerType;
        if ("_invoke_".equals(name) && (ownerType = method.getOwnerType()) != null && ownerType.isFType()) {
            name = ownerType.getSimpleName();
        }
        return name;
    }

    public static String getJstArgsString(IJstMethod method) {
        String result;
        StringBuffer buffer = new StringBuffer();
        List args = method.getArgs();
        if (args != null && !args.isEmpty()) {
            for (JstArg arg : args) {
                IJstType type = arg.getType();
                if (type != null) {
                    if (type instanceof JstFuncType) {
                        buffer.append(VjoSourceElementParser.getFullMethodString(arg.getName(), ((JstFuncType)type).getFunction(), (IJstType)arg.getOwnerType(), false));
                    } else if (type instanceof JstFunctionRefType) {
                        buffer.append(VjoSourceElementParser.getFullMethodString(arg.getName(), ((JstFunctionRefType)type).getMethodRef(), (IJstType)arg.getOwnerType(), false));
                    } else {
                        buffer.append(type.getSimpleName());
                    }
                } else {
                    buffer.append("Object");
                }
                buffer.append(" " + arg.getName());
                buffer.append(", ");
            }
        }
        if ((result = buffer.toString()).length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private void processIdentifier(IJstType type, JstIdentifier identifier) {
        JstSource source = identifier.getSource();
        IJSSourceElementRequestor.JSFieldInfo fieldInfo = new IJSSourceElementRequestor.JSFieldInfo();
        fieldInfo.name = identifier.getName();
        fieldInfo.declarationStart = source.getStartOffSet();
        fieldInfo.nameSourceStart = source.getStartOffSet();
        fieldInfo.nameSourceEnd = source.getEndOffSet();
        String typeName = "Object";
        if (type != null) {
            typeName = type.getName();
        }
        fieldInfo.m_type = typeName;
        this.fRequestor.enterField(fieldInfo);
        this.fRequestor.exitField(fieldInfo.nameSourceEnd);
    }

    private void processAssignExpr(AssignExpr assignExpr) {
        ILHS lhs = assignExpr.getLHS();
        if (lhs instanceof IExpr) {
            this.processExpression((IExpr)lhs);
        } else if (lhs instanceof JstVar) {
            this.processJstVar((JstVar)lhs);
        }
        this.processExpression(assignExpr.getExpr());
    }

    private void processExpression(IExpr expression) {
        if (expression == null) {
            return;
        }
        if (expression instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)expression;
            if ("this".equals(identifier.getName()) || "self".equals(identifier.getName()) || "base".equals(identifier.getName())) {
                return;
            }
            JstSource source = identifier.getSource();
            this.fRequestor.acceptFieldReference(identifier.getName().toCharArray(), source.getStartOffSet());
        } else if (expression instanceof MtdInvocationExpr) {
            MtdInvocationExpr mtdInvocation = (MtdInvocationExpr)expression;
            JstSource source = mtdInvocation.getMethodIdentifier().getSource();
            int startOffset = source == null ? -1 : source.getStartOffSet();
            int endOffset = source == null ? -1 : source.getEndOffSet();
            this.fRequestor.acceptMethodReference(mtdInvocation.getMethodIdentifier().toExprText().toCharArray(), mtdInvocation.getArgs().size(), startOffset, endOffset);
            if (mtdInvocation.getQualifyExpr() != null) {
                this.processExpression(mtdInvocation.getQualifyExpr());
            }
        } else if (expression instanceof BoolExpr) {
            BoolExpr boolExpr = (BoolExpr)expression;
            this.processExpression(boolExpr.getLeft());
            this.processExpression(boolExpr.getRight());
        } else if (expression instanceof PostfixExpr) {
            this.processExpression(((PostfixExpr)expression).getIdentifier());
        } else if (expression instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)expression;
            this.processExpression(infixExpr.getLeft());
            this.processExpression(infixExpr.getRight());
        } else if (expression instanceof ParenthesizedExpr) {
            this.processExpression(((ParenthesizedExpr)expression).getExpression());
        } else if (expression instanceof PrefixExpr) {
            this.processExpression(((PrefixExpr)expression).getIdentifier());
        } else if (expression instanceof FieldAccessExpr) {
            this.processExpression((IExpr)((FieldAccessExpr)expression).getName());
            this.processExpression(((FieldAccessExpr)expression).getExpr());
        } else if (expression instanceof ArrayAccessExpr) {
            this.processExpression(((ArrayAccessExpr)expression).getExpr());
            this.processExpression(((ArrayAccessExpr)expression).getIndex());
        } else if (expression instanceof ObjLiteral) {
            this.processNVs((ObjLiteral)expression);
        } else {
            boolean cfr_ignored_0 = expression instanceof FuncExpr;
        }
    }

    private void processNVs(ObjLiteral expression) {
        for (NV nv : expression.getNVs()) {
            JstIdentifier identifier = nv.getIdentifier();
            IJstProperty p = expression.getResultType().getProperty(identifier.getName());
            IJstMethod m = expression.getResultType().getMethod(identifier.getName());
            JstSource source = nv.getIdentifier().getSource();
            IJSSourceElementRequestor.JSFieldInfo fieldInfo = new IJSSourceElementRequestor.JSFieldInfo();
            fieldInfo.name = identifier.getName();
            fieldInfo.declarationStart = source.getStartOffSet();
            fieldInfo.nameSourceStart = identifier.getSource().getStartOffSet();
            fieldInfo.nameSourceEnd = identifier.getSource().getEndOffSet();
            IJstType type = null;
            if (p != null) {
                type = p.getType();
            } else if (m != null) {
                type = m.getRtnType();
            }
            String typeName = "Object";
            if (type != null) {
                typeName = type.getName();
            }
            fieldInfo.m_type = typeName;
            this.fRequestor.enterField(fieldInfo);
            if (nv.getValue() instanceof ObjLiteral) {
                this.processNVs((ObjLiteral)nv.getValue());
                this.fRequestor.exitField(fieldInfo.nameSourceEnd);
                continue;
            }
            this.fRequestor.exitField(fieldInfo.nameSourceEnd);
        }
    }

    public void setReporter(IProblemReporter reporter) {
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        if (requestor instanceof IJSSourceElementRequestor) {
            this.fRequestor = (IJSSourceElementRequestor)requestor;
        }
    }

    private static String[] getTypesNames(List<? extends IJstType> types) {
        String[] names = new String[types.size()];
        int idx = 0;
        for (IJstType iJstType : types) {
            names[idx++] = iJstType.getName();
        }
        return names;
    }

    public void parseSourceModule(ISourceModule module, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        if (this.fRequestor instanceof VjoSourceIndexerRequestor) {
            return;
        }
        this.sourceModule = module;
        this.parseSourceModule(module.getContentsAsCharArray(), mifo, module.getFileName());
    }

    public void setScriptProject(IScriptProject project) {
    }
}

