/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select.translator;

import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.DefaultNodeTranslator;

public class JstVarsTranslator
extends DefaultNodeTranslator {
    @Override
    public IModelElement[] convert(IVjoSourceModule module, IJstNode node) {
        JstMethod jstMethod;
        JstVars jstVars = (JstVars)node;
        if (jstVars.getSource() == null) {
            return null;
        }
        IJstMethod declaringBlock = CodeassistUtils.findDeclaringMethod((IJstNode)jstVars);
        if (declaringBlock == null) {
            declaringBlock = CodeassistUtils.findDeclaringBlock((IJstNode)jstVars);
        }
        IModelElement element = null;
        IModelElement[] elementFromAry = JstNodeDLTKElementResolver.lookupAndConvert((IJstNode)declaringBlock);
        if (elementFromAry != null && elementFromAry.length == 1) {
            element = elementFromAry[0];
        }
        if (declaringBlock instanceof JstMethod && (jstMethod = (JstMethod)declaringBlock) != null) {
            IModelElement[] convert;
            if (!jstMethod.getOverloaded().isEmpty()) {
                convert = JstNodeDLTKElementResolver.convert(module, (IJstNode)jstMethod.getOverloaded().get(0));
                if (convert != null && convert.length > 0) {
                    element = convert[0];
                }
            } else {
                convert = JstNodeDLTKElementResolver.convert(module, (IJstNode)jstMethod);
                if (convert != null && convert.length > 0) {
                    element = convert[0];
                }
            }
        }
        if (element == null) {
            return null;
        }
        try {
            IMember dltkMethod = (IMember)element;
            String localVarName = CodeassistUtils.getFirstVariableName(jstVars);
            IModelElement[] children = dltkMethod.getChildren();
            int i = 0;
            while (i < children.length) {
                if (8 == children[i].getElementType() && children[i].getElementName().equals(localVarName)) {
                    return new IModelElement[]{children[i]};
                }
                ++i;
            }
        }
        catch (ModelException e) {
            VjetPlugin.error(e.getLocalizedMessage(), e);
        }
        return null;
    }
}

