/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.mod.compiler.problem.DefaultProblem;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.validation.BasicValidator;
import org.eclipse.vjet.eclipse.core.validation.utils.ProblemUtility;

public class ValidationEntry {
    public static List<DefaultProblem> validate(String fileName, IJstType jstType, ErrorList errors, ErrorList warnings) {
        ArrayList<DefaultProblem> probs = new ArrayList<DefaultProblem>();
        if (errors != null) {
            probs.addAll(ProblemUtility.reportErrors(fileName, errors));
        }
        if (probs.size() == 0) {
            probs.addAll(ValidationEntry.validator(jstType));
        }
        if (warnings != null) {
            probs.addAll(ProblemUtility.reportWarnings(fileName, warnings));
        }
        return probs;
    }

    public static List<DefaultProblem> validator(IJstType jstType) {
        ArrayList<DefaultProblem> probs = new ArrayList<DefaultProblem>();
        try {
            probs.addAll(BasicValidator.getInstance().validate(jstType));
        }
        catch (CoreException e1) {
            DLTKCore.error((String)e1.toString(), (Throwable)e1);
        }
        return probs;
    }

    public static boolean isEnableVjetValidation() {
        Preferences ps = VjetPlugin.getDefault().getPluginPreferences();
        return ps.getBoolean("VJETVALIDATION");
    }
}

