/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;

public class VjoTypeDeclarationSearcher
extends AbstractVjoElementSearcher {
    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return TypeDeclarationPattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
        IType type = (IType)params.getElement();
        System.out.println("Searching for declaration of " + type.getElementName());
        if (this.isInScope(type)) {
            try {
                ISourceRange nameRange = type.getNameRange();
                VjoMatch match = VjoMatchFactory.createFieldMatch(type, nameRange.getOffset(), nameRange.getLength());
                result.add(match);
            }
            catch (ModelException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Wrong name range", (Throwable)e));
            }
        }
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
    }
}

