/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;

public class VjoPackageReferencesVisitor
implements IJstVisitor {
    private IScriptFolder pkg;
    private List<VjoMatch> result;
    private IJstType dependentType;

    public VjoPackageReferencesVisitor(IScriptFolder pkg, IJstType dependentType, List<VjoMatch> result) {
        this.pkg = pkg;
        this.result = result;
        this.dependentType = dependentType;
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    public void preVisit(IJstNode node) {
    }

    public boolean visit(IJstNode node) {
        JstType reference;
        if (node instanceof IJstType) {
            reference = (JstType)node;
            this.visit((IJstType)reference);
        }
        if (node instanceof IJstTypeReference) {
            reference = (IJstTypeReference)node;
            this.visit((IJstTypeReference)reference);
        }
        return true;
    }

    private void visit(IJstTypeReference reference) {
        String typeName;
        IJstType type = reference.getReferencedType();
        if (type.getPackage() == null) {
            return;
        }
        if (this.pkg.getElementName().equals(type.getPackage().getName()) && this.containInTypeTop(this.dependentType, typeName = type.getName())) {
            this.createMatch(reference);
        }
    }

    private void visit(IJstType type) {
        this.createMatch(type);
    }

    private boolean containInTypeTop(IJstType jstType, String typeName) {
        List al = jstType.getImports();
        for (IJstType jstType2 : al) {
            if (!jstType2.getName().equals(typeName)) continue;
            return true;
        }
        al = jstType.getExtends();
        for (IJstType jstType2 : al) {
            if (!jstType2.getName().equals(typeName)) continue;
            return true;
        }
        al = jstType.getExpects();
        for (IJstType jstType2 : al) {
            if (!jstType2.getName().equals(typeName)) continue;
            return true;
        }
        al = jstType.getSatisfies();
        for (IJstType jstType2 : al) {
            if (!jstType2.getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    private IType getType(IJstType jstType) {
        ScriptProject project = (ScriptProject)this.pkg.getScriptProject();
        IType type = CodeassistUtils.findType(project, jstType.getName());
        return type;
    }

    private void createMatch(IJstType type) {
        String pkg = type.getPackage().getName();
        if (pkg.equals(this.pkg.getElementName())) {
            int len = pkg.length();
            JstSource source = type.getPackage().getSource();
            if (source != null) {
                VjoMatch match = VjoMatchFactory.createPackageMatch(this.getType(this.dependentType), source.getStartOffSet(), len);
                this.result.add(match);
            }
        }
    }

    private void createMatch(IJstTypeReference reference) {
        String pkg = reference.getReferencedType().getPackage().getName();
        int len = pkg.length();
        JstSource source = reference.getSource();
        if (source != null) {
            VjoMatch match = null;
            match = source.getLength() == reference.getReferencedType().getName().length() ? VjoMatchFactory.createPackageMatch(this.getType(this.dependentType), source.getStartOffSet(), len) : VjoMatchFactory.createPackageMatch(this.getType(this.dependentType), source.getStartOffSet() - len - 1, len);
            if (match != null && !this.result.contains(match)) {
                this.result.add(match);
            }
        }
    }
}

