/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClassPathUtils {
    public static Set<String> getProjectDependencyUrls(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        URL[] urls = ClassPathUtils.getProjectDependencyUrlsInternal(javaProject);
        HashSet<String> urlsString = new HashSet<String>(urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            urlsString.add(u.getFile());
            ++n2;
        }
        return urlsString;
    }

    private static URL[] getProjectDependencyUrlsInternal(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        ArrayList<IJavaProject> jps = new ArrayList<IJavaProject>(1);
        jps.add(javaProject);
        return ClassPathUtils.getProjectDependencyUrls(jps, null, new HashMap<String, String>());
    }

    public static URL[] getProjectDependencyUrls(List<IJavaProject> javaProjectList, List<URL> currentUrlList, HashMap<String, String> projectMap) throws JavaModelException, MalformedURLException {
        List<URL> projectDependencyUrlList = currentUrlList;
        if (projectDependencyUrlList == null) {
            projectDependencyUrlList = new ArrayList<URL>();
        }
        for (IJavaProject project : javaProjectList) {
            IClasspathEntry[] entries;
            if (projectMap.containsKey(project.getElementName())) continue;
            projectMap.put(project.getElementName(), project.getElementName());
            IClasspathEntry[] iClasspathEntryArray = entries = project.getResolvedClasspath(true);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                File f = path.toFile();
                URL entryUrl = f.toURI().toURL();
                switch (entry.getEntryKind()) {
                    case 1: {
                        if (projectDependencyUrlList.contains(entryUrl)) break;
                        projectDependencyUrlList.add(entryUrl);
                        break;
                    }
                    case 2: {
                        IProject subProject;
                        IJavaProject subJavaProject;
                        ArrayList<IJavaProject> subjavaProjectList = new ArrayList<IJavaProject>();
                        IResource subResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
                        if (subResource == null || subResource.getType() != 4 || (subJavaProject = JavaCore.create((IProject)(subProject = (IProject)subResource))) == null || !subJavaProject.exists()) break;
                        subjavaProjectList.add(subJavaProject);
                        ClassPathUtils.getProjectDependencyUrls(subjavaProjectList, projectDependencyUrlList, projectMap);
                        break;
                    }
                }
                ++n2;
            }
            IPath path = project.getOutputLocation();
            IPath projectResourceLocation = project.getResource().getLocation();
            File projectFilePath = projectResourceLocation.append(path.removeFirstSegments(1)).toFile();
            URL projectOutputUrl = projectFilePath.toURI().toURL();
            if (projectDependencyUrlList.contains(projectOutputUrl)) continue;
            projectDependencyUrlList.add(projectOutputUrl);
        }
        URL[] arrayList = new URL[projectDependencyUrlList.size()];
        URL[] returnURLArray = projectDependencyUrlList.toArray(arrayList);
        return returnURLArray;
    }

    public static URL[] getProjectDependencyUrls(List<IScriptProject> scriptProjectList, List<URL> currentUrlList, Set<String> checkedProjects) throws MalformedURLException, ModelException {
        List<URL> projectDependencyUrlList = currentUrlList;
        for (IScriptProject project : scriptProjectList) {
            if (checkedProjects.contains(project.getElementName())) continue;
            checkedProjects.add(project.getElementName());
            IBuildpathEntry[] entries = null;
            IBuildpathEntry[] iBuildpathEntryArray = entries = project.getResolvedBuildpath(true);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildpathEntry entry = iBuildpathEntryArray[n2];
                IPath path = entry.getPath();
                if (EnvironmentPathUtils.isFull((IPath)path)) {
                    path = EnvironmentPathUtils.getLocalPath((IPath)path);
                }
                switch (entry.getEntryKind()) {
                    case 3: {
                        IResource member = project.getProject().getWorkspace().getRoot().findMember(path);
                        if (member == null) break;
                        URL entryUrl = member.getLocationURI().toURL();
                        ClassPathUtils.addDependencyUrl(entryUrl, projectDependencyUrlList);
                        break;
                    }
                    case 1: {
                        File f = path.toFile();
                        URL entryUrl = f.toURI().toURL();
                        ClassPathUtils.addDependencyUrl(entryUrl, projectDependencyUrlList);
                        break;
                    }
                    case 2: {
                        IProject subProject;
                        IScriptProject subScriptProject;
                        ArrayList<IScriptProject> subjavaProjectList = new ArrayList<IScriptProject>();
                        IResource subResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
                        if (subResource == null || subResource.getType() != 4 || (subScriptProject = DLTKCore.create((IProject)(subProject = (IProject)subResource))) == null || !subScriptProject.exists()) break;
                        subjavaProjectList.add(subScriptProject);
                        ClassPathUtils.getProjectDependencyUrls(subjavaProjectList, projectDependencyUrlList, checkedProjects);
                        break;
                    }
                }
                ++n2;
            }
        }
        URL[] arrayList = new URL[projectDependencyUrlList.size()];
        URL[] returnURLArray = projectDependencyUrlList.toArray(arrayList);
        return returnURLArray;
    }

    private static void addDependencyUrl(URL entryUrl, List<URL> projectDependencyUrlList) {
        if (!projectDependencyUrlList.contains(entryUrl)) {
            projectDependencyUrlList.add(entryUrl);
        }
    }

    public static Set<String> getProjectDependencyUrls(IScriptProject scriptProject) throws MalformedURLException, ModelException {
        URL[] urls = ClassPathUtils.getProjectDependencyUrlsInternal(scriptProject);
        HashSet<String> urlsString = new HashSet<String>(urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            urlsString.add(u.getFile());
            ++n2;
        }
        return urlsString;
    }

    private static URL[] getProjectDependencyUrlsInternal(IScriptProject scriptProject) throws MalformedURLException, ModelException {
        ArrayList<IScriptProject> scriptProjectList = new ArrayList<IScriptProject>(1);
        scriptProjectList.add(scriptProject);
        HashSet<String> checkedProjects = new HashSet<String>(1);
        ArrayList<URL> projectDependencyUrlList = new ArrayList<URL>();
        URL[] urls = ClassPathUtils.getProjectDependencyUrls(scriptProjectList, projectDependencyUrlList, checkedProjects);
        return urls;
    }
}

