/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.hierarchy;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IElementChangedListener;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ITypeHierarchyChangedListener;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.JSSourceTypeElementInfo;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.TypeVector;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.IVjoTypeHierarchy;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoTypeHierarchy
implements ITypeHierarchy,
IElementChangedListener,
IVjoTypeHierarchy {
    public static final String VJO_OBJECT = "Object";
    public static final String VJO_OBJECT_FULLNAME = "vjo.Object";
    private static final boolean DEBUG = false;
    protected static final IType[] NO_TYPE = new IType[0];
    protected ArrayList<IType> interfaces = new ArrayList(10);
    protected IType type;
    protected ISourceModule module;
    protected IProgressMonitor progressMonitor;
    private boolean computeSubtypes;
    private boolean needsRefresh = false;
    public TypeSpaceMgr typeSpaceMgr = TypeSpaceMgr.getInstance();
    public IJstType rootType;
    protected ArrayList listeners = new ArrayList();
    private boolean isNativeType = false;
    protected Map<IType, IType> classToSuperclass = new HashMap<IType, IType>();
    protected Map<IType, IType[]> typeToSuperInterfaces = new HashMap<IType, IType[]>();
    protected Map<IType, TypeVector> typeToSubtypes = new HashMap<IType, TypeVector>();
    protected TypeVector rootClasses = new TypeVector();

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            this.classToSuperclass.put(type, superclass);
            this.addSubtype(superclass, type);
        }
    }

    protected void cacheSuperInterfaces(IType type, IType[] superinterfaces) {
        this.typeToSuperInterfaces.put(type, superinterfaces);
        int i = 0;
        while (i < superinterfaces.length) {
            IType superinterface = superinterfaces[i];
            this.addInterface(superinterface);
            if (superinterface != null) {
                this.addSubtype(superinterface, type);
            }
            ++i;
        }
    }

    protected void addSubtype(IType type, IType subtype) {
        if (subtype == null) {
            return;
        }
        TypeVector subtypes = this.typeToSubtypes.get(type);
        if (subtypes == null) {
            subtypes = new TypeVector();
            this.typeToSubtypes.put(type, subtypes);
        }
        if (!subtypes.contains(subtype)) {
            subtypes.add(subtype);
        }
    }

    public VjoTypeHierarchy(IType type) {
        this.type = type;
        this.module = type.getSourceModule();
        this.isNativeType = CodeassistUtils.isNativeObject((IMember)type);
    }

    public boolean isNativeType() {
        return this.isNativeType;
    }

    protected void compute() throws ModelException, CoreException {
        this.computeSuperClasses(this.type);
        this.computeSubClasses(this.type);
    }

    private void addInterface(IType type) {
        this.interfaces.add(type);
    }

    private void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    private void computeInterfaces(IType fType) {
        TypeName name = this.getTypeName(fType);
        IJstType jsttype = this.findType(name);
        if (jsttype != null) {
            List interfaces = jsttype.getSatisfies();
            if (interfaces == null || interfaces.isEmpty()) {
                return;
            }
            List<IType> superInts = this.toITypes(fType, interfaces);
            this.cacheSuperInterfaces(fType, this.toTypeArray(superInts));
        }
    }

    private void computeSuperClasses(IType fType) {
        TypeName name = this.getTypeName(fType);
        this.computeInterfaces(fType);
        IJstType jstType = this.findType(name);
        if (jstType == null) {
            return;
        }
        IJstType superType = jstType.getExtend();
        if (superType == null) {
            this.rootType = jstType;
            this.addRootClass(CodeassistUtils.findType((ScriptProject)fType.getScriptProject(), this.rootType));
        } else {
            IType superItype = CodeassistUtils.findType((ScriptProject)fType.getScriptProject(), superType);
            if (superItype != null) {
                this.cacheSuperclass(fType, superItype);
                this.computeSuperClasses(superItype);
            } else {
                VjetPlugin.error("Type hierarchy could created could not find dltk type for: " + superType.getName());
            }
        }
    }

    private boolean hasNotObjectSuperType(List<IJstType> superTypes) {
        return superTypes.size() > 1 && (VJO_OBJECT.equals(this.rootType.getName()) || VJO_OBJECT_FULLNAME.equals(this.rootType.getName())) && CodeassistUtils.isNativeType(this.rootType);
    }

    private List<IType> RegistryAllSubtypesForType(IType type) {
        ArrayList<IType> subTypes = new ArrayList<IType>();
        this.computeAndAddSubClasses(type, subTypes);
        return subTypes;
    }

    private void computeAndAddSubClasses(IType fType, List<IType> subs) {
        TypeName name = this.getTypeName(fType);
        List subTypes = this.typeSpaceMgr.findSubTypes(name);
        IJstType currentType = this.typeSpaceMgr.findType(name);
        if (currentType == null) {
            return;
        }
        if (this.isInterface(fType) || currentType.isInterface()) {
            List list = this.typeSpaceMgr.findSatisfiers(name);
            for (IJstType jstType : list) {
                subTypes.add(jstType);
            }
        }
        for (IJstType subType : subTypes) {
            IType isubType;
            if (subType == null || (isubType = CodeassistUtils.findType((ScriptProject)fType.getScriptProject(), subType)) == null) continue;
            this.addSubtype(fType, isubType);
            subs.add(isubType);
            this.computeAndAddSubClasses(isubType, subs);
        }
    }

    private void computeSubClasses(IType fType) {
        this.RegistryAllSubtypesForType(fType);
    }

    private List<IType> toITypes(IType itype, List<IJstType> list) {
        ArrayList<IType> result = new ArrayList<IType>();
        for (IJstType jstType : list) {
            IType type = CodeassistUtils.findType((ScriptProject)itype.getScriptProject(), jstType);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    public synchronized void refresh(IProgressMonitor monitor) throws ModelException {
        try {
            try {
                this.progressMonitor = monitor;
                if (monitor != null) {
                    if (this.type != null) {
                        monitor.beginTask(Messages.bind((String)Messages.hierarchy_creatingOnType, (Object)this.type.getFullyQualifiedName()), 100);
                    } else {
                        monitor.beginTask(Messages.hierarchy_creating, 100);
                    }
                }
                long start = -1L;
                this.compute();
                this.needsRefresh = false;
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
        }
    }

    public boolean hasFineGrainChanges() {
        return false;
    }

    private void addAllCheckingDuplicates(ArrayList list, IType[] collection) {
        int i = 0;
        while (i < collection.length) {
            IType element = collection[i];
            if (!list.contains(element)) {
                list.add(element);
            }
            ++i;
        }
    }

    public void initialize(int size) {
    }

    public void store(OutputStream output, IProgressMonitor monitor) throws ModelException {
    }

    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        if (this.rootClasses.contains(type)) {
            return true;
        }
        return this.interfaces.contains(type);
    }

    public void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        if (this.listeners.size() == 0) {
            DLTKCore.addElementChangedListener((IElementChangedListener)this);
        }
        if (this.listeners.indexOf(listener) == -1) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.type == null || this.type.exists()) && this.javaProject().exists();
    }

    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator<IType> iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add(iter.next());
        }
        return classes.elements();
    }

    public IType[] getAllTypes() {
        IType[] classes = this.getAllClasses();
        int classesLength = classes.length;
        IType[] allInterfaces = this.getAllInterfaces();
        int interfacesLength = allInterfaces.length;
        IType[] all = new IType[classesLength + interfacesLength];
        System.arraycopy(classes, 0, all, 0, classesLength);
        System.arraycopy(allInterfaces, 0, all, classesLength, interfacesLength);
        return all;
    }

    public IType[] getAllInterfaces() {
        IType[] collection = new IType[this.interfaces.size()];
        this.interfaces.toArray(collection);
        return collection;
    }

    private IType[] toTypeArray(List<IType> a) {
        return a.toArray(new IType[a.size()]);
    }

    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypesForType(type);
    }

    private IType[] getAllSubtypesForType(IType type) {
        ArrayList subTypes = new ArrayList();
        this.getAllSubtypesForType0(type, subTypes);
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private void getAllSubtypesForType0(IType type, ArrayList subs) {
        IType[] subTypes = this.getSubtypesForType(type);
        if (subTypes.length != 0) {
            int i = 0;
            while (i < subTypes.length) {
                IType subType = subTypes[i];
                subs.add(subType);
                this.getAllSubtypesForType0(subType, subs);
                ++i;
            }
        }
    }

    public IType[] getAllSuperclasses(IType type) {
        IType[] superclasses = this.getSuperclass(type);
        IType superclass = superclasses.length == 1 ? superclasses[0] : null;
        TypeVector supers = new TypeVector();
        while (superclass != null) {
            supers.add(superclass);
            superclasses = this.getSuperclass(superclass);
            IType iType = superclass = superclasses.length == 1 ? superclasses[0] : null;
        }
        return supers.elements();
    }

    private IType[] getSubtypesForType(IType type) {
        TypeVector vector = this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType[] getAllSuperInterfaces(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperInterfaces.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSuperInterfaces0(type, supers);
        IType[] superinterfaces = new IType[supers.size()];
        supers.toArray(superinterfaces);
        return superinterfaces;
    }

    private void getAllSuperInterfaces0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = this.typeToSuperInterfaces.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperInterfaces0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = this.classToSuperclass.get(type)) != null) {
            this.getAllSuperInterfaces0(superclass, supers);
        }
    }

    public IType[] getAllSupertypes(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperInterfaces.get(type) == null && this.classToSuperclass.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSupertypes0(type, supers);
        IType[] supertypes = new IType[supers.size()];
        supers.toArray(supertypes);
        return supertypes;
    }

    private void getAllSupertypes0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = this.typeToSuperInterfaces.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperInterfaces0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = this.classToSuperclass.get(type)) != null) {
            supers.add(superclass);
            this.getAllSupertypes0(superclass, supers);
        }
    }

    public int getCachedFlags(IType type) {
        JSSourceType sourceType = (JSSourceType)type;
        int flags = 0;
        try {
            JSSourceTypeElementInfo info = (JSSourceTypeElementInfo)sourceType.getElementInfo();
            if (info != null && ((flags = info.getModifiers()) & 0x200) != 0) {
                flags = 16;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return flags;
    }

    public IType[] getRootClasses() {
        IType atype;
        IType[] rootClasses = new IType[]{this.getType()};
        if (this.rootType != null && this.type != null && (atype = CodeassistUtils.findType((ScriptProject)this.type.getScriptProject(), this.rootType)) != null) {
            rootClasses = new IType[]{atype};
        }
        return rootClasses;
    }

    private boolean isInterface(IType type) {
        try {
            return Flags.isInterface((int)type.getFlags());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    private TypeName getTypeName(IType type) {
        IVjoSourceModule vjoSourceModule = (IVjoSourceModule)type.getSourceModule();
        if (vjoSourceModule != null) {
            TypeName typeName = vjoSourceModule.getTypeName();
            SourceTypeName typeName2 = new SourceTypeName(typeName.groupName(), type.getFullyQualifiedName("."));
            return typeName2;
        }
        return null;
    }

    private IJstType findType(TypeName typeName) {
        if (this.isNativeType()) {
            return CodeassistUtils.findNativeJstType(typeName.typeName());
        }
        return this.typeSpaceMgr.findType(typeName);
    }

    public IType getType() {
        return this.type;
    }

    public void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1) {
            this.fireChanged();
        }
    }

    public void fireChanged() {
        this.listeners = (ArrayList)this.listeners.clone();
        int i = 0;
        while (i < this.listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)this.listeners.get(i);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Util.log((Throwable)exception, (String)"Exception occurred in listener of Type hierarchy change notification");
                }

                public void run() throws Exception {
                    listener.typeHierarchyChanged((ITypeHierarchy)VjoTypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    public IScriptProject javaProject() {
        return this.type.getScriptProject();
    }

    public IType[] getSubclasses(IType type) {
        if (this.isInterface(type)) {
            return NO_TYPE;
        }
        TypeVector vector = this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType[] getSubtypes(IType type) {
        return this.getSubtypesForType(type);
    }

    public IType[] getSuperclass(IType type) {
        if (type == null || this.isInterface(type)) {
            return null;
        }
        return new IType[]{this.classToSuperclass.get(type)};
    }

    public IType[] getSuperInterfaces(IType type) {
        IType[] types = this.typeToSuperInterfaces.get(type);
        if (types == null) {
            return NO_TYPE;
        }
        return types;
    }

    public IType[] getSupertypes(IType type) {
        IType superclass;
        IType iType = superclass = this.getSuperclass(type).length > 0 ? this.getSuperclass(type)[0] : null;
        if (superclass == null) {
            return this.getSuperInterfaces(type);
        }
        TypeVector superTypes = new TypeVector(this.getSuperInterfaces(type));
        superTypes.add(superclass);
        return superTypes.elements();
    }
}

