/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.loader;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.util.JstRefTypeDependencyCollector;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public class OnDemandJstTypeLoader
implements IJstTypeLoader {
    private static final String ONDEMAND = "ONDEMAND";
    private static final String JS = ".js";
    private static final String VJO = ".vjo";
    private IJstType m_type;
    private String m_group = "ONDEMAND";
    private List<IJstTypeLoader.SourceType> m_sources;
    private Map<String, String> m_lookedup = new HashMap<String, String>();

    public OnDemandJstTypeLoader(IJstType type) {
        this.m_type = type;
    }

    public OnDemandJstTypeLoader(String group, IJstType type) {
        this.m_type = type;
        this.m_group = group;
    }

    public List<IJstTypeLoader.SourceType> loadJstTypes(List<AddGroupEvent> groupList) {
        this.m_sources = new ArrayList<IJstTypeLoader.SourceType>(5);
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        this.addSource(locator, this.m_type);
        this.findSources(this.m_type);
        ArrayList<IJstTypeLoader.SourceType> rev = new ArrayList<IJstTypeLoader.SourceType>();
        int i = this.m_sources.size() - 1;
        while (i >= 0) {
            rev.add(this.m_sources.get(i));
            --i;
        }
        return rev;
    }

    protected void findSources(String typeName) {
        if (this.alreadyLookedup(typeName)) {
            return;
        }
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        URL url = locator.getSourceUrl(typeName, JS);
        if (url != null) {
            TranslateConfig cfg = new TranslateConfig();
            cfg.setSkiptImplementation(true);
            VjoParser p = new VjoParser(cfg);
            System.out.println("url: " + url);
            IJstType type = p.parse(this.m_group, url);
            if (type != null) {
                this.findSources(type);
            }
        }
    }

    protected boolean alreadyLookedup(String typeName) {
        if (this.m_lookedup.get(typeName) != null) {
            return true;
        }
        this.m_lookedup.put(typeName, "");
        return false;
    }

    protected void findSources(IJstType type) {
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        for (IJstTypeReference ineed : JstRefTypeDependencyCollector.getDependency((IJstType)type).values()) {
            this.addSource(locator, ineed.getReferencedType());
            this.findSources(ineed.getReferencedType().getName());
        }
        for (IJstTypeReference ineed : type.getImports()) {
            if (ineed.getAlias() == null) continue;
            this.addSource(locator, (IJstType)ineed);
            this.findSources(ineed.getName());
        }
    }

    protected void addSource(JavaSourceLocator locator, IJstType ineed) {
        URL url;
        if (ineed.getSource() != null && ineed.getSource().getBinding() != null && ineed.getSource().getBinding() instanceof FileBinding) {
            this.m_sources.add(new IJstTypeLoader.SourceType(this.m_group, ineed.getName(), null, ((FileBinding)ineed.getSource().getBinding()).getFile()));
        }
        if ((url = locator.getSourceUrl(ineed.getName(), JS)) == null) {
            url = locator.getSourceUrl(ineed.getName(), VJO);
        }
        if (url != null) {
            String src = locator.getSource(url);
            this.m_sources.add(new IJstTypeLoader.SourceType(this.m_group, ineed.getName(), src, new File(url.getFile())));
        }
    }
}

