/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstParser;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefResolver;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ResolutionResult;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.lib.IJstLibProvider;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionBindingResolver;
import org.eclipse.vjet.dsf.jstojava.controller.NativeJsLibProvider;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.util.JstTypeCopier;

public class JstParseController
implements IJstParseController {
    private IJstParser m_parser;
    private IJstRefResolver m_resolver;
    private JstTypeSpaceMgr m_tsMgr;
    private IJstLibProvider m_libProvider = new NativeJsLibProvider();
    private ParseResultHolder m_currentHolder = null;

    public JstParseController(IJstParser parser) {
        if (parser == null) {
            throw new RuntimeException("parser can't be null");
        }
        this.m_parser = parser;
        this.m_resolver = new JstExpressionBindingResolver(this);
        this.initialize();
    }

    private void initialize() {
        this.m_libProvider.getAll();
    }

    public synchronized IJstType parse(String groupName, String fileName, String source) {
        return this.m_parser.parse(groupName, fileName, source);
    }

    public synchronized IJstType parse(String groupName, File sourceFile) {
        return this.m_parser.parse(groupName, sourceFile);
    }

    public synchronized IJstType parseAndResolve(String groupName, String fileName, String source) {
        IJstType unit;
        if (source == null) {
            throw new DsfRuntimeException("missing source for " + fileName);
        }
        ParseResultHolder holder = this.getCacheHolder(groupName, fileName, source);
        if (holder.isLoaded()) {
            unit = holder.getResult();
        } else {
            ArrayList problems = new ArrayList();
            unit = this.m_parser.parse(groupName, fileName, source);
            if (unit != null) {
                problems.addAll(unit.getProblems());
                ((JstType)unit).clearProblems();
                this.resolve(groupName, unit);
                if (unit.getProblems() != null) {
                    problems.addAll(unit.getProblems());
                }
                unit.setProblems(problems);
                holder.setResult(unit);
            }
        }
        return unit;
    }

    public synchronized IJstType parseAndResolve(String groupName, File sourceFile) {
        if (sourceFile == null) {
            throw new DsfRuntimeException("missing source file!");
        }
        String fileName = sourceFile.getAbsolutePath();
        String source = VjoParser.getContent(sourceFile);
        return this.parseAndResolve(groupName, fileName, source);
    }

    public IJstType resolve(IJstType type) {
        return this.m_resolver.resolve(type).getType();
    }

    public IJstType resolve(String groupName, IJstType su) {
        List blocks = su.getJstBlockList();
        ResolutionResult resolve = this.m_resolver.resolve(groupName, su);
        this.addResolutionResultToSU(su, resolve);
        if (blocks == null) {
            return null;
        }
        if (su.getJstBlockList() == null) {
            su.setJstBlockList(blocks);
        }
        for (JstBlock block : blocks) {
            ResolutionResult resolutionResult = this.m_resolver.resolve(null, (IJstNode)block);
            this.addResolutionResultToSU(su, resolutionResult);
        }
        return resolve.getType();
    }

    private void addResolutionResultToSU(IJstType su, ResolutionResult resolve) {
        if (resolve.getType() != null) {
            if (su instanceof JstType && resolve.getType() instanceof JstType) {
                JstType type = (JstType)su;
                if (type != resolve.getType()) {
                    JstTypeCopier.replace((JstType)type, (JstType)((JstType)resolve.getType()));
                    this.resolve((IJstType)type);
                }
            } else {
                su = resolve.getType();
            }
        }
    }

    public IJstType resolve(IJstProperty property) {
        return this.m_resolver.resolve(property).getType();
    }

    public IJstType resolve(String groupName, IJstProperty property) {
        ResolutionResult rr = this.m_resolver.resolve(groupName, property);
        return rr.getType();
    }

    public IJstType resolve(IJstMethod method) {
        return this.m_resolver.resolve(method).getType();
    }

    public IJstType resolve(String groupName, IJstMethod method) {
        ResolutionResult rr = this.m_resolver.resolve(groupName, method);
        return rr.getType();
    }

    public void setRefResolver(IJstRefResolver resolver) {
        this.m_resolver = resolver;
    }

    public JstTypeSpaceMgr getJstTypeSpaceMgr() {
        return this.m_tsMgr;
    }

    public void setJstTSMgr(JstTypeSpaceMgr jstTSMgr) {
        this.m_tsMgr = jstTSMgr;
    }

    public IJstType resolve(IJstType type, IJstNode node) {
        ResolutionResult rr = this.m_resolver.resolve(type, node);
        return rr.getType();
    }

    private ParseResultHolder getCacheHolder(String group, String fileName, String source) {
        if (this.m_currentHolder == null || !this.m_currentHolder.isMatch(group, fileName, source)) {
            this.m_currentHolder = new ParseResultHolder(group, fileName, source);
        }
        return this.m_currentHolder;
    }

    private static class ParseResultHolder {
        private final String m_group;
        private final String m_fileName;
        private final String m_source;
        private IJstType m_result = null;
        private boolean m_loaded = false;

        ParseResultHolder(String group, String fileName, String source) {
            this.m_group = group;
            this.m_fileName = fileName;
            this.m_source = source;
        }

        boolean isMatch(String group, String fileName, String source) {
            return this.m_group.equals(group) && this.m_fileName != null && this.m_fileName.equals(fileName) && this.m_source.equals(source);
        }

        boolean isLoaded() {
            return this.m_loaded;
        }

        IJstType getResult() {
            return this.m_result;
        }

        void setResult(IJstType result) {
            this.m_result = result;
            this.m_loaded = true;
        }
    }
}

