/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.core;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.IValidatorType;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorManager;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorMessages;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorsCore;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorDefinitionsContainer {
    private static final String NODE_VALIDATOR_SETTINGS = "validatorSettings";
    private static final String NODE_VALIDATOR_TYPE = "validatorType";
    private static final String NODE_VALIDATOR = "validator";
    private static final String ATTR_ID = "id";
    private final Map fValidatorsByType = new HashMap(10);
    private final List fValidatorList = new ArrayList(10);

    public void addValidator(IValidator validator) {
        if (!this.fValidatorList.contains(validator)) {
            this.fValidatorList.add(validator);
            IValidatorType type = validator.getValidatorType();
            ArrayList<IValidator> typeValidators = (ArrayList<IValidator>)this.fValidatorsByType.get(type);
            if (typeValidators == null) {
                typeValidators = new ArrayList<IValidator>(3);
                this.fValidatorsByType.put(type, typeValidators);
            }
            typeValidators.add(validator);
        }
    }

    public void addValidators(List validatorList) {
        for (IValidator validator : validatorList) {
            this.addValidator(validator);
        }
    }

    public void addValidators(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            this.addValidator(validators[i]);
            ++i;
        }
    }

    public List getValidatorList() {
        return Collections.unmodifiableList(this.fValidatorList);
    }

    public List getValidatorList(String nature) {
        ArrayList result = new ArrayList(this.fValidatorList.size());
        for (Map.Entry entry : this.fValidatorsByType.entrySet()) {
            IValidatorType type = (IValidatorType)entry.getKey();
            String typeNature = type.getNature();
            if (!nature.equals(typeNature) && !"#".equals(typeNature)) continue;
            result.addAll((List)entry.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = ValidatorsCore.getDocument();
        Element config = doc.createElement(NODE_VALIDATOR_SETTINGS);
        doc.appendChild(config);
        for (Map.Entry entry : this.fValidatorsByType.entrySet()) {
            IValidatorType validatorType = (IValidatorType)entry.getKey();
            if (!validatorType.isConfigurable()) continue;
            Element valiatorTypeElement = this.validatorTypeAsElement(doc, validatorType, (List)entry.getValue());
            config.appendChild(valiatorTypeElement);
        }
        return ValidatorsCore.serializeDocument(doc);
    }

    private Element validatorTypeAsElement(Document doc, IValidatorType validatorType, List validatorList) {
        Element element = doc.createElement(NODE_VALIDATOR_TYPE);
        element.setAttribute(ATTR_ID, validatorType.getID());
        for (IValidator validator : validatorList) {
            Element validatorElement = this.validatorAsElement(doc, validator);
            element.appendChild(validatorElement);
        }
        return element;
    }

    private Element validatorAsElement(Document doc, IValidator validator) {
        Element element = doc.createElement(NODE_VALIDATOR);
        element.setAttribute(ATTR_ID, validator.getID());
        validator.storeTo(doc, element);
        return element;
    }

    public static ValidatorDefinitionsContainer createFromXML(Reader input) throws IOException {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        container.parseXML(new InputSource(input));
        return container;
    }

    public void parseXML(InputSource input) throws IOException {
        Element config = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(input).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        if (!config.getNodeName().equalsIgnoreCase(NODE_VALIDATOR_SETTINGS)) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element validatorTypeElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (validatorTypeElement = (Element)node).getNodeName().equalsIgnoreCase(NODE_VALIDATOR_TYPE)) {
                this.populateValidatorType(validatorTypeElement);
            }
            ++i;
        }
    }

    private void populateValidatorType(Element validatorTypeElement) {
        String id = validatorTypeElement.getAttribute(ATTR_ID);
        IValidatorType validatorType = ValidatorManager.getValidatorTypeFromID(id);
        if (validatorType != null) {
            NodeList validatorNodeList = validatorTypeElement.getChildNodes();
            int i = 0;
            while (i < validatorNodeList.getLength()) {
                Element validatorElement;
                Node childNode = validatorNodeList.item(i);
                short type = childNode.getNodeType();
                if (type == 1 && (validatorElement = (Element)childNode).getNodeName().equalsIgnoreCase(NODE_VALIDATOR)) {
                    this.populateValidator(validatorType, validatorElement);
                }
                ++i;
            }
        } else {
            String msg = ValidatorMessages.ValidatorDefinitionsContainer_unknownValidatorType;
            ValidatorsCore.warn(NLS.bind((String)msg, (Object)id));
        }
    }

    private void populateValidator(IValidatorType type, Element element) {
        String id = element.getAttribute(ATTR_ID);
        if (id != null) {
            try {
                IValidator validator = type.isBuiltin() ? type.findValidator(id) : type.createValidator(id);
                if (validator != null) {
                    if (type.isConfigurable()) {
                        validator.loadFrom(element);
                    }
                    this.addValidator(validator);
                }
            }
            catch (DOMException e) {
                String msg = ValidatorMessages.ValidatorDefinitionsContainer_failedToLoadValidatorFromXml;
                ValidatorsCore.error(msg, e);
            }
        } else if (DLTKCore.DEBUG) {
            System.err.println("id attribute missing from validator element specification.");
        }
    }

    public void removeValidator(IValidator validator) {
        this.fValidatorList.remove(validator);
        List list = (List)this.fValidatorsByType.get(validator.getValidatorType());
        if (list != null) {
            list.remove(validator);
        }
    }
}

