/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.LibraryStandin;
import org.eclipse.dltk.mod.launching.EnvironmentVariable;
import org.eclipse.dltk.mod.launching.LibraryLocation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LibraryContentProvider
implements ITreeContentProvider {
    protected TreeViewer fViewer;
    protected LibraryStandin[] fLibraries = new LibraryStandin[0];
    protected LibraryStandin[] fAllLibraries = new LibraryStandin[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fLibraries;
    }

    public void setLibraries(LibraryLocation[] libs) {
        if (libs != null) {
            this.fLibraries = new LibraryStandin[libs.length];
            int i = 0;
            while (i < libs.length) {
                this.fLibraries[i] = new LibraryStandin(libs[i]);
                ++i;
            }
        } else {
            this.fLibraries = new LibraryStandin[0];
        }
        this.fViewer.refresh();
    }

    public void initialize(IFileHandle file, EnvironmentVariable[] environmentVariables, boolean restoreDefault) {
    }

    public LibraryLocation[] getLibraries() {
        LibraryLocation[] locations = new LibraryLocation[this.fLibraries.length];
        int i = 0;
        while (i < locations.length) {
            locations[i] = this.fLibraries[i].toLibraryLocation();
            ++i;
        }
        return locations;
    }

    private Set getSelectedLibraries(IStructuredSelection selection) {
        HashSet libraries = new HashSet();
        for (Object element : selection) {
            if (!(element instanceof LibraryStandin)) continue;
            libraries.add(element);
        }
        return libraries;
    }

    public void up(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = 0;
        while (i < this.fLibraries.length - 1) {
            if (libraries.contains(this.fLibraries[i + 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i + 1];
                this.fLibraries[i + 1] = temp;
            }
            ++i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void down(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = this.fLibraries.length - 1;
        while (i > 0) {
            if (libraries.contains(this.fLibraries[i - 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i - 1];
                this.fLibraries[i - 1] = temp;
            }
            --i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void remove(IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>();
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        for (Object element : selection) {
            if (!(element instanceof LibraryStandin)) continue;
            newLibraries.remove(element);
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
    }

    public void add(LibraryLocation[] libs, IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>(this.fLibraries.length + libs.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        ArrayList<LibraryStandin> toAdd = new ArrayList<LibraryStandin>(libs.length);
        int i2 = 0;
        while (i2 < libs.length) {
            toAdd.add(new LibraryStandin(libs[i2]));
            ++i2;
        }
        if (selection.isEmpty()) {
            newLibraries.addAll(toAdd);
        } else {
            Object element = selection.getFirstElement();
            if (element instanceof LibraryStandin) {
                LibraryStandin firstLib = (LibraryStandin)element;
                int index = newLibraries.indexOf(firstLib);
                newLibraries.addAll(index, toAdd);
            } else {
                newLibraries.addAll(toAdd);
            }
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
    }

    public LibraryStandin[] getStandins() {
        return this.fLibraries;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public boolean isEnabled(Object lib) {
        return true;
    }

    public boolean canRemove(IStructuredSelection selection) {
        return !selection.isEmpty();
    }

    public void changeEnabled() {
    }

    public boolean canEnable(IStructuredSelection selection) {
        return false;
    }

    public boolean canUp(IStructuredSelection selection) {
        return true;
    }

    public boolean canDown(IStructuredSelection selection) {
        return true;
    }
}

