/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetworkOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptionsConverter;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@DataObject(generateConverter=true)
public abstract class TCPSSLOptions
extends NetworkOptions {
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = -1;
    public static final boolean DEFAULT_USE_POOLED_BUFFERS = false;
    public static final boolean DEFAULT_SSL = false;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    private boolean tcpNoDelay;
    private boolean tcpKeepAlive;
    private int soLinger;
    private boolean usePooledBuffers;
    private int idleTimeout;
    private boolean ssl;
    private KeyCertOptions keyCertOptions;
    private TrustOptions trustOptions;
    private Set<String> enabledCipherSuites = new HashSet<String>();
    private ArrayList<String> crlPaths;
    private ArrayList<Buffer> crlValues;

    public TCPSSLOptions() {
        this.init();
    }

    public TCPSSLOptions(TCPSSLOptions other) {
        super(other);
        this.tcpNoDelay = other.isTcpNoDelay();
        this.tcpKeepAlive = other.isTcpKeepAlive();
        this.soLinger = other.getSoLinger();
        this.usePooledBuffers = other.isUsePooledBuffers();
        this.idleTimeout = other.getIdleTimeout();
        this.ssl = other.isSsl();
        this.keyCertOptions = other.getKeyCertOptions() != null ? other.getKeyCertOptions().clone() : null;
        this.trustOptions = other.getTrustOptions() != null ? other.getTrustOptions().clone() : null;
        this.enabledCipherSuites = other.getEnabledCipherSuites() == null ? new HashSet<String>() : new HashSet<String>(other.getEnabledCipherSuites());
        this.crlPaths = new ArrayList<String>(other.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(other.getCrlValues());
    }

    public TCPSSLOptions(JsonObject json) {
        super(json);
        this.init();
        TCPSSLOptionsConverter.fromJson(json, this);
    }

    private void init() {
        this.tcpNoDelay = true;
        this.tcpKeepAlive = false;
        this.soLinger = -1;
        this.usePooledBuffers = false;
        this.idleTimeout = 0;
        this.ssl = false;
        this.crlPaths = new ArrayList();
        this.crlValues = new ArrayList();
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public TCPSSLOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public TCPSSLOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public TCPSSLOptions setSoLinger(int soLinger) {
        if (soLinger < 0) {
            throw new IllegalArgumentException("soLinger must be >= 0");
        }
        this.soLinger = soLinger;
        return this;
    }

    public boolean isUsePooledBuffers() {
        return this.usePooledBuffers;
    }

    public TCPSSLOptions setUsePooledBuffers(boolean usePooledBuffers) {
        this.usePooledBuffers = usePooledBuffers;
        return this;
    }

    public TCPSSLOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public TCPSSLOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public KeyCertOptions getKeyCertOptions() {
        return this.keyCertOptions;
    }

    public TCPSSLOptions setKeyStoreOptions(JksOptions options) {
        this.keyCertOptions = options;
        return this;
    }

    public TCPSSLOptions setPfxKeyCertOptions(PfxOptions options) {
        this.keyCertOptions = options;
        return this;
    }

    public TCPSSLOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        this.keyCertOptions = options;
        return this;
    }

    public TrustOptions getTrustOptions() {
        return this.trustOptions;
    }

    public TCPSSLOptions setTrustStoreOptions(JksOptions options) {
        this.trustOptions = options;
        return this;
    }

    public TCPSSLOptions setPfxTrustOptions(PfxOptions options) {
        this.trustOptions = options;
        return this;
    }

    public TCPSSLOptions setPemTrustOptions(PemTrustOptions options) {
        this.trustOptions = options;
        return this;
    }

    public TCPSSLOptions addEnabledCipherSuite(String suite) {
        this.enabledCipherSuites.add(suite);
        return this;
    }

    public Set<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public List<String> getCrlPaths() {
        return this.crlPaths;
    }

    public TCPSSLOptions addCrlPath(String crlPath) throws NullPointerException {
        Objects.requireNonNull(crlPath, "No null crl accepted");
        this.crlPaths.add(crlPath);
        return this;
    }

    public List<Buffer> getCrlValues() {
        return this.crlValues;
    }

    public TCPSSLOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        Objects.requireNonNull(crlValue, "No null crl accepted");
        this.crlValues.add(crlValue);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TCPSSLOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPSSLOptions that = (TCPSSLOptions)o;
        if (this.idleTimeout != that.idleTimeout) {
            return false;
        }
        if (this.soLinger != that.soLinger) {
            return false;
        }
        if (this.ssl != that.ssl) {
            return false;
        }
        if (this.tcpKeepAlive != that.tcpKeepAlive) {
            return false;
        }
        if (this.tcpNoDelay != that.tcpNoDelay) {
            return false;
        }
        if (this.usePooledBuffers != that.usePooledBuffers) {
            return false;
        }
        if (this.crlPaths != null ? !this.crlPaths.equals(that.crlPaths) : that.crlPaths != null) {
            return false;
        }
        if (this.crlValues != null ? !this.crlValues.equals(that.crlValues) : that.crlValues != null) {
            return false;
        }
        if (this.enabledCipherSuites != null ? !this.enabledCipherSuites.equals(that.enabledCipherSuites) : that.enabledCipherSuites != null) {
            return false;
        }
        if (this.keyCertOptions != null ? !this.keyCertOptions.equals(that.keyCertOptions) : that.keyCertOptions != null) {
            return false;
        }
        return !(this.trustOptions != null ? !this.trustOptions.equals(that.trustOptions) : that.trustOptions != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tcpNoDelay ? 1 : 0);
        result = 31 * result + (this.tcpKeepAlive ? 1 : 0);
        result = 31 * result + this.soLinger;
        result = 31 * result + (this.usePooledBuffers ? 1 : 0);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + (this.ssl ? 1 : 0);
        result = 31 * result + (this.keyCertOptions != null ? this.keyCertOptions.hashCode() : 0);
        result = 31 * result + (this.trustOptions != null ? this.trustOptions.hashCode() : 0);
        result = 31 * result + (this.enabledCipherSuites != null ? this.enabledCipherSuites.hashCode() : 0);
        result = 31 * result + (this.crlPaths != null ? this.crlPaths.hashCode() : 0);
        result = 31 * result + (this.crlValues != null ? this.crlValues.hashCode() : 0);
        return result;
    }
}

