/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptionsConverter;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@DataObject(generateConverter=true)
public class PemTrustOptions
implements TrustOptions,
Cloneable {
    private ArrayList<String> certPaths;
    private ArrayList<Buffer> certValues;

    public PemTrustOptions() {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
    }

    public PemTrustOptions(PemTrustOptions other) {
        this.certPaths = new ArrayList<String>(other.getCertPaths());
        this.certValues = new ArrayList<Buffer>(other.getCertValues());
    }

    public PemTrustOptions(JsonObject json) {
        this();
        PemTrustOptionsConverter.fromJson(json, this);
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public PemTrustOptions addCertPath(String certPath) throws NullPointerException {
        Objects.requireNonNull(certPath, "No null certificate accepted");
        Arguments.require(!certPath.isEmpty(), "No empty certificate path accepted");
        this.certPaths.add(certPath);
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public PemTrustOptions addCertValue(Buffer certValue) throws NullPointerException {
        Objects.requireNonNull(certValue, "No null certificate accepted");
        this.certValues.add(certValue);
        return this;
    }

    @Override
    public PemTrustOptions clone() {
        return new PemTrustOptions(this);
    }
}

