/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;

@VertxGen
public interface HttpServerResponse
extends WriteStream<Buffer> {
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> var1);

    public HttpServerResponse write(Buffer var1);

    public HttpServerResponse setWriteQueueMaxSize(int var1);

    public HttpServerResponse drainHandler(Handler<Void> var1);

    public int getStatusCode();

    @Fluent
    public HttpServerResponse setStatusCode(int var1);

    public String getStatusMessage();

    @Fluent
    public HttpServerResponse setStatusMessage(String var1);

    @Fluent
    public HttpServerResponse setChunked(boolean var1);

    public boolean isChunked();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpServerResponse putHeader(String var1, String var2);

    @GenIgnore
    public HttpServerResponse putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore
    public HttpServerResponse putHeader(String var1, Iterable<String> var2);

    @GenIgnore
    public HttpServerResponse putHeader(CharSequence var1, Iterable<CharSequence> var2);

    @CacheReturn
    public MultiMap trailers();

    @Fluent
    public HttpServerResponse putTrailer(String var1, String var2);

    @GenIgnore
    public HttpServerResponse putTrailer(CharSequence var1, CharSequence var2);

    @GenIgnore
    public HttpServerResponse putTrailer(String var1, Iterable<String> var2);

    @GenIgnore
    public HttpServerResponse putTrailer(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public HttpServerResponse closeHandler(Handler<Void> var1);

    @Fluent
    public HttpServerResponse write(String var1, String var2);

    @Fluent
    public HttpServerResponse write(String var1);

    @Fluent
    public HttpServerResponse writeContinue();

    public void end(String var1);

    public void end(String var1, String var2);

    public void end(Buffer var1);

    public void end();

    @Fluent
    default public HttpServerResponse sendFile(String filename) {
        return this.sendFile(filename, 0L);
    }

    @Fluent
    default public HttpServerResponse sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    @Fluent
    public HttpServerResponse sendFile(String var1, long var2, long var4);

    @Fluent
    default public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, 0L, resultHandler);
    }

    @Fluent
    default public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, offset, Long.MAX_VALUE, resultHandler);
    }

    @Fluent
    public HttpServerResponse sendFile(String var1, long var2, long var4, Handler<AsyncResult<Void>> var6);

    public void close();

    public boolean ended();

    public boolean closed();

    public boolean headWritten();

    @Fluent
    public HttpServerResponse headersEndHandler(Handler<Void> var1);

    @Fluent
    public HttpServerResponse bodyEndHandler(Handler<Void> var1);
}

