/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;

@DataObject
public class DeliveryOptions {
    public static final long DEFAULT_TIMEOUT = 30000L;
    private long timeout = 30000L;
    private String codecName;
    private MultiMap headers;

    public DeliveryOptions() {
    }

    public DeliveryOptions(DeliveryOptions other) {
        this.timeout = other.getSendTimeout();
        this.codecName = other.getCodecName();
        this.headers = other.getHeaders();
    }

    public DeliveryOptions(JsonObject json) {
        this.timeout = json.getLong("timeout", 30000L);
        this.codecName = json.getString("codecName", null);
        JsonObject hdrs = json.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = new CaseInsensitiveHeaders();
            for (Map.Entry<String, Object> entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + entry.getValue().getClass());
                }
                this.headers.set(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public long getSendTimeout() {
        return this.timeout;
    }

    public DeliveryOptions setSendTimeout(long timeout) {
        Arguments.require(timeout >= 1L, "sendTimeout must be >= 1");
        this.timeout = timeout;
        return this;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public DeliveryOptions setCodecName(String codecName) {
        this.codecName = codecName;
        return this;
    }

    public DeliveryOptions addHeader(String key, String value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    public DeliveryOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
    }
}

