/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.rename;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.m2e.refactoring.internal.SaveDirtyFilesDialog;
import org.eclipse.m2e.refactoring.rename.MavenRenameWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameArtifactHandler
extends AbstractHandler {
    private static final ILog log = Platform.getLog(RenameArtifactHandler.class);

    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) {
        ISelection selection = this.computeSelection(event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        Object object = element;
        if (object instanceof IFile) {
            void file;
            IFile iFile = (IFile)object;
            IFile cfr_ignored_0 = (IFile)object;
            this.rename((IFile)file);
        } else {
            Object object2 = element;
            if (object2 instanceof IAdaptable) {
                void adaptable;
                IAdaptable iAdaptable = (IAdaptable)object2;
                IAdaptable cfr_ignored_1 = (IAdaptable)object2;
                IProject project = (IProject)adaptable.getAdapter(IProject.class);
                if (project == null) {
                    return null;
                }
                IFile file = project.getFile("pom.xml");
                if (file != null) {
                    this.rename(file);
                }
            }
        }
        return null;
    }

    private void rename(IFile file) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean rc = SaveDirtyFilesDialog.saveDirtyFiles("pom.xml");
            if (!rc) {
                return;
            }
            MavenRenameWizard wizard = new MavenRenameWizard(file);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            String titleForFailedChecks = "";
            op.run(shell, titleForFailedChecks);
        }
        catch (Exception e) {
            log.error("Unable to rename " + String.valueOf(file), (Throwable)e);
        }
    }

    protected ISelection computeSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getActiveMenuEditorInput((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        return selection;
    }
}

