/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AbstractMethodCorrectionProposalCore;

public class NewMethodCorrectionProposalCore
extends AbstractMethodCorrectionProposalCore {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private List<Expression> fArguments;
    private Map<ITypeBinding, ITypeBinding> fTypeMapping = new HashMap<ITypeBinding, ITypeBinding>();

    public NewMethodCorrectionProposalCore(String label, ICompilationUnit targetCU, ASTNode invocationNode, List<Expression> arguments, ITypeBinding binding, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance);
        this.fArguments = arguments;
        this.initializeTypeMapping(invocationNode);
    }

    private void initializeTypeMapping(ASTNode invocationNode) {
        ITypeBinding expressionBinding;
        MethodInvocation methodInvocation;
        Expression methodExpression;
        if (invocationNode instanceof MethodInvocation && (methodExpression = (methodInvocation = (MethodInvocation)invocationNode).getExpression()) != null && (expressionBinding = methodExpression.resolveTypeBinding()) != null && expressionBinding.isParameterizedType()) {
            ITypeBinding declaringClass = expressionBinding.getTypeDeclaration();
            ITypeBinding[] declaringClassTypeParameters = declaringClass.getTypeParameters();
            ITypeBinding[] typeArguments = expressionBinding.getTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                this.fTypeMapping.put(typeArguments[i], declaringClassTypeParameters[i]);
                ++i;
            }
        }
    }

    protected int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.getSenderBinding().isAnnotation() || this.getSenderBinding().isEnum()) {
            return 0;
        }
        boolean isTargetInterface = this.getSenderBinding().isInterface();
        if (isTargetInterface && !JavaModelUtil.is1d8OrHigher(this.getCompilationUnit().getJavaProject())) {
            return this.getInterfaceMethodModifiers(targetTypeDecl, true);
        }
        ASTNode invocationNode = this.getInvocationNode();
        if (invocationNode instanceof MethodInvocation) {
            ASTNode node;
            boolean isParentInterface;
            int modifiers = 0;
            Expression expression = ((MethodInvocation)invocationNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext(invocationNode)) {
                modifiers |= 8;
            }
            boolean bl = isParentInterface = (node = ASTResolving.findParentType(invocationNode)) instanceof TypeDeclaration && ((TypeDeclaration)node).isInterface();
            if (isTargetInterface || isParentInterface) {
                if (expression == null && !targetTypeDecl.equals((Object)node)) {
                    modifiers |= 8;
                    modifiers = isTargetInterface ? (modifiers |= this.getInterfaceMethodModifiers(targetTypeDecl, false)) : (modifiers |= 4);
                } else {
                    modifiers = modifiers == 8 ? this.getInterfaceMethodModifiers(targetTypeDecl, false) | 8 : this.getInterfaceMethodModifiers(targetTypeDecl, true);
                }
            } else if (targetTypeDecl.equals((Object)node)) {
                modifiers |= 2;
            } else if (node instanceof AnonymousClassDeclaration && ASTNodes.isParent(node, targetTypeDecl)) {
                modifiers |= 4;
                if (ASTResolving.isInStaticContext(node) && expression == null) {
                    modifiers |= 8;
                }
            } else {
                modifiers |= 1;
            }
            return modifiers;
        }
        return 1;
    }

    private int getInterfaceMethodModifiers(ASTNode targetTypeDecl, boolean createAbstractMethod) {
        if (targetTypeDecl instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)targetTypeDecl;
            MethodDeclaration[] methodDecls = type.getMethods();
            if (methodDecls.length > 0) {
                if (createAbstractMethod) {
                    MethodDeclaration[] methodDeclarationArray = methodDecls;
                    int n = methodDecls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
                        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
                        if (methodBinding != null && JdtFlags.isAbstract(methodBinding)) {
                            return methodDeclaration.getModifiers();
                        }
                        ++n2;
                    }
                }
                return methodDecls[0].getModifiers() & 1;
            }
            List bodyDecls = type.bodyDeclarations();
            if (bodyDecls.size() > 0) {
                return ((BodyDeclaration)bodyDecls.get(0)).getModifiers() & 1;
            }
        }
        return 0;
    }

    @Override
    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List<IExtendedModifier> modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers(targetTypeDecl)));
        ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, modifiers, this.getSenderBinding().isInterface());
    }

    @Override
    protected boolean isConstructor() {
        ASTNode node = this.getInvocationNode();
        return node.getNodeType() != 32 && node.getNodeType() != 48;
    }

    @Override
    protected SimpleName getNewName(ASTRewrite rewrite) {
        ASTNode invocationNode = this.getInvocationNode();
        String name = invocationNode instanceof MethodInvocation ? ((MethodInvocation)invocationNode).getName().getIdentifier() : (invocationNode instanceof SuperMethodInvocation ? ((SuperMethodInvocation)invocationNode).getName().getIdentifier() : this.getSenderBinding().getName());
        AST ast = rewrite.getAST();
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)newNameNode), false, KEY_NAME);
        ASTNode invocationName = this.getInvocationNameNode();
        if (invocationName != null && invocationName.getAST() == ast) {
            this.addLinkedPosition(rewrite.track(invocationName), true, KEY_NAME);
        }
        return newNameNode;
    }

    private ASTNode getInvocationNameNode() {
        ASTNode node = this.getInvocationNode();
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).getName();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).getName();
        }
        if (node instanceof ClassInstanceCreation) {
            Type type = ((ClassInstanceCreation)node).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getType();
            }
            return type;
        }
        return null;
    }

    @Override
    protected Type getNewMethodType(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext importRewriteContext) throws CoreException {
        ITypeBinding[] bindings;
        MethodInvocation parent;
        ASTNode node = this.getInvocationNode();
        AST ast = rewrite.getAST();
        PrimitiveType newTypeNode = null;
        ITypeBinding[] otherProposals = null;
        if (node.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)node.getParent()).getExpression() == node && (bindings = ASTResolving.getQualifierGuess(node.getRoot(), parent.getName().getIdentifier(), parent.arguments(), (IBinding)this.getSenderBinding())).length > 0) {
            ITypeBinding firstBinding = this.getClassTypeParameterBinding(bindings[0]);
            newTypeNode = this.getImportRewrite().addImport(firstBinding, ast, importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            otherProposals = bindings;
        }
        if (newTypeNode == null) {
            ITypeBinding binding = ASTResolving.guessBindingForReference(node);
            if (binding != null && binding.isWildcardType()) {
                binding = ASTResolving.normalizeWildcardType(binding, false, ast);
            }
            if (binding != null) {
                binding = this.getClassTypeParameterBinding(binding);
                newTypeNode = this.getImportRewrite().addImport(binding, ast, importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
            } else {
                ASTNode parent2 = node.getParent();
                if (parent2 instanceof ExpressionStatement) {
                    newTypeNode = ast.newPrimitiveType(PrimitiveType.VOID);
                } else {
                    newTypeNode = ASTResolving.guessTypeForReference(ast, node);
                    if (newTypeNode == null) {
                        newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("Object"));
                    }
                }
            }
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        if (otherProposals != null) {
            ITypeBinding[] iTypeBindingArray = otherProposals;
            int n = otherProposals.length;
            int n2 = 0;
            while (n2 < n) {
                void otherProposal = iTypeBindingArray[n2];
                this.addLinkedPositionProposal(KEY_TYPE, (ITypeBinding)otherProposal);
                ++n2;
            }
        }
        return newTypeNode;
    }

    @Override
    protected void addNewParameters(ASTRewrite rewrite, List<String> takenNames, List<SingleVariableDeclaration> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        List<Expression> arguments = this.fArguments;
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            String argTypeKey = "arg_type_" + i;
            Type type = this.evaluateParameterType(ast, elem, argTypeKey, context);
            param.setType(type);
            String argNameKey = "arg_name_" + i;
            String name = this.evaluateParameterName(takenNames, elem, type, argNameKey);
            param.setName(ast.newSimpleName(name));
            params.add(param);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getType()), false, argTypeKey);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getName()), false, argNameKey);
            ++i;
        }
    }

    private Type evaluateParameterType(AST ast, Expression elem, String key, ImportRewrite.ImportRewriteContext context) {
        ITypeBinding binding = Bindings.normalizeTypeBinding(elem.resolveTypeBinding());
        if (binding != null && binding.isWildcardType()) {
            binding = ASTResolving.normalizeWildcardType(binding, true, ast);
        }
        if (binding != null) {
            binding = this.getClassTypeParameterBinding(binding);
            ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(ast, binding);
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeProposal = iTypeBindingArray[n2];
                this.addLinkedPositionProposal(key, typeProposal);
                ++n2;
            }
            return this.getImportRewrite().addImport(binding, ast, context, ImportRewrite.TypeLocation.PARAMETER);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private ITypeBinding getClassTypeParameterBinding(ITypeBinding binding) {
        ITypeBinding[] typeParameters = new ITypeBinding[]{};
        ITypeBinding declaringClassBinding = binding.getDeclaringClass();
        if (declaringClassBinding != null && declaringClassBinding.isGenericType()) {
            typeParameters = declaringClassBinding.getTypeParameters();
        } else {
            IMethodBinding methodBinding = binding.getDeclaringMethod();
            if (methodBinding != null) {
                typeParameters = methodBinding.getTypeParameters();
            }
        }
        ITypeBinding[] iTypeBindingArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParameter = iTypeBindingArray[n2];
            if (typeParameter.isEqualTo((IBinding)binding) && this.fTypeMapping.containsKey(binding)) {
                return this.fTypeMapping.get(binding);
            }
            ++n2;
        }
        return binding;
    }

    private String evaluateParameterName(List<String> takenNames, Expression argNode, Type type, String key) {
        String[] names;
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] stringArray = names = StubUtility.getVariableNameSuggestions(4, project, type, argNode, takenNames);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addLinkedPositionProposal(key, name);
            ++n2;
        }
        String favourite = names[0];
        takenNames.add(favourite);
        return favourite;
    }

    @Override
    protected void addNewExceptions(ASTRewrite rewrite, List<Type> exceptions, ImportRewrite.ImportRewriteContext context) throws CoreException {
    }

    private void getTypeParameters(ITypeBinding binding, Set<ITypeBinding> typeParametersFound) {
        block8: {
            ITypeBinding[] typeParameters;
            ASTNode invocationNode;
            block7: {
                ITypeBinding[] typeParameters2;
                if (!this.getClassTypeParameterBinding(binding).isEqualTo((IBinding)binding)) {
                    return;
                }
                IMethodBinding methodBinding = binding.getDeclaringMethod();
                if (methodBinding == null) break block7;
                ITypeBinding[] iTypeBindingArray = typeParameters2 = methodBinding.getTypeParameters();
                int n = typeParameters2.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeParameter = iTypeBindingArray[n2];
                    if (typeParameter.isEqualTo((IBinding)binding)) {
                        ITypeBinding[] typeBounds;
                        typeParametersFound.add(typeParameter);
                        ITypeBinding[] iTypeBindingArray2 = typeBounds = typeParameter.getTypeBounds();
                        int n3 = typeBounds.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ITypeBinding typeBound = iTypeBindingArray2[n4];
                            this.getTypeParameters(typeBound, typeParametersFound);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                break block8;
            }
            ITypeBinding declaringClassBinding = binding.getDeclaringClass();
            if (declaringClassBinding == null || !((invocationNode = this.getInvocationNode()) instanceof MethodInvocation) || ((MethodInvocation)invocationNode).getExpression() == null || ((MethodInvocation)invocationNode).getExpression() instanceof ThisExpression) break block8;
            ITypeBinding[] iTypeBindingArray = typeParameters = declaringClassBinding.getTypeParameters();
            int n = typeParameters.length;
            int n5 = 0;
            while (n5 < n) {
                ITypeBinding typeParameter = iTypeBindingArray[n5];
                if (typeParameter.isEqualTo((IBinding)binding)) {
                    ITypeBinding[] typeBounds;
                    typeParametersFound.add(typeParameter);
                    ITypeBinding[] iTypeBindingArray3 = typeBounds = typeParameter.getTypeBounds();
                    int n6 = typeBounds.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ITypeBinding typeBound = iTypeBindingArray3[n7];
                        this.getTypeParameters(typeBound, typeParametersFound);
                        ++n7;
                    }
                }
                ++n5;
            }
        }
    }

    @Override
    protected void addNewTypeParameters(ASTRewrite rewrite, List<String> takenNames, List<TypeParameter> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        ASTNode node = this.getInvocationNode();
        LinkedHashSet<ITypeBinding> typeParametersFound = new LinkedHashSet<ITypeBinding>();
        ITypeBinding returnTypeBinding = null;
        if (!this.isConstructor()) {
            ITypeBinding[] bindings;
            MethodInvocation parent;
            if (node.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)node.getParent()).getExpression() == node && (bindings = ASTResolving.getQualifierGuess(node.getRoot(), parent.getName().getIdentifier(), parent.arguments(), (IBinding)this.getSenderBinding())).length > 0) {
                returnTypeBinding = bindings[0];
            }
            if (returnTypeBinding == null) {
                ITypeBinding binding = ASTResolving.guessBindingForReference(node);
                if (binding != null && binding.isWildcardType()) {
                    binding = ASTResolving.normalizeWildcardType(binding, false, ast);
                }
                returnTypeBinding = binding;
            }
            if (returnTypeBinding != null) {
                this.getTypeParameters(returnTypeBinding, typeParametersFound);
            }
        }
        List<Expression> arguments = this.fArguments;
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = arguments.get(i);
            ITypeBinding binding = Bindings.normalizeTypeBinding(elem.resolveTypeBinding());
            if (binding != null && binding.isWildcardType()) {
                binding = ASTResolving.normalizeWildcardType(binding, true, ast);
            }
            if (binding != null) {
                this.getTypeParameters(binding, typeParametersFound);
            }
            ++i;
        }
        for (ITypeBinding m : typeParametersFound) {
            TypeParameter newTypeParameter = ast.newTypeParameter();
            newTypeParameter.setName(ast.newSimpleName(m.getName()));
            params.add(newTypeParameter);
            ITypeBinding[] bounds = m.getTypeBounds();
            List newTypeBounds = newTypeParameter.typeBounds();
            ITypeBinding[] iTypeBindingArray = bounds;
            int n = bounds.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding bound = iTypeBindingArray[n2];
                Type t = this.getImportRewrite().addImport(bound, ast, context, ImportRewrite.TypeLocation.TYPE_PARAMETER);
                newTypeBounds.add(t);
                ++n2;
            }
        }
    }
}

