/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo.util;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.BootstrapForOOoComposite;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.ui.editors.ooo.initializer.util.OOoEditorInitUtil;
import org.eclipse.actf.util.win32.WindowUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ODFUtils {
    public static int getDrawPageCount(XComponent xComponent) {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        return xDrawPages.getCount();
    }

    public static XDrawPage getDrawPageByIndex(XComponent xComponent, int n) throws ODFException {
        try {
            XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
            XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
            return (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            throw new ODFException(indexOutOfBoundsException.getMessage());
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
            throw new ODFException(wrappedTargetException.getMessage());
        }
    }

    public static ODFConstants.ContentType getODFFileType(Document document) {
        Element element;
        if (document != null && (element = document.getDocumentElement()) instanceof DocumentContentElement) {
            return ((DocumentContentElement)element).getBodyElement().getContent().getContentType();
        }
        return ODFConstants.ContentType.NONE;
    }

    public static XFrame getXFrame(XComponentContext xComponentContext) throws ODFException {
        XComponent xComponent = ODFUtils.getXComponent(xComponentContext);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        return xModel.getCurrentController().getFrame();
    }

    public static XDispatchHelper getXDispatchHelper(XComponentContext xComponentContext) throws ODFException {
        XDispatchHelper xDispatchHelper = null;
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.DispatchHelper", xComponentContext);
            xDispatchHelper = (XDispatchHelper)UnoRuntime.queryInterface(XDispatchHelper.class, (Object)object);
        }
        catch (Exception exception) {
            throw new ODFException(exception.getMessage());
        }
        return xDispatchHelper;
    }

    public static XLayoutManager getXLayoutManager(XFrame xFrame) throws ODFException {
        XLayoutManager xLayoutManager = null;
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFrame);
        try {
            xLayoutManager = (XLayoutManager)UnoRuntime.queryInterface(XLayoutManager.class, (Object)xPropertySet.getPropertyValue("LayoutManager"));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new ODFException(unknownPropertyException.getMessage());
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ODFException(wrappedTargetException.getMessage());
        }
        return xLayoutManager;
    }

    public static XComponent getXComponent(XComponentContext xComponentContext) throws ODFException {
        XDesktop xDesktop = BootstrapForOOoComposite.getXDesktop();
        XEnumerationAccess xEnumerationAccess = xDesktop.getComponents();
        XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
        while (xEnumeration.hasMoreElements()) {
            Object object = null;
            try {
                object = xEnumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ODFException(noSuchElementException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new ODFException(wrappedTargetException.getMessage());
            }
            if (object == null) continue;
            return (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object);
        }
        return null;
    }

    public static XDesktop getXDesktop(XComponentContext xComponentContext) throws ODFException {
        XDesktop xDesktop = null;
        try {
            XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", xComponentContext);
            xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)object);
        }
        catch (Exception exception) {
            throw new ODFException(exception.getMessage());
        }
        return xDesktop;
    }

    public static ClassLoader loadOpenOfficeLibs() throws ODFException {
        Object object;
        String string = String.valueOf(OOoEditorInitUtil.getOpenOfficePath()) + "\\";
        File file = new File(String.valueOf(string) + "msvcr71.dll");
        if (file.exists()) {
            System.load(file.getPath());
        }
        if (System.getProperty("java.vm.vendor").equals("IBM Corporation")) {
            object = System.getProperty("com.ibm.oti.vm.bootstrap.library.path");
            new Color(0, 0, 0);
            System.load(String.valueOf(object) + "\\jawt.dll");
        } else if (System.getProperty("java.vm.vendor").equals("Sun Microsystems Inc.")) {
            object = System.getProperty("java.home");
            new Color(0, 0, 0);
            System.load(String.valueOf(object) + "\\bin\\jawt.dll");
        } else {
            throw new ODFException("should be launched by using IBM Java");
        }
        System.load(String.valueOf(string) + "..\\URE\\bin\\uwinapi.dll");
        try {
            System.load(String.valueOf(string) + "officebean.dll");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.load(String.valueOf(string) + "..\\Basis\\program\\officebean.dll");
        }
        System.load(String.valueOf(string) + "..\\URE\\bin\\sal3.dll");
        System.load(String.valueOf(string) + "..\\URE\\bin\\jpipe.dll");
        object = null;
        try {
            URL[] uRLArray = new URL[]{new File(String.valueOf(string) + "..\\URE\\java\\juh.jar").toURL(), new File(String.valueOf(string) + "..\\URE\\java\\jurt.jar").toURL(), new File(String.valueOf(string) + "..\\URE\\java\\ridl.jar").toURL(), new File(String.valueOf(string) + "..\\Basis\\program\\classes\\unoil.jar").toURL()};
            object = new URLClassLoader(uRLArray, Bootstrap.class.getClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ODFException(malformedURLException.getMessage());
        }
        return object;
    }

    private static String getWindowClass(int n) {
        return WindowUtil.GetWindowClassName((int)n);
    }

    private static int getOpenOfficeFrameNum(int n, int n2) {
        int n3 = n2;
        int n4 = WindowUtil.GetChildWindow((int)n);
        while (n4 != 0) {
            String string = ODFUtils.getWindowClass(n4);
            n3 = string.equals("SALTMPSUBFRAME") ? ++n3 : ODFUtils.getOpenOfficeFrameNum(n4, n3);
            n4 = WindowUtil.GetNextWindow((int)n4);
        }
        return n3;
    }

    public static int getOpenOfficeFrameNum() {
        int n = 0;
        int n2 = WindowUtil.GetChildWindow((int)WindowUtil.GetDesktopWindow());
        while (n2 != 0) {
            n = ODFUtils.getOpenOfficeFrameNum(n2, n);
            String string = ODFUtils.getWindowClass(n2);
            n = string.equals("SALFRAME") ? ++n : ODFUtils.getOpenOfficeFrameNum(n2, n);
            n2 = WindowUtil.GetNextWindow((int)n2);
        }
        return n;
    }
}

