/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.util;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class ImageOverlayUtil {
    public static final PaletteData PALETTE = new PaletteData(255, 65280, 0xFF0000);

    public static boolean overlay(Image image, Image image2) {
        GC gC;
        block3: {
            try {
                gC = new GC((Drawable)image);
                if (image2 != null && !image2.isDisposed()) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        gC.drawImage(image2, 0, 0);
        gC.dispose();
        return true;
    }

    public static boolean overlay(Image image, int[][] nArray, int n) {
        try {
            int n2 = nArray[0].length;
            int n3 = nArray.length;
            ImageData imageData = new ImageData(n2, n3, 24, PALETTE);
            imageData.alpha = n;
            int n4 = 0;
            while (n4 < n3) {
                imageData.setPixels(0, n4, n2, nArray[n4], 0);
                ++n4;
            }
            Image image2 = new Image((Device)Display.getDefault(), imageData);
            boolean bl = ImageOverlayUtil.overlay(image, image2);
            image2.dispose();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean overlay(Image image, int n, int[] nArray, int n2) {
        try {
            int n3 = nArray.length / n;
            ImageData imageData = new ImageData(n, n3, 24, PALETTE);
            imageData.alpha = n2;
            int n4 = 0;
            while (n4 < n3) {
                imageData.setPixels(0, n4, n, nArray, n * n4);
                ++n4;
            }
            Image image2 = new Image((Device)Display.getDefault(), imageData);
            boolean bl = ImageOverlayUtil.overlay(image, image2);
            image2.dispose();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

