/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.IdentifiableItemProvider;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.provider.GraphEditPlugin;

public class GraphItemProvider
extends IdentifiableItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private List<TransientGraphItemProvider> children;

    public GraphItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTimePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Object getParent(Object object) {
        return super.getParent(object);
    }

    public Collection<?> getChildren(Object object) {
        Graph graph = (Graph)object;
        this.children = new ArrayList<TransientGraphItemProvider>();
        if (graph.getNumEdges() > 0) {
            this.children.add(new EdgesItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumNodes() > 0) {
            this.children.add(new NodesItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumNodeLabels() > 0) {
            this.children.add(new NodeLabelsItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumGraphLabels() > 0) {
            this.children.add(new GraphLabelsItemProvider(this.adapterFactory, graph));
        }
        Collection otherChildren = super.getChildren(object);
        otherChildren.addAll(this.children);
        return otherChildren;
    }

    protected void addTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Graph_time_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Graph_time_feature", "_UI_Graph_type"), (EStructuralFeature)GraphPackage.Literals.GRAPH__TIME, false, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(GraphPackage.Literals.GRAPH__UNRESOLVED_IDENTIFIABLES);
            this.childrenFeatures.add(GraphPackage.Literals.GRAPH__DECORATORS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Graph"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String getTextGen(Object object) {
        URI labelValue = ((Graph)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Graph_type") : String.valueOf(this.getString("_UI_Graph_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Graph.class)) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Graph.class)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 13: 
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }

    public void dispose() {
        super.dispose();
        if (this.children != null) {
            Iterator<TransientGraphItemProvider> iter = this.children.iterator();
            while (iter.hasNext()) {
                ((IDisposable)iter.next()).dispose();
            }
        }
    }

    public static class EdgesItemProvider
    extends TransientGraphItemProvider {
        public EdgesItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Edge"));
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Graph.class)) {
                case 3: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, msg));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
            super.collectNewChildDescriptors(newChildDescriptors, object);
            newChildDescriptors.add(this.createChildParameter(GraphPackage.eINSTANCE.getGraph_Edges(), GraphFactory.eINSTANCE.createEdge()));
        }

        @Override
        protected String getText() {
            return "Edges";
        }

        protected EMap<URI, Edge> getIdentifiableMap(Graph graph) {
            return graph.getEdges();
        }

        @Override
        protected EObject getMapEntry(URI key, Identifiable value) {
            EObject retValue = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY__KEY, (Object)key);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY__VALUE, (Object)value);
            return retValue;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToEdgeMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__EDGES;
        }
    }

    protected static class GraphLabelsItemProvider
    extends TransientGraphItemProvider {
        public GraphLabelsItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/StaticLabel"));
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Graph.class)) {
                case 5: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, msg));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
            super.collectNewChildDescriptors(newChildDescriptors, object);
        }

        @Override
        protected String getText() {
            return "Graph Labels";
        }

        protected EMap<URI, Label> getIdentifiableMap(Graph graph) {
            return graph.getGraphLabels();
        }

        @Override
        protected EObject getMapEntry(URI key, Identifiable value) {
            EObject retValue = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY__KEY, (Object)key);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY__VALUE, (Object)value);
            return retValue;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToLabelMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__GRAPH_LABELS;
        }
    }

    protected static class NodeLabelsItemProvider
    extends TransientGraphItemProvider {
        public NodeLabelsItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/StaticLabel"));
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Graph.class)) {
                case 6: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, msg));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
            super.collectNewChildDescriptors(newChildDescriptors, object);
        }

        @Override
        protected String getText() {
            return "Node Labels";
        }

        protected EMap<URI, NodeLabel> getIdentifiableMap(Graph graph) {
            return graph.getNodeLabels();
        }

        @Override
        protected EObject getMapEntry(URI key, Identifiable value) {
            EObject retValue = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY__KEY, (Object)key);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY__VALUE, (Object)value);
            return retValue;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToNodeLabelMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__NODE_LABELS;
        }
    }

    protected static class NodesItemProvider
    extends TransientGraphItemProvider {
        public NodesItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Node"));
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(Graph.class)) {
                case 4: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, msg));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
            super.collectNewChildDescriptors(newChildDescriptors, object);
            newChildDescriptors.add(this.createChildParameter(GraphPackage.eINSTANCE.getGraph_Nodes(), GraphFactory.eINSTANCE.createNode()));
        }

        @Override
        protected String getText() {
            return "Nodes";
        }

        protected EMap<URI, Node> getIdentifiableMap(Graph graph) {
            return graph.getNodes();
        }

        @Override
        protected EObject getMapEntry(URI key, Identifiable value) {
            EObject retValue = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY__KEY, (Object)key);
            retValue.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY__VALUE, (Object)value);
            return retValue;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToNodeMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__NODES;
        }
    }

    public static abstract class TransientGraphItemProvider
    extends ItemProviderAdapter
    implements IEditingDomainItemProvider,
    IStructuredItemContentProvider,
    ITreeItemContentProvider,
    IItemLabelProvider,
    IItemPropertySource {
        public TransientGraphItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory);
            graph.eAdapters().add((Object)this);
        }

        protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
            if (this.childrenFeatures == null) {
                super.getChildrenFeatures(object);
                this.childrenFeatures.add(this.getMapReference());
            }
            return this.childrenFeatures;
        }

        protected Object getFeatureValue(EObject object, EStructuralFeature feature) {
            if (object == null) {
                return ((Graph)this.target).eGet(feature);
            }
            return super.getFeatureValue(object, feature);
        }

        public Object getParent(Object object) {
            return this.target;
        }

        public Collection<Identifiable> getChildren(Object object) {
            Graph graph = (Graph)this.target;
            ArrayList<Identifiable> children = new ArrayList<Identifiable>();
            children.addAll(this.getIdentifiableMap(graph).values());
            return children;
        }

        public String getText(Object object) {
            StringBuilder sb = new StringBuilder(this.getText());
            sb.append(" (");
            sb.append(Integer.toString(this.getIdentifiableMap((Graph)this.target).size()));
            sb.append(")");
            return sb.toString();
        }

        protected String getFeatureText(Object feature) {
            return super.getFeatureText((Object)this.target);
        }

        public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
            return super.getNewChildDescriptors((Object)this.target, editingDomain, sibling);
        }

        public ResourceLocator getResourceLocator() {
            return GraphEditPlugin.INSTANCE;
        }

        protected abstract String getText();

        protected abstract EMap<URI, ? extends Identifiable> getIdentifiableMap(Graph var1);

        protected abstract EObject getMapEntry(URI var1, Identifiable var2);

        protected abstract EStructuralFeature getMapEntryValueEReference();

        protected abstract EReference getMapReference();

        protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
            return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner);
        }

        protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
            return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner);
        }

        protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
            Object retValue = null;
            retValue = new AddCommand(domain, (EObject)this.target, (EStructuralFeature)this.getMapReference(), collection).canExecute() ? super.createDragAndDropCommand(domain, (Object)this.target, location, operations, operation, collection) : UnexecutableCommand.INSTANCE;
            return retValue;
        }

        protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
            Object retValue = null;
            retValue = !(value instanceof Identifiable) ? super.createCreateChildCommand(domain, owner, feature, value, index, collection) : new CreateChildCommand(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this){

                protected Command createCommand() {
                    SetCommand result = null;
                    Graph graph = (Graph)TransientGraphItemProvider.this.target;
                    Identifiable newChildIdentifiable = (Identifiable)this.child;
                    URI uri = newChildIdentifiable.getURI();
                    Identifiable existingIdentifiable = (Identifiable)TransientGraphItemProvider.this.getIdentifiableMap(graph).get((Object)uri);
                    if (existingIdentifiable == null) {
                        EObject mapEntry = TransientGraphItemProvider.this.getMapEntry(uri, newChildIdentifiable);
                        result = new AddCommand(this.domain, (EObject)graph, (EStructuralFeature)TransientGraphItemProvider.this.getMapReference(), (Object)mapEntry);
                    } else {
                        EObject mapEntry = existingIdentifiable.eContainer();
                        result = new SetCommand(this.domain, mapEntry, TransientGraphItemProvider.this.getMapEntryValueEReference(), (Object)newChildIdentifiable);
                    }
                    return result;
                }
            };
            return retValue;
        }

        protected Command createWrappedCommand(Command command, final EObject owner) {
            return new CommandWrapper(command){

                public Collection<?> getAffectedObjects() {
                    Set<TransientGraphItemProvider> affected = super.getAffectedObjects();
                    if (affected.contains(owner)) {
                        affected = Collections.singleton(TransientGraphItemProvider.this);
                    }
                    return affected;
                }
            };
        }
    }
}

