/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.TraversalData;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeParameterByConstraintSubstitutor
extends TypeParameterSubstitutor {
    public TypeParameterByConstraintSubstitutor(Map<JvmTypeParameter, JvmTypeReference> typeParameterMapping, CommonTypeComputationServices services) {
        super(typeParameterMapping, services);
    }

    @Override
    public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            if (!visiting.add((JvmTypeParameter)type)) {
                return null;
            }
            try {
                JvmTypeReference mappedReference = this.getTypeParameterMapping().get(type);
                if (mappedReference != null && mappedReference != reference) {
                    JvmTypeReference jvmTypeReference = (JvmTypeReference)this.visit(mappedReference, visiting);
                    return jvmTypeReference;
                }
                mappedReference = this.getUnmappedSubstitute(reference, (JvmTypeParameter)type, visiting);
                if (mappedReference != null) {
                    JvmTypeReference jvmTypeReference = mappedReference;
                    return jvmTypeReference;
                }
            }
            finally {
                visiting.remove(type);
            }
        }
        JvmParameterizedTypeReference result = this.getServices().getTypesFactory().createJvmParameterizedTypeReference();
        result.setType(type);
        int i = 0;
        while (i < reference.getArguments().size()) {
            JvmTypeReference argument = (JvmTypeReference)reference.getArguments().get(i);
            JvmTypeReference copiedArgument = (JvmTypeReference)this.visit(argument, visiting);
            if (copiedArgument == null) {
                copiedArgument = this.getDeclaredUpperBound(type, i, visiting);
            }
            result.getArguments().add((Object)copiedArgument);
            ++i;
        }
        return result;
    }

    protected JvmTypeReference getUnmappedSubstitute(JvmParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
        ConstraintAwareTypeArgumentCollector collector = new ConstraintAwareTypeArgumentCollector(this.getServices().getTypesFactory());
        TraversalData data = new TraversalData();
        data.getTypeParameterMapping().putAll(this.getTypeParameterMapping());
        collector.visit((JvmTypeReference)reference, data);
        JvmTypeReference mappedReference = data.getTypeParameterMapping().get(type);
        if (mappedReference != null && mappedReference != reference) {
            return (JvmTypeReference)this.visit(mappedReference, visiting);
        }
        return mappedReference;
    }

    protected JvmTypeReference getDeclaredUpperBound(JvmType type, int parameterIndex, Set<JvmTypeParameter> visiting) {
        JvmTypeConstraint constraint;
        JvmTypeParameter typeParameter;
        JvmTypeParameterDeclarator typeParameterDeclarator;
        JvmTypeReference result = null;
        if (type instanceof JvmTypeParameterDeclarator && (typeParameterDeclarator = (JvmTypeParameterDeclarator)type).getTypeParameters().size() > parameterIndex && !(typeParameter = (JvmTypeParameter)typeParameterDeclarator.getTypeParameters().get(parameterIndex)).getConstraints().isEmpty() && (constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0)) instanceof JvmUpperBound) {
            result = (JvmTypeReference)this.visit(constraint.getTypeReference(), visiting);
        }
        if (result == null) {
            result = this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)type, new JvmTypeReference[0]);
        }
        return result;
    }

    @Override
    public JvmTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmWildcardTypeReference result = this.getServices().getTypesFactory().createJvmWildcardTypeReference();
        for (JvmTypeConstraint constraint : reference.getConstraints()) {
            JvmTypeReference copiedConstraintReference = (JvmTypeReference)this.visit(constraint.getTypeReference(), visiting);
            if (copiedConstraintReference == null) {
                return null;
            }
            JvmTypeConstraint copiedConstraint = (JvmTypeConstraint)EcoreUtil.create((EClass)constraint.eClass());
            copiedConstraint.setTypeReference(copiedConstraintReference);
            result.getConstraints().add((Object)copiedConstraint);
        }
        return result;
    }

    @Override
    public JvmTypeReference substitute(JvmTypeReference original) {
        JvmTypeReference result = (JvmTypeReference)this.visit(original, Sets.newHashSet());
        return result;
    }
}

