/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.views.ConfigurationView;
import org.eclipse.update.internal.ui.views.IPreviewTask;
import org.eclipse.update.operations.IUpdateModelChangedListener;

public class ConfigurationPreview
implements IUpdateModelChangedListener {
    private ScrolledForm form;
    private ConfigurationView view;
    private FormToolkit toolkit;
    private FormText desc;
    private FormText taskList;
    private IPreviewTask[] tasks;

    public ConfigurationPreview(ConfigurationView view) {
        this.view = view;
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        model.addUpdateModelChangedListener(this);
    }

    public void dispose() {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        model.removeUpdateModelChangedListener(this);
        this.toolkit.dispose();
    }

    public void objectsAdded(Object parent, Object[] children) {
    }

    public void objectsRemoved(Object parent, Object[] children) {
    }

    public void objectChanged(Object object, String property) {
    }

    public Control getControl() {
        return this.form;
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        layout.leftMargin = 10;
        layout.rightMargin = 5;
        layout.topMargin = 10;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 20;
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String url = (String)e.getHref();
                if (url != null) {
                    UpdateUI.showURL(url);
                }
            }
        };
        HyperlinkAdapter taskAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String indexArg = (String)e.getHref();
                try {
                    int index = Integer.parseInt(indexArg);
                    if (ConfigurationPreview.this.tasks != null) {
                        ConfigurationPreview.this.tasks[index].run();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        };
        this.desc = this.toolkit.createFormText(this.form.getBody(), true);
        this.desc.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
        this.desc.addHyperlinkListener((IHyperlinkListener)urlAction);
        this.desc.setText("", false, false);
        TableWrapData td = new TableWrapData(256);
        this.desc.setLayoutData((Object)td);
        this.taskList = this.toolkit.createFormText(this.form.getBody(), false);
        this.taskList.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
        this.taskList.addHyperlinkListener((IHyperlinkListener)taskAction);
        this.taskList.setText("", false, false);
        td = new TableWrapData(256);
        this.taskList.setLayoutData((Object)td);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.update.ui.SiteForm");
    }

    public void setSelection(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        this.tasks = this.view.getPreviewTasks(object);
        String title = this.getObjectLabel(selection.size() > 1 ? selection : object);
        this.form.setText(title);
        String description = this.getObjectDescription(selection.size() > 1 ? selection : object);
        boolean tags = description.startsWith("<form>");
        this.desc.setText(description, tags, !tags);
        String taskText = this.getTasksText();
        this.taskList.setText(taskText, true, false);
        this.form.reflow(true);
    }

    private String getObjectLabel(Object object) {
        if (object == null) {
            return "";
        }
        TreeViewer viewer = this.view.getTreeViewer();
        LabelProvider provider = (LabelProvider)viewer.getLabelProvider();
        if (object instanceof IStructuredSelection) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            int counter = 1;
            Iterator iter = ((IStructuredSelection)object).iterator();
            while (iter.hasNext()) {
                pw.println(String.valueOf(counter) + ". " + provider.getText(iter.next()));
                ++counter;
            }
            return sw.toString();
        }
        return provider.getText(object);
    }

    private String getObjectDescription(Object object) {
        if (object instanceof IFeatureAdapter) {
            return this.getFeatureDescription((IFeatureAdapter)object);
        }
        if (object instanceof IConfiguredSiteAdapter) {
            return UpdateUIMessages.ConfigurationPreviewForm_install;
        }
        if (object instanceof ILocalSite) {
            return UpdateUIMessages.ConfigurationPreviewForm_configDescription;
        }
        return "";
    }

    private String getFeatureDescription(IFeatureAdapter adapter) {
        try {
            String text;
            IFeature feature = adapter.getFeature(null);
            IURLEntry entry = feature.getDescription();
            if (entry != null && (text = entry.getAnnotation()) != null) {
                URL url = entry.getURL();
                if (url == null) {
                    return text;
                }
                String link = " <a href=\"" + url + "\">" + UpdateUIMessages.MoreInfoGenerator_moreInfo + "</a>";
                String fullText = "<form><p>" + text + link + "</p></form>";
                return fullText;
            }
        }
        catch (CoreException coreException) {}
        return "";
    }

    private String getTasksText() {
        if (this.tasks == null || this.tasks.length == 0) {
            return "<form/>";
        }
        boolean hasEnabledTasks = false;
        int i = 0;
        while (i < this.tasks.length) {
            if (this.tasks[i].isEnabled()) {
                hasEnabledTasks = true;
                break;
            }
            ++i;
        }
        if (!hasEnabledTasks) {
            return "<form/>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><b>");
        buf.append(UpdateUIMessages.ConfigurationPreviewForm_AvailableTasks);
        buf.append("</b></p>");
        int i2 = 0;
        while (i2 < this.tasks.length) {
            IPreviewTask task = this.tasks[i2];
            if (task.isEnabled()) {
                buf.append("<li style=\"text\" indent=\"0\"><a href=\"" + i2 + "\">" + task.getName() + "</a></li>");
                buf.append("<li style=\"text\" indent=\"10\" vspace=\"false\">" + task.getDescription() + "</li>");
            }
            ++i2;
        }
        buf.append("</form>");
        return buf.toString();
    }
}

