/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.shared.jdt38;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceInformation;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;

public class OriginalEditorSelector
implements IEditorAssociationOverride {
    private static final Logger logger = Logger.getLogger(OriginalEditorSelector.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private ITraceInformation traceInformation;
    @Inject
    private IWorkbench workbench;
    @Inject
    private StacktraceBasedEditorDecider decisions;

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorDescriptor xbaseEditor = this.findXbaseEditor(editorInput);
        if (xbaseEditor != null) {
            List result = Lists.asList((Object)xbaseEditor, (Object[])editorDescriptors);
            return result.toArray(new IEditorDescriptor[result.size()]);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorDescriptors;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor result = this.findXbaseEditor(editorInput);
        if (result != null) {
            return result;
        }
        return editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorDescriptor;
    }

    public IEditorDescriptor findXbaseEditor(IEditorInput editorInput) {
        IFile resource;
        block8: {
            block7: {
                block6: {
                    resource = ResourceUtil.getFile((IEditorInput)editorInput);
                    if (resource != null) break block6;
                    return null;
                }
                String favoriteEditor = resource.getPersistentProperty(IDE.EDITOR_KEY);
                if (favoriteEditor == null) break block7;
                return null;
            }
            StacktraceBasedEditorDecider.Decision decision = this.decisions.decideAccordingToCaller();
            if (decision != StacktraceBasedEditorDecider.Decision.FORCE_JAVA) break block8;
            return null;
        }
        try {
            XtextEditorInfo editorInfo;
            ILocationInResource sourceInformation;
            IResourceServiceProvider serviceProvider;
            Iterator sourceInformationIterator;
            ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)resource);
            if (traceToSource != null && (sourceInformationIterator = traceToSource.getAllAssociatedLocations().iterator()).hasNext() && (serviceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider((sourceInformation = (ILocationInResource)sourceInformationIterator.next()).getResourceURI())) != null && (editorInfo = (XtextEditorInfo)serviceProvider.get(XtextEditorInfo.class)) != null) {
                IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
                IEditorDescriptor result = editorRegistry.findEditor(editorInfo.getEditorId());
                return result;
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

