/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.common.base.CharMatcher;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProviderFactory;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.xtext.ui.AbstractTypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.IntersectingJavaSearchScope;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypeRelevance;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtTypesProposalProvider
extends AbstractTypesProposalProvider {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IEObjectHover hover;
    @Inject
    private JdtTypeProviderFactory jdtTypeProviderFatory;
    @Inject
    private JdtTypeRelevance jdtTypeRelevance;
    @Inject
    private IContentProposalPriorities priorities;
    @Inject
    private IDirtyStateManager dirtyStateManager;

    @Override
    public void createSubTypeProposals(JvmType superType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, EReference typeReference, final ITypesProposalProvider.Filter filter, IValueConverter<String> valueConverter, ICompletionProposalAcceptor acceptor) {
        if (superType == null || superType.eIsProxy()) {
            return;
        }
        if (superType.eResource() == null || superType.eResource().getResourceSet() == null) {
            return;
        }
        IJavaProject project = this.getProjectProvider().getJavaProject(superType.eResource().getResourceSet());
        if (project == null) {
            return;
        }
        String fqn = superType.getIdentifier();
        if (Object.class.getName().equals(fqn)) {
            this.createTypeProposals(project, proposalFactory, context, typeReference, filter, valueConverter, acceptor);
            return;
        }
        final Set superTypes = this.superTypeCollector.collectSuperTypeNames(superType);
        try {
            IType type = project.findType(fqn);
            if (type != null) {
                IJavaSearchScope hierarchyScope = SearchEngine.createHierarchyScope((IType)type);
                IJavaSearchScope projectScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
                IntersectingJavaSearchScope scope = new IntersectingJavaSearchScope(projectScope, hierarchyScope);
                this.searchAndCreateProposals(scope, proposalFactory, context, typeReference, TypeMatchFilters.and(filter, new ITypesProposalProvider.Filter(){

                    public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
                        if (packageName.length != 0) {
                            fqName.append(packageName);
                            fqName.append('.');
                        }
                        char[][] cArray = enclosingTypeNames;
                        int n = enclosingTypeNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] enclosingType = cArray[n2];
                            fqName.append(enclosingType);
                            fqName.append('$');
                            ++n2;
                        }
                        fqName.append(simpleTypeName);
                        String fqNameAsString = fqName.toString();
                        return !superTypes.contains(fqNameAsString);
                    }

                    public int getSearchFor() {
                        return filter.getSearchFor();
                    }
                }), valueConverter, acceptor);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void searchAndCreateProposals(IJavaSearchScope scope, final ICompletionProposalFactory proposalFactory, ContentAssistContext context, EReference typeReference, final ITypesProposalProvider.Filter filter, IValueConverter<String> valueConverter, final ICompletionProposalAcceptor acceptor) throws JavaModelException {
        String prefix = context.getPrefix();
        List split = Strings.split((String)prefix, (char)'.');
        char[] typeName = null;
        char[] packageName = null;
        if (prefix.length() > 0 && !split.isEmpty()) {
            CharMatcher dotMatcher = CharMatcher.is((char)'.');
            if (Character.isUpperCase(((String)split.get(split.size() - 1)).charAt(0))) {
                typeName = ((String)split.get(split.size() - 1)).toCharArray();
                if (split.size() > 1) {
                    packageName = ("*" + dotMatcher.replaceFrom((CharSequence)prefix.substring(0, prefix.length() - (typeName.length + 1)), (CharSequence)"*.") + "*").toCharArray();
                }
            } else {
                if (prefix.endsWith(".")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                packageName = ("*" + dotMatcher.replaceFrom((CharSequence)prefix, (CharSequence)"*.") + "*").toCharArray();
            }
        }
        IScope typeScope = null;
        if (context.getCurrentModel() != null) {
            typeScope = this.scopeProvider.getScope(context.getCurrentModel(), typeReference);
        }
        final ConfigurableCompletionProposal.IReplacementTextApplier textApplier = this.createTextApplier(context, typeScope, this.qualifiedNameConverter, valueConverter);
        ICompletionProposalAcceptor.Delegate scopeAware = new ICompletionProposalAcceptor.Delegate(acceptor){

            public void accept(ICompletionProposal proposal) {
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ((ConfigurableCompletionProposal)proposal).setTextApplier(textApplier);
                }
                super.accept(proposal);
            }
        };
        ContentAssistContext.Builder contextBuilder = context.copy();
        final PrefixMatcher original = context.getMatcher();
        contextBuilder.setMatcher(new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                if (original.isCandidateMatchingPrefix(name, prefix)) {
                    return true;
                }
                String sub = name;
                int delimiter = sub.indexOf(46);
                while (delimiter != -1) {
                    if ((delimiter = (sub = sub.substring(delimiter + 1)).indexOf(46)) != -1 && (prefix.length() <= 0 || !Character.isLowerCase(prefix.charAt(0))) || !original.isCandidateMatchingPrefix(sub, prefix)) continue;
                    return true;
                }
                return false;
            }
        });
        final ContentAssistContext myContext = contextBuilder.toContext();
        IJvmTypeProvider jvmTypeProvider = this.jdtTypeProviderFatory.findOrCreateTypeProvider(context.getResource().getResourceSet());
        BasicSearchEngine searchEngine = new BasicSearchEngine();
        searchEngine.searchAllTypeNames(packageName, 2, typeName, 129, filter.getSearchFor(), scope, new IRestrictedAccessTypeRequestor((ICompletionProposalAcceptor)scopeAware, jvmTypeProvider, valueConverter){
            private final /* synthetic */ ICompletionProposalAcceptor val$scopeAware;
            private final /* synthetic */ IJvmTypeProvider val$jvmTypeProvider;
            private final /* synthetic */ IValueConverter val$valueConverter;
            {
                this.val$scopeAware = iCompletionProposalAcceptor;
                this.val$jvmTypeProvider = iJvmTypeProvider;
                this.val$valueConverter = iValueConverter;
            }

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                if (filter.accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path) && (access == null || access.getProblemId() != 0x1000133 && !access.ignoreIfBetter())) {
                    StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
                    if (packageName.length != 0) {
                        fqName.append(packageName);
                        fqName.append('.');
                    }
                    char[][] cArray = enclosingTypeNames;
                    int n = enclosingTypeNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] enclosingType = cArray[n2];
                        fqName.append(enclosingType);
                        fqName.append('$');
                        ++n2;
                    }
                    fqName.append(simpleTypeName);
                    String fqNameAsString = fqName.toString();
                    JdtTypesProposalProvider.this.createTypeProposal(fqNameAsString, modifiers, enclosingTypeNames.length > 0, proposalFactory, myContext, this.val$scopeAware, this.val$jvmTypeProvider, (IValueConverter<String>)this.val$valueConverter);
                }
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor(){

            public boolean isCanceled() {
                return !acceptor.canAcceptMoreProposals();
            }
        });
        if (acceptor.canAcceptMoreProposals()) {
            Iterable allDirtyTypes = this.dirtyStateManager.getExportedObjectsByType(TypesPackage.Literals.JVM_TYPE);
            for (IEObjectDescription description : allDirtyTypes) {
                QualifiedName qualifiedName = description.getQualifiedName();
                if (!filter.accept(1, qualifiedName.skipLast(1).toString().toCharArray(), qualifiedName.getLastSegment().toCharArray(), new char[0][0], description.getEObjectURI().toPlatformString(true))) continue;
                String fqName = description.getQualifiedName().toString();
                this.createTypeProposal(fqName, 1, false, proposalFactory, myContext, (ICompletionProposalAcceptor)scopeAware, jvmTypeProvider, valueConverter);
            }
        }
    }

    protected ConfigurableCompletionProposal.IReplacementTextApplier createTextApplier(ContentAssistContext context, IScope typeScope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter) {
        return new FQNShortener((Resource)context.getResource(), typeScope, qualifiedNameConverter, valueConverter);
    }

    @Override
    public void createTypeProposals(ICompletionProposalFactory proposalFactory, ContentAssistContext context, EReference typeReference, ITypesProposalProvider.Filter filter, IValueConverter<String> valueConverter, ICompletionProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        this.createTypeProposals(javaProject, proposalFactory, context, typeReference, filter, valueConverter, acceptor);
    }

    public void createTypeProposals(IJavaProject project, ICompletionProposalFactory proposalFactory, ContentAssistContext context, EReference typeReference, ITypesProposalProvider.Filter filter, IValueConverter<String> valueConverter, ICompletionProposalAcceptor acceptor) {
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
            this.searchAndCreateProposals(searchScope, proposalFactory, context, typeReference, filter, valueConverter, acceptor);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void createTypeProposal(final String typeName, int modifiers, boolean isInnerType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ICompletionProposalAcceptor acceptor, final IJvmTypeProvider jvmTypeProvider, IValueConverter<String> valueConverter) {
        if (acceptor.canAcceptMoreProposals()) {
            ICompletionProposal proposal;
            int lastDot = typeName.lastIndexOf(46);
            StyledString displayString = new StyledString(typeName);
            if (lastDot != -1) {
                displayString = new StyledString(typeName.substring(lastDot + 1)).append(" - " + typeName.substring(0, lastDot), StyledString.QUALIFIER_STYLER);
            }
            Image img = this.computeImage(typeName, isInnerType, modifiers);
            String proposalAsString = typeName;
            if (valueConverter != null) {
                try {
                    proposalAsString = valueConverter.toString((Object)proposalAsString);
                }
                catch (ValueConverterException vce) {
                    return;
                }
            }
            if ((proposal = proposalFactory.createCompletionProposal(proposalAsString, displayString, img, context)) instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal theProposal = (ConfigurableCompletionProposal)proposal;
                theProposal.setAdditionalProposalInfo((Object)new Provider<EObject>(){

                    public EObject get() {
                        return jvmTypeProvider.findTypeByName(typeName);
                    }
                });
                theProposal.setHover(this.hover);
                theProposal.setPriority(this.priorities.getDefaultPriority() + this.jdtTypeRelevance.getRelevance(typeName, context.getPrefix()));
            }
            acceptor.accept(proposal);
        }
    }

    protected Image computeImage(String typeName, boolean isInnerType, int modifiers) {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaElementImageProvider.getTypeImageDescriptor((boolean)isInnerType, (Flags.isAnnotation((int)modifiers) || Flags.isInterface((int)modifiers) ? 1 : 0) != 0, (int)modifiers, (boolean)false));
    }

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    public SuperTypeCollector getSuperTypeCollector() {
        return this.superTypeCollector;
    }

    public void setProjectProvider(IJavaProjectProvider projectProvider) {
        this.projectProvider = projectProvider;
    }

    public IJavaProjectProvider getProjectProvider() {
        return this.projectProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FQNShortener
    extends ReplacementTextApplier {
        protected final IScope scope;
        protected final Resource context;
        protected final IQualifiedNameConverter qualifiedNameConverter;
        protected final IValueConverter<String> valueConverter;

        public FQNShortener(Resource context, IScope scope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter) {
            this.context = context;
            this.scope = scope;
            this.qualifiedNameConverter = qualifiedNameConverter;
            this.valueConverter = valueConverter;
        }

        protected String applyValueConverter(QualifiedName qualifiedName) {
            String result = this.qualifiedNameConverter.toString(qualifiedName);
            if (this.valueConverter != null) {
                result = this.valueConverter.toString((Object)result);
            }
            return result;
        }

        public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
            String replacementString = proposal.getReplacementString();
            if (this.scope != null) {
                IEObjectDescription shortendElement;
                EObject resolved;
                IEObjectDescription element;
                String qualifiedNameAsString = replacementString;
                if (this.valueConverter != null) {
                    qualifiedNameAsString = (String)this.valueConverter.toValue(qualifiedNameAsString, null);
                }
                if ((element = this.scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName(qualifiedNameAsString))) != null && !(resolved = EcoreUtil.resolve((EObject)element.getEObjectOrProxy(), (Resource)this.context)).eIsProxy() && (shortendElement = this.scope.getSingleElement(resolved)) != null) {
                    replacementString = this.applyValueConverter(shortendElement.getName());
                }
            }
            return replacementString;
        }
    }
}

