/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;

public abstract class ConnectorImpl
implements Connector {
    private VirtualMachineManagerImpl fVirtualMachineManager;
    protected Transport fTransport;
    protected VirtualMachineImpl fVirtualMachine;

    public ConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        this.fVirtualMachineManager = virtualMachineManager;
    }

    public VirtualMachineManagerImpl virtualMachineManager() {
        return this.fVirtualMachineManager;
    }

    public VirtualMachineImpl virtualMachine() {
        return this.fVirtualMachine;
    }

    @Override
    public abstract String description();

    @Override
    public abstract String name();

    void setTransport(Transport transport) {
        this.fTransport = transport;
    }

    @Override
    public Transport transport() {
        return this.fTransport;
    }

    synchronized void close() {
        this.virtualMachineManager().removeConnectedVM(this.fVirtualMachine);
    }

    protected VirtualMachine establishedConnection(Connection connection) throws IOException {
        this.fVirtualMachine = (VirtualMachineImpl)Bootstrap.virtualMachineManager().createVirtualMachine(connection);
        return this.fVirtualMachine;
    }

    public abstract class ArgumentImpl
    implements Connector.Argument {
        private static final long serialVersionUID = 8850533280769854833L;
        private String fName;
        private String fDescription;
        private String fLabel;
        private boolean fMustSpecify;

        protected ArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            this.fName = name;
            this.fLabel = label;
            this.fDescription = description;
            this.fMustSpecify = mustSpecify;
        }

        @Override
        public String name() {
            return this.fName;
        }

        @Override
        public String description() {
            return this.fDescription;
        }

        @Override
        public String label() {
            return this.fLabel;
        }

        @Override
        public boolean mustSpecify() {
            return this.fMustSpecify;
        }

        @Override
        public abstract String value();

        @Override
        public abstract void setValue(String var1);

        @Override
        public abstract boolean isValid(String var1);

        public abstract String toString();
    }

    public class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        private static final long serialVersionUID = 6009335074727417445L;
        private Boolean fValue;

        protected BooleanArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super(name, description, label, mustSpecify);
        }

        @Override
        public String value() {
            return this.fValue == null ? null : this.fValue.toString();
        }

        @Override
        public void setValue(String value) {
            this.fValue = Boolean.valueOf(value);
        }

        @Override
        public boolean isValid(String value) {
            return true;
        }

        @Override
        public String toString() {
            return this.value();
        }

        @Override
        public boolean booleanValue() {
            return this.fValue;
        }

        @Override
        public void setValue(boolean value) {
            this.fValue = value;
        }

        @Override
        public String stringValueOf(boolean value) {
            return Boolean.valueOf(value).toString();
        }
    }

    public class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private static final long serialVersionUID = 6009335074727417445L;
        private Integer fValue;
        private int fMin;
        private int fMax;

        protected IntegerArgumentImpl(String name, String description, String label, boolean mustSpecify, int min, int max) {
            super(name, description, label, mustSpecify);
            this.fMin = min;
            this.fMax = max;
        }

        @Override
        public String value() {
            return this.fValue == null ? null : this.fValue.toString();
        }

        @Override
        public void setValue(String value) {
            this.fValue = new Integer(value);
        }

        @Override
        public boolean isValid(String value) {
            Integer val;
            try {
                val = new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return this.isValid(val);
        }

        @Override
        public String toString() {
            return this.value();
        }

        @Override
        public int intValue() {
            return this.fValue;
        }

        @Override
        public void setValue(int value) {
            this.fValue = new Integer(value);
        }

        @Override
        public int min() {
            return this.fMin;
        }

        @Override
        public int max() {
            return this.fMax;
        }

        @Override
        public boolean isValid(int value) {
            return this.fMin <= value && value <= this.fMax;
        }

        @Override
        public String stringValueOf(int value) {
            return new Integer(value).toString();
        }
    }

    public class SelectedArgumentImpl
    extends StringArgumentImpl
    implements Connector.SelectedArgument {
        private static final long serialVersionUID = 6009335074727417445L;
        private List<String> fChoices;

        protected SelectedArgumentImpl(String name, String description, String label, boolean mustSpecify, List<String> choices) {
            super(name, description, label, mustSpecify);
            this.fChoices = choices;
        }

        @Override
        public List<String> choices() {
            return this.fChoices;
        }

        @Override
        public boolean isValid(String value) {
            return this.fChoices.contains(value);
        }
    }

    public class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        private static final long serialVersionUID = 6009335074727417445L;
        private String fValue;

        protected StringArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super(name, description, label, mustSpecify);
        }

        @Override
        public String value() {
            return this.fValue;
        }

        @Override
        public void setValue(String value) {
            this.fValue = value;
        }

        @Override
        public boolean isValid(String value) {
            return true;
        }

        @Override
        public String toString() {
            return this.fValue;
        }
    }
}

