/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.loggers;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.SimulationLoggerPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.SimulationLoggerPropertyStringProviderAdapterFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.ui.loggers";
    public static final String LOGGER_EXTENSION_POINT = "org.eclipse.stem.loggers";
    private static Activator plugin;
    public static final String CLASS_FIELD = "class";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        new SimulationLoggerPropertyEditorAdapterFactory();
        new SimulationLoggerPropertyStringProviderAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static DublinCore getPluginDublinCore(Logger logger) {
        String loggerClass = logger.getClass().getName();
        DublinCore dc = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint[] extensionPoints = registry.getExtensionPoints("org.eclipse.stem.core");
        int k = 0;
        while (k < extensionPoints.length) {
            IExtensionPoint extensionPoint = extensionPoints[k];
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String[] keys = element.getAttributeNames();
                    int m = 0;
                    while (m < keys.length) {
                        EStructuralFeature feature;
                        String value = element.getAttribute(keys[m]);
                        if (keys[m].equalsIgnoreCase(CLASS_FIELD) && value.equalsIgnoreCase(loggerClass)) {
                            dc = logger.getDublinCore();
                        } else if (dc != null && (feature = dc.getFeature(keys[m])) != null && value != null) {
                            dc.eSet(feature, (Object)value);
                        }
                        ++m;
                    }
                    ++j;
                }
                if (dc != null) {
                    return dc;
                }
                ++i;
            }
            ++k;
        }
        return null;
    }

    public static void logError(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.err.println(message);
            if (exception != null) {
                System.err.println(exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void logInformation(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static void logInformation(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, null));
        } else {
            System.out.println(message);
        }
    }
}

