/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.wizards.DiseaseDefinitionControl;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewDiseaseWizard
extends NewIdentifiableWizard {
    private NewDiseasePage ndp = null;

    protected String getWizardTitle() {
        return DiseaseWizardMessages.getString("NDiseaseWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.ndp = new NewDiseasePage(DiseaseWizardMessages.getString("NDiseaseWiz.page_title"), this);
        this.ndp.setTitle(DiseaseWizardMessages.getString("NDiseaseWiz.page_title"));
        this.ndp.setDescription(DiseaseWizardMessages.getString("NDiseaseWiz.page_description"));
        this.setHelpContextId("org.eclipse.stem.doc.newdisease_contextid");
        return this.ndp;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/diseasemodels/standard.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.createTypeURI((String)"diseasemodel").toString());
                this.type.setEnabled(false);
                DiseaseModel diseaseModel = NewDiseaseWizard.this.ndp.getSelectedDiseaseModel();
                DublinCore plugginDublinCore = diseaseModel.getDublinCore();
                this.updateDublinCorePage(plugginDublinCore);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        DiseaseModel retValue = this.ndp.getSelectedDiseaseModel();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    protected String getSerializationFolderName() {
        return "decorators";
    }

    protected String getSerializationFileNameExtension() {
        return "standard";
    }

    protected static class NewDiseasePage
    extends NewIdentifiablePage {
        DiseaseDefinitionControl ddc = null;
        NewDiseaseWizard parentWizard = null;

        protected NewDiseasePage(String pageName, NewDiseaseWizard newDiseaseWizard) {
            super(pageName);
            this.parentWizard = newDiseaseWizard;
        }

        protected Composite createSpecificComposite(Composite parent) {
            this.ddc = new DiseaseDefinitionControl(parent, 0, this.projectValidator, this.getSelectedProject(), this.parentWizard);
            return this.ddc;
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.ddc.validate();
                if (!retValue) {
                    this.setErrorMessage(this.ddc.getErrorMessage());
                }
            }
            return retValue;
        }

        DiseaseModel getSelectedDiseaseModel() {
            return this.ddc.getSelectedDiseaseModel();
        }
    }

    public static class NewDiseaseWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewDiseaseWizard wizard = new NewDiseaseWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

