/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.provider.PhysicalRelationshipLabelItemProvider;
import org.eclipse.stem.geography.names.GeographicNames;

public class RoadTransportRelationshipLabelItemProvider
extends PhysicalRelationshipLabelItemProvider {
    public RoadTransportRelationshipLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/custom16/road.png"));
    }

    @Override
    public String getText(Object object) {
        Edge edge = ((EdgeLabel)object).getEdge();
        String firstISOKey = edge.getNodeAURI().lastSegment();
        String secondISOKey = edge.getNodeBURI().lastSegment();
        String firstGeoName = GeographicNames.getName((String)firstISOKey);
        String secondGeoName = GeographicNames.getName((String)secondISOKey);
        StringBuilder sb = new StringBuilder(firstGeoName.startsWith("!") ? firstISOKey : firstGeoName);
        sb.append(edge.isDirected() ? " -> " : " <-> ");
        sb.append(secondGeoName.startsWith("!") ? secondISOKey : secondGeoName);
        return sb.toString();
    }

    @Override
    public String getTextGen(Object object) {
        URI labelValue = ((RoadTransportRelationshipLabel)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_RoadTransportRelationshipLabel_type") : String.valueOf(this.getString("_UI_RoadTransportRelationshipLabel_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

