/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Beta
public abstract class TemplateProcessor
extends AbstractClassProcessor {
    private static final Object LOCK = TemplateProcessor.class;
    private Map<Path, String> propertyContentMap;
    private String actualPropertyContents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateCode(List<? extends ClassDeclaration> annotatedSourceElements, @Extension CodeGenerationContext context) {
        Object object = LOCK;
        synchronized (object) {
            this.buildFileMaps(annotatedSourceElements, context);
            for (ClassDeclaration classDeclaration : annotatedSourceElements) {
                this.actualPropertyContents = this.propertyContentMap.get(this.getMessagesProperties(classDeclaration));
                this.doGenerateCode(classDeclaration, context);
            }
            this.saveFileMaps(annotatedSourceElements, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateCode(ClassDeclaration annotatedClass, @Extension CodeGenerationContext context) {
        Object object = LOCK;
        synchronized (object) {
            String propertyContents = this.generatePropertiesFile(annotatedClass, context);
            this.generateMessagesClass(propertyContents, annotatedClass, context);
        }
    }

    private String generatePropertiesFile(ClassDeclaration annotatedClass, @Extension CodeGenerationContext context) {
        String label = this.replaceNewlines(this.getLabel(annotatedClass, context));
        String description = this.replaceNewlines(this.getDescription(annotatedClass, context));
        String _simpleName = annotatedClass.getSimpleName();
        String labelLineStart = String.valueOf(_simpleName) + "_Label=";
        String labelLine = String.valueOf(labelLineStart) + label;
        boolean _contains = this.actualPropertyContents.contains(labelLineStart);
        if (_contains) {
            this.actualPropertyContents = this.actualPropertyContents.replaceFirst("(?m)^" + labelLineStart + ".*$", labelLine);
        } else {
            String _actualPropertyContents = this.actualPropertyContents;
            String _lineSeparator = System.lineSeparator();
            String _plus = String.valueOf(labelLine) + _lineSeparator;
            this.actualPropertyContents = String.valueOf(_actualPropertyContents) + _plus;
        }
        String _simpleName_1 = annotatedClass.getSimpleName();
        String descriptionLineStart = String.valueOf(_simpleName_1) + "_Description=";
        String descriptionLine = String.valueOf(descriptionLineStart) + description;
        boolean _contains_1 = this.actualPropertyContents.contains(descriptionLineStart);
        if (_contains_1) {
            this.actualPropertyContents = this.actualPropertyContents.replaceFirst("(?m)^" + descriptionLineStart + ".*$", descriptionLine);
        } else {
            String _actualPropertyContents_1 = this.actualPropertyContents;
            String _lineSeparator_1 = System.lineSeparator();
            String _plus_1 = String.valueOf(descriptionLine) + _lineSeparator_1;
            this.actualPropertyContents = String.valueOf(_actualPropertyContents_1) + _plus_1;
        }
        this.propertyContentMap.put(this.getMessagesProperties(annotatedClass), this.actualPropertyContents);
        return this.actualPropertyContents;
    }

    private void generateMessagesClass(String propertyContents, ClassDeclaration annotatedClass, @Extension CodeGenerationContext context) {
        String[] _split;
        Path classFile = annotatedClass.getCompilationUnit().getFilePath().getParent().append("Messages.java");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _packageName = annotatedClass.getCompilationUnit().getPackageName();
        _builder.append(_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.eclipse.osgi.util.NLS;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public class Messages extends NLS {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String BUNDLE_NAME = \"");
        String _packageName_1 = annotatedClass.getCompilationUnit().getPackageName();
        _builder.append(_packageName_1, "\t");
        _builder.append(".messages\"; //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        String contents = _builder.toString();
        String[] stringArray = _split = propertyContents.split("(\r?\n)+");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            boolean _contains = line.contains("=");
            if (_contains) {
                String[] parts = line.split("=");
                String _contents = contents;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("\t");
                _builder_1.append("public static String ");
                String _trim = parts[0].trim();
                _builder_1.append(_trim, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                contents = String.valueOf(_contents) + _builder_1;
            }
            ++n2;
        }
        String _contents_1 = contents;
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("\t");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("static {");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("// initialize resource bundle");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("NLS.initializeMessages(BUNDLE_NAME, Messages.class);");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("}");
        _builder_2.newLine();
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("private Messages() {");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("}");
        _builder_2.newLine();
        _builder_2.append("}");
        _builder_2.newLine();
        contents = String.valueOf(_contents_1) + _builder_2;
        context.setContents(classFile, (CharSequence)contents);
    }

    private String replaceNewlines(String input) {
        return input.replaceAll("(\r?\n)+", " ");
    }

    protected void buildFileMaps(List<? extends ClassDeclaration> annotatedSourceElements, @Extension CodeGenerationContext context) {
        HashMap<Path, String> _hashMap = new HashMap<Path, String>();
        this.propertyContentMap = _hashMap;
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            boolean _not;
            Path propertyFile = this.getMessagesProperties(classDeclaration);
            boolean _containsKey = this.propertyContentMap.containsKey(propertyFile);
            boolean bl = _not = !_containsKey;
            if (!_not) continue;
            boolean _exists = context.exists(propertyFile);
            if (_exists) {
                String propertyContents = context.getContents(propertyFile).toString();
                if (propertyContents.length() > 0 && !propertyContents.endsWith(System.lineSeparator())) {
                    String _propertyContents = propertyContents;
                    String _lineSeparator = System.lineSeparator();
                    propertyContents = String.valueOf(_propertyContents) + _lineSeparator;
                }
                this.propertyContentMap.put(propertyFile, propertyContents);
                continue;
            }
            this.propertyContentMap.put(propertyFile, "");
        }
    }

    protected void saveFileMaps(List<? extends ClassDeclaration> annotatedSourceElements, @Extension CodeGenerationContext context) {
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            this.actualPropertyContents = this.propertyContentMap.get(this.getMessagesProperties(classDeclaration));
            Path _messagesProperties = this.getMessagesProperties(classDeclaration);
            context.setContents(_messagesProperties, (CharSequence)this.actualPropertyContents);
        }
    }

    private Path getMessagesProperties(ClassDeclaration annotatedClass) {
        return annotatedClass.getCompilationUnit().getFilePath().getParent().append("messages.properties");
    }

    protected abstract String getLabel(ClassDeclaration var1, @Extension CodeGenerationContext var2);

    protected abstract String getDescription(ClassDeclaration var1, @Extension CodeGenerationContext var2);
}

