/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.actions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.compare.scope.ModelComparisonScope;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelCompareEditor;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelComparisonScopeEditorInput;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicCompareAction
extends BaseSelectionListenerAction
implements ISelectionChangedListener {
    protected List<WeakReference<EObject>> selectedEObjects = null;
    protected List<WeakReference<IFile>> selectedFiles = null;

    public BasicCompareAction() {
        super(Messages.action_compareWithEachOther);
        this.setDescription(Messages.action_compareWithEachOther_description);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        if (selection.size() != 2) {
            return false;
        }
        this.selectedFiles = null;
        this.selectedEObjects = null;
        for (Object object : selection) {
            if (object instanceof EObject) {
                if (this.selectedEObjects == null) {
                    this.selectedEObjects = new ArrayList<WeakReference<EObject>>();
                }
                this.selectedEObjects.add(new WeakReference<EObject>((EObject)object));
                continue;
            }
            if (!(object instanceof IFile)) continue;
            if (this.selectedFiles == null) {
                this.selectedFiles = new ArrayList<WeakReference<IFile>>();
            }
            this.selectedFiles.add(new WeakReference<IFile>((IFile)object));
        }
        return this.selectedFiles != null ? this.selectedFiles.size() == 2 : (this.selectedEObjects != null ? this.selectedEObjects.size() == 2 : false);
    }

    public boolean isEnabled() {
        if (this.selectedFiles != null && this.selectedFiles.size() == 2) {
            IFile leftFile = (IFile)this.selectedFiles.get(0).get();
            IFile rightFile = (IFile)this.selectedFiles.get(1).get();
            return ModelDescriptorRegistry.INSTANCE.isModelFile(leftFile) && ModelDescriptorRegistry.INSTANCE.isModelFile(rightFile);
        }
        return super.isEnabled();
    }

    public void run() {
        Object leftObject = null;
        Object rightObject = null;
        if (this.selectedEObjects != null && this.selectedEObjects.size() == 2) {
            leftObject = this.selectedEObjects.get(0).get();
            rightObject = this.selectedEObjects.get(1).get();
        } else if (this.selectedFiles != null && this.selectedFiles.size() == 2) {
            leftObject = this.selectedFiles.get(0).get();
            rightObject = this.selectedFiles.get(1).get();
        }
        if (leftObject == null || rightObject == null) {
            return;
        }
        CompareEditorInput input = this.getCompareEditorInput(leftObject, rightObject);
        IWorkbenchPage page = ExtendedPlatformUI.getActivePage();
        IReusableEditor editor = this.getReusableEditor();
        this.openCompareEditor(input, page, editor);
    }

    protected AdapterFactory getAdapterFactory() {
        return new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    protected IMatchEngine.Factory.Registry getMatchEngineFactoryRegistry() {
        return EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry();
    }

    protected IPostProcessor.Descriptor.Registry<?> getPostProcessorRegistry() {
        return EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry();
    }

    protected CompareEditorInput getCompareEditorInput(Object leftObject, Object rightObject) {
        IPreferenceStore prefStore;
        Assert.isTrue((leftObject instanceof Notifier || leftObject instanceof IFile ? 1 : 0) != 0);
        Assert.isTrue((rightObject instanceof Notifier || rightObject instanceof IFile ? 1 : 0) != 0);
        CompareEditorInput input = this.createCompareEditorInput(this.getAdapterFactory(), leftObject, rightObject, null);
        CompareConfiguration configuration = input.getCompareConfiguration();
        if (configuration != null && (prefStore = configuration.getPreferenceStore()) != null) {
            configuration.setProperty("USE_OUTLINE_VIEW", (Object)prefStore.getBoolean("org.eclipse.compare.UseOutlineView"));
        }
        return input;
    }

    protected CompareEditorInput createCompareEditorInput(AdapterFactory adapterFactory, Object left, Object right, Notifier origin) {
        return this.createCompareEditorInput(adapterFactory, left, right, origin, null);
    }

    protected CompareEditorInput createCompareEditorInput(AdapterFactory adapterFactory, Object left, Object right, Notifier origin, IEclipsePreferences enginePreferences) {
        EMFCompare.Builder builder = EMFCompare.builder().setPostProcessorRegistry(this.getPostProcessorRegistry());
        builder.setMatchEngineFactoryRegistry(this.getMatchEngineFactoryRegistry());
        EMFCompare comparator = builder.build();
        ICompareEditingDomain editingDomain = ModelCompareUtil.createEMFCompareEditingDomain((Object)left, (Object)right, (Notifier)origin);
        EMFCompareConfiguration configuration = this.getEMFCompareConfiguration();
        IComparisonScope scope = this.getComparisonScope(left, right, origin);
        ModelComparisonScopeEditorInput input = new ModelComparisonScopeEditorInput(configuration, editingDomain, adapterFactory, comparator, scope);
        configuration.setContainer((ICompareContainer)input);
        return input;
    }

    protected EMFCompareConfiguration getEMFCompareConfiguration() {
        return new EMFCompareConfiguration(new CompareConfiguration());
    }

    protected IComparisonScope getComparisonScope(Object left, Object right, Object origin) {
        if (left instanceof Notifier && right instanceof Notifier) {
            return new ModelComparisonScope((Notifier)left, (Notifier)right, origin instanceof Notifier ? (Notifier)origin : null);
        }
        if (left instanceof IFile && right instanceof IFile) {
            return new ModelComparisonScope((IFile)left, (IFile)right);
        }
        return null;
    }

    protected IReusableEditor getReusableEditor() {
        return null;
    }

    protected void openCompareEditor(final CompareEditorInput input, final IWorkbenchPage page, final IReusableEditor editor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (editor != null && !editor.getSite().getShell().isDisposed()) {
                    editor.setInput((IEditorInput)input);
                    return;
                }
                if (page != null) {
                    try {
                        page.openEditor((IEditorInput)input, BasicCompareAction.this.getCompareEditorId(input));
                    }
                    catch (PartInitException e) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)e));
                        MessageDialog.openError((Shell)ExtendedPlatformUI.getActiveShell(), (String)Messages.error_openEditorError, (String)e.getMessage());
                    }
                } else {
                    String msg = Messages.error_noActiveWorkbenchPage;
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new NullPointerException(msg));
                    MessageDialog.openError((Shell)ExtendedPlatformUI.getActiveShell(), (String)Messages.error_openEditorError, (String)msg);
                }
            }
        };
        Display display = ExtendedPlatformUI.getDisplay();
        if (display != null) {
            display.syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected String getCompareEditorId(CompareEditorInput input) {
        return ModelCompareEditor.ID;
    }
}

