/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicExplorerContentProvider
implements ICommonContentProvider,
IViewerProvider {
    protected static final int LIMIT_INDIVIDUAL_RESOURCES_REFRESH = 20;
    protected static final int LIMIT_INDIVIDUAL_OBJECTS_REFRESH = 100;
    protected Viewer viewer;
    protected INavigatorContentDescriptor contentDescriptor;
    protected Map<TransactionalEditingDomain, AdapterFactoryContentProvider> modelContentProviders = new WeakHashMap<TransactionalEditingDomain, AdapterFactoryContentProvider>();
    protected ResourceSetListener resourceChangedListener;
    protected ResourceSetListener resourceMovedListener;
    protected ResourceSetListener nonContainmentReferenceChangeListener;
    protected ResourceSetListener modelContentRootChangeListener;

    public Viewer getViewer() {
        return this.viewer;
    }

    public void init(ICommonContentExtensionSite config) {
        this.contentDescriptor = config.getExtension().getDescriptor();
    }

    protected boolean isTriggerPoint(IResource resource) {
        return this.contentDescriptor.isTriggerPoint((Object)resource);
    }

    protected boolean isPossibleChild(Object object) {
        return this.contentDescriptor.isPossibleChild(object);
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    @Deprecated
    protected EObject getModelRoot(TransactionalEditingDomain editingDomain, IFile file) {
        Object modelRoot = this.getModelRoot((IResource)file);
        return modelRoot instanceof EObject ? (EObject)modelRoot : null;
    }

    protected Object getModelRoot(IResource resource) {
        IModelDescriptor modelDescriptor;
        if (resource instanceof IFile && (modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((IFile)resource)) != null) {
            EObject modelRoot = EcorePlatformUtil.getModelRoot((TransactionalEditingDomain)modelDescriptor.getEditingDomain(), (IFile)((IFile)resource));
            if (modelRoot == null) {
                this.addTransactionalEditingDomainListeners(modelDescriptor.getEditingDomain());
                ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
            }
            return modelRoot;
        }
        return null;
    }

    protected Object getModelContentRoot(Object object) {
        if (object instanceof EObject) {
            return this.getModelContentRoot((EObject)object);
        }
        if (object instanceof IWrapperItemProvider) {
            return this.getModelContentRoot((IWrapperItemProvider)object);
        }
        if (object instanceof FeatureMap.Entry) {
            return this.getModelContentRoot((FeatureMap.Entry)object);
        }
        if (object instanceof TransientItemProvider) {
            return this.getModelContentRoot((TransientItemProvider)object);
        }
        return null;
    }

    protected Object getModelContentRoot(EObject object) {
        Assert.isNotNull((Object)object);
        Object mappedModelRoot = this.getMappedModelRoot(object);
        if (mappedModelRoot != null) {
            return mappedModelRoot;
        }
        return object.eResource();
    }

    @Deprecated
    protected Object getMappedModelRoot(EObject object) {
        return null;
    }

    protected Object getModelContentRoot(IWrapperItemProvider wrapperItemProvider) {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)wrapperItemProvider);
        return this.getModelContentRoot(unwrapped);
    }

    protected Object getModelContentRoot(FeatureMap.Entry entry) {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)entry);
        return this.getModelContentRoot(unwrapped);
    }

    protected Object getModelContentRoot(TransientItemProvider transientItemProvider) {
        Notifier target = transientItemProvider.getTarget();
        return this.getModelContentRoot(target);
    }

    protected IResource getUnderlyingWorkspaceResource(Object modelContentRoot) {
        return EcorePlatformUtil.getFile((Object)modelContentRoot);
    }

    protected AdapterFactoryContentProvider getModelContentProvider(Object element) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)element);
        if (editingDomain != null) {
            AdapterFactoryContentProvider modelContentProvider = this.modelContentProviders.get(editingDomain);
            if (modelContentProvider == null) {
                modelContentProvider = this.createModelContentProvider(editingDomain);
                this.modelContentProviders.put(editingDomain, modelContentProvider);
                this.addTransactionalEditingDomainListeners(editingDomain);
            }
            return modelContentProvider;
        }
        return null;
    }

    protected AdapterFactoryContentProvider createModelContentProvider(final TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new TransactionalAdapterFactoryContentProvider(editingDomain, adapterFactory){

            protected <T> T run(RunnableWithResult<? extends T> run) {
                try {
                    return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, run);
                }
                catch (Exception e) {
                    Tracing.catching(TransactionalAdapterFactoryLabelProvider.class, (String)"run", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        try {
            if (parentElement instanceof IResource) {
                Object modelContentRoot;
                AdapterFactoryContentProvider contentProvider;
                Object modelRoot = this.getModelRoot((IResource)parentElement);
                if (modelRoot != null && (contentProvider = this.getModelContentProvider(modelContentRoot = this.getModelContentRoot(modelRoot))) != null) {
                    contentProvider.inputChanged(this.viewer, null, modelContentRoot);
                    children = contentProvider.getChildren(modelContentRoot);
                }
            } else {
                AdapterFactoryContentProvider contentProvider = this.getModelContentProvider(parentElement);
                if (contentProvider != null) {
                    children = contentProvider.getChildren(parentElement);
                }
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
        return children != null ? children : new Object[]{};
    }

    public Object getParent(Object element) {
        Object modelContentRoot;
        Object parent = null;
        AdapterFactoryContentProvider contentProvider = this.getModelContentProvider(element);
        if (contentProvider != null) {
            parent = contentProvider.getParent(element);
        }
        if (parent == (modelContentRoot = this.getModelContentRoot(element))) {
            parent = this.getUnderlyingWorkspaceResource(modelContentRoot);
        }
        return parent;
    }

    public void dispose() {
        for (TransactionalEditingDomain editingDomain : this.modelContentProviders.keySet()) {
            this.removeTransactionalEditingDomainListeners(editingDomain);
            AdapterFactoryContentProvider modelContentProvider = this.modelContentProviders.get(editingDomain);
            modelContentProvider.dispose();
        }
        this.modelContentProviders.clear();
    }

    protected void addTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        if (this.resourceChangedListener == null) {
            this.resourceChangedListener = this.createResourceChangedListener();
            Assert.isNotNull((Object)this.resourceChangedListener);
        }
        editingDomain.addResourceSetListener(this.resourceChangedListener);
        if (this.resourceMovedListener == null) {
            this.resourceMovedListener = this.createResourceMovedListener();
            Assert.isNotNull((Object)this.resourceMovedListener);
        }
        editingDomain.addResourceSetListener(this.resourceMovedListener);
        if (this.nonContainmentReferenceChangeListener == null) {
            this.nonContainmentReferenceChangeListener = this.createNonContainmentReferenceChangeListener();
            Assert.isNotNull((Object)this.nonContainmentReferenceChangeListener);
        }
        editingDomain.addResourceSetListener(this.nonContainmentReferenceChangeListener);
        if (this.modelContentRootChangeListener == null) {
            this.modelContentRootChangeListener = this.createModelContentRootChangeListener();
            Assert.isNotNull((Object)this.modelContentRootChangeListener);
        }
        editingDomain.addResourceSetListener(this.modelContentRootChangeListener);
    }

    protected void removeTransactionalEditingDomainListeners(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        if (this.resourceChangedListener != null) {
            editingDomain.removeResourceSetListener(this.resourceChangedListener);
        }
        if (this.resourceMovedListener != null) {
            editingDomain.removeResourceSetListener(this.resourceMovedListener);
        }
        if (this.nonContainmentReferenceChangeListener != null) {
            editingDomain.removeResourceSetListener(this.nonContainmentReferenceChangeListener);
        }
        if (this.modelContentRootChangeListener != null) {
            editingDomain.removeResourceSetListener(this.modelContentRootChangeListener);
        }
    }

    protected ResourceSetListener createResourceChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> loadedResources = new HashSet<Resource>();
                HashSet<Resource> unloadedResources = new HashSet<Resource>();
                HashSet<Resource> addedResources = new HashSet<Resource>();
                HashSet<Resource> removedResources = new HashSet<Resource>();
                HashSet<Resource> changedResources = new HashSet<Resource>();
                for (Notification notification : event.getNotifications()) {
                    Object newValue;
                    Object notifier = notification.getNotifier();
                    if (notifier instanceof Resource) {
                        Resource resource = (Resource)notifier;
                        newValue = (Boolean)notification.getNewValue();
                        if (((Boolean)newValue).booleanValue()) {
                            if (unloadedResources.contains(resource)) {
                                unloadedResources.remove(resource);
                                continue;
                            }
                            loadedResources.add(resource);
                            continue;
                        }
                        if (loadedResources.contains(resource)) {
                            loadedResources.remove(resource);
                            continue;
                        }
                        unloadedResources.add(resource);
                        continue;
                    }
                    if (!(notifier instanceof ResourceSet)) continue;
                    if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<Resource> newResources = new ArrayList<Resource>();
                        newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newResourcesValue = (List)newValue;
                            newResources.addAll(newResourcesValue);
                        } else if (newValue instanceof Resource) {
                            newResources.add((Resource)newValue);
                        }
                        for (Resource newResource : newResources) {
                            if (removedResources.contains(newResource)) {
                                removedResources.remove(newResource);
                                continue;
                            }
                            addedResources.add(newResource);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<Resource> oldResources = new ArrayList<Resource>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldResourcesValue = (List)oldValue;
                        oldResources.addAll(oldResourcesValue);
                    } else if (oldValue instanceof Resource) {
                        oldResources.add((Resource)oldValue);
                    }
                    for (Resource oldResource : oldResources) {
                        if (addedResources.contains(oldResource)) {
                            addedResources.remove(oldResource);
                            continue;
                        }
                        removedResources.add(oldResource);
                    }
                }
                changedResources.addAll(loadedResources);
                changedResources.addAll(addedResources);
                changedResources.addAll(unloadedResources);
                changedResources.addAll(removedResources);
                BasicExplorerContentProvider.this.refreshViewerOnModelResources(changedResources);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceMovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)1)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> movedResources = new HashSet<Resource>();
                for (Notification notification : event.getNotifications()) {
                    movedResources.add((Resource)notification.getNotifier());
                }
                BasicExplorerContentProvider.this.refreshViewerOnModelResources(movedResources);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createNonContainmentReferenceChangeListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createNotifierTypeFilter(EObject.class)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> objectsToRefresh = new HashSet<EObject>();
                for (Notification notification : event.getNotifications()) {
                    EReference reference;
                    EObject object = (EObject)notification.getNotifier();
                    if (!(notification.getFeature() instanceof EReference) || (reference = (EReference)notification.getFeature()).isContainment() || reference.isContainer() || !(reference.getEType() instanceof EClass)) continue;
                    objectsToRefresh.add(object);
                }
                BasicExplorerContentProvider.this.refreshViewerOnModelObjects(objectsToRefresh);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createModelContentRootChangeListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)2).or(NotificationFilter.createNotifierTypeFilter(EObject.class))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> addedValues = new HashSet<EObject>();
                HashSet<EObject> removedValues = new HashSet<EObject>();
                HashSet<EObject> changedValues = new HashSet<EObject>();
                for (Notification notification : event.getNotifications()) {
                    Object notifier = notification.getNotifier();
                    if (!(notifier instanceof Resource) && !(notification.getFeature() instanceof EReference)) continue;
                    if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<EObject> newValues = new ArrayList<EObject>();
                        Object newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newValueList = (List)newValue;
                            newValues.addAll(newValueList);
                        } else if (newValue instanceof EObject) {
                            newValues.add((EObject)newValue);
                        }
                        for (EObject value : newValues) {
                            if (removedValues.contains(value)) {
                                removedValues.remove(value);
                                continue;
                            }
                            addedValues.add(value);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<EObject> oldValues = new ArrayList<EObject>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldValueList = (List)oldValue;
                        oldValues.addAll(oldValueList);
                    } else if (oldValue instanceof Resource) {
                        oldValues.add((EObject)oldValue);
                    }
                    for (EObject value : oldValues) {
                        if (addedValues.contains(value)) {
                            addedValues.remove(value);
                            continue;
                        }
                        removedValues.add(value);
                    }
                }
                changedValues.addAll(addedValues);
                changedValues.addAll(removedValues);
                HashSet<IResource> resourcesToRefresh = new HashSet<IResource>();
                for (EObject changedObject : changedValues) {
                    Object changedObjectParent = BasicExplorerContentProvider.this.getParent(changedObject);
                    if (!(changedObjectParent instanceof IResource)) continue;
                    resourcesToRefresh.add((IResource)changedObjectParent);
                }
                BasicExplorerContentProvider.this.refreshViewerOnWorkspaceResources(resourcesToRefresh);
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected void refreshViewerOnWorkspaceResources(Set<? extends IResource> resources) {
        if (!resources.isEmpty()) {
            if (resources.size() < 20) {
                for (IResource iResource : resources) {
                    if (iResource == null || !iResource.isAccessible() || !this.isTriggerPoint(iResource)) continue;
                    this.refreshViewerOnObject(iResource);
                }
            } else {
                this.refreshViewer();
            }
        }
    }

    protected void refreshViewerOnModelResources(Set<? extends Resource> resources) {
        if (!resources.isEmpty()) {
            if (resources.size() < 20) {
                HashSet<IFile> files = new HashSet<IFile>();
                for (Resource resource : resources) {
                    IFile file = EcorePlatformUtil.getFile((Resource)resource);
                    if (file == null || !file.isAccessible() || !this.isTriggerPoint((IResource)file) && resource.isLoaded()) continue;
                    files.add(file);
                }
                for (IFile iFile : files) {
                    this.refreshViewerOnObject(iFile);
                }
            } else {
                this.refreshViewer();
            }
        }
    }

    protected void refreshViewerOnModelObjects(Set<?> objects) {
        if (!objects.isEmpty()) {
            if (objects.size() < 100) {
                for (Object object : objects) {
                    if (!this.isPossibleChild(object)) continue;
                    Object modelContentRoot = this.getModelContentRoot(object);
                    if (object == modelContentRoot) {
                        IResource resource = this.getUnderlyingWorkspaceResource(modelContentRoot);
                        if (resource == null || !resource.isAccessible() || !this.isTriggerPoint(resource)) continue;
                        this.refreshViewerOnObject(resource);
                        continue;
                    }
                    this.refreshViewerOnObject(object);
                }
            } else {
                this.refreshViewer();
            }
        }
    }

    protected void refreshViewerOnObject(final Object object) {
        if (object != null && this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (BasicExplorerContentProvider.this.viewer != null && BasicExplorerContentProvider.this.viewer.getControl() != null && !BasicExplorerContentProvider.this.viewer.getControl().isDisposed() && BasicExplorerContentProvider.this.viewer instanceof StructuredViewer) {
                        StructuredViewer stucturedViewer = (StructuredViewer)BasicExplorerContentProvider.this.viewer;
                        stucturedViewer.refresh(object, true);
                    }
                }
            });
        }
    }

    protected void refreshViewer() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (BasicExplorerContentProvider.this.viewer != null && BasicExplorerContentProvider.this.viewer.getControl() != null && !BasicExplorerContentProvider.this.viewer.getControl().isDisposed() && BasicExplorerContentProvider.this.viewer instanceof StructuredViewer) {
                        StructuredViewer stucturedViewer = (StructuredViewer)BasicExplorerContentProvider.this.viewer;
                        stucturedViewer.refresh();
                    }
                }
            });
        }
    }
}

