/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.listeners;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.emf.validation.Activator;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ResourceURIChangeListener
implements IResourceChangeListener {
    private static ArrayList<IResource> cache = new ArrayList();

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.updateCache(event);
                break;
            }
            case 16: {
                this.updateMarkers();
                this.cleanCache();
            }
        }
    }

    private void cleanCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    private void updateMarkers() {
        ValidationMarkerManager markermanager = ValidationMarkerManager.getInstance();
        for (IResource resource : cache) {
            try {
                markermanager.updateMarkersURI(resource);
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)((Object)ex));
            }
        }
    }

    private void updateCache(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResource resource = delta.getResource();
                if (delta.getKind() == 4) {
                    return true;
                }
                if ((delta.getFlags() & 0x20000) == 0) {
                    return true;
                }
                if (resource.getType() == 1 && resource.exists()) {
                    cache.add(resource);
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
        }
        catch (CoreException coreException) {}
    }
}

