/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.sphinx.jdt.internal.Activator;
import org.eclipse.sphinx.jdt.internal.messages.Messages;
import org.eclipse.sphinx.jdt.util.JavaExtensions;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class ConvertProjectToJavaProjectJob
extends WorkspaceJob {
    private static final String PROJECT_RELATIVE_JAVA_SOURCE_DEFAULT_PATH = "src";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_J2SE_1_5 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_6 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_7 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8";
    private static final String JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_8 = "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8";
    private Collection<IProject> projectsToConvert;
    private String projectRelativeJavaSourcePath = "src";
    private String compilerCompliance;

    public ConvertProjectToJavaProjectJob(IProject projectToConvert) {
        this(Collections.singletonList(projectToConvert));
    }

    public ConvertProjectToJavaProjectJob(Collection<IProject> projectsToConvert) {
        super(Messages.job_convertProjectToJavaProject);
        this.projectsToConvert = projectsToConvert;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.job_convertProjectToJavaProject, (int)this.projectsToConvert.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            for (IProject projectToConvert : this.projectsToConvert) {
                this.convertToJavaProject(projectToConvert, (IProgressMonitor)progress.newChild(1));
            }
        }
        catch (OperationCanceledException ex) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
        }
        return Status.OK_STATUS;
    }

    public String getProjectRelativeJavaSourcePath() {
        return this.projectRelativeJavaSourcePath;
    }

    public void setProjectRelativeJavaSourcePath(String projectRelativeJavaSourcePath) {
        this.projectRelativeJavaSourcePath = projectRelativeJavaSourcePath;
    }

    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    public void setCompilerCompliance(String compilerCompliance) {
        JavaExtensions.validateCompilerCompliance(compilerCompliance);
        this.compilerCompliance = compilerCompliance;
    }

    protected void convertToJavaProject(IProject projectToConvert, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry classpathEntry;
        IPath javaSourcePath;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.job_convertProjectToJavaProject, (int)3);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (projectToConvert == null || !projectToConvert.exists()) {
            return;
        }
        if (!projectToConvert.hasNature("org.eclipse.jdt.core.javanature")) {
            ExtendedPlatform.addNature((IProject)projectToConvert, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)progress.newChild(1));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        String projectRelativeJavaSourcePath = this.getProjectRelativeJavaSourcePath();
        if (projectRelativeJavaSourcePath != null && projectRelativeJavaSourcePath.length() > 0) {
            javaSourcePath = projectToConvert.getFullPath().append(projectRelativeJavaSourcePath);
            IPath projectRelativeJavaSourcePathObj = javaSourcePath.removeFirstSegments(1);
            IFolder javaSourceFolder = projectToConvert.getFolder(projectRelativeJavaSourcePathObj);
            if (!javaSourceFolder.exists()) {
                SubMonitor createSourceFolderProgress = progress.newChild(1).setWorkRemaining(javaSourcePath.segmentCount());
                int i = projectRelativeJavaSourcePathObj.segmentCount() - 1;
                while (i >= 0) {
                    IFolder folder = projectToConvert.getFolder(projectRelativeJavaSourcePathObj.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, (IProgressMonitor)createSourceFolderProgress.newChild(1));
                    } else {
                        createSourceFolderProgress.worked(1);
                    }
                    --i;
                }
            }
        } else {
            javaSourcePath = projectToConvert.getFullPath();
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IJavaProject javaProject = JavaCore.create((IProject)projectToConvert);
        String compilerCompliance = this.getCompilerCompliance();
        if (compilerCompliance != null && !JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance").equals(compilerCompliance)) {
            javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", compilerCompliance);
            javaProject.setOption("org.eclipse.jdt.core.compiler.source", compilerCompliance);
            javaProject.setOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compilerCompliance);
        } else if (compilerCompliance == null) {
            compilerCompliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        if (javaSourcePath.segmentCount() > 1) {
            IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSourcePath);
            Iterator iter = classpathEntries.iterator();
            while (iter.hasNext()) {
                classpathEntry = (IClasspathEntry)iter.next();
                if (!classpathEntry.getPath().isPrefixOf(javaSourcePath)) continue;
                iter.remove();
            }
            classpathEntries.add(0, sourceClasspathEntry);
        }
        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
        Iterator i = classpathEntries.iterator();
        while (i.hasNext()) {
            classpathEntry = (IClasspathEntry)i.next();
            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
            i.remove();
        }
        String jreContainer = JavaRuntime.JRE_CONTAINER;
        if ("1.5".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_J2SE_1_5;
        } else if ("1.6".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + JAVA_CLASSPATH_JRE_CONTAINER_ENTRY_SUFFIX_JAVA_SE_1_6;
        } else if ("1.7".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8";
        } else if ("1.8".equals(compilerCompliance)) {
            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8";
        }
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
        IClasspathEntry[] entries = new IClasspathEntry[classpathEntries.size()];
        int i2 = 0;
        Iterator iterator = classpathEntries.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry;
            entries[i2] = entry = (IClasspathEntry)iterator.next();
            ++i2;
        }
        javaProject.setRawClasspath(entries, (IProgressMonitor)progress.newChild(1));
    }
}

