/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.dto.ExtendedServletDTO;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextFilterTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextListenerTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextResourceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.customizer.ContextServletTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.IllegalContextNameException;
import org.eclipse.equinox.http.servlet.internal.error.IllegalContextPathException;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredFilterException;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ListenerRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.FilterConfigImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.servlet.ResourceServlet;
import org.eclipse.equinox.http.servlet.internal.servlet.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ServletContextAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.DTOUtil;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;
import org.eclipse.equinox.http.servlet.internal.util.Path;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.eclipse.equinox.http.servlet.internal.util.Throw;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContextController {
    private static final String[] DISPATCHER = new String[]{DispatcherType.REQUEST.toString()};
    private static final String SIMPLE_NAME = ContextController.class.getSimpleName();
    private static final Pattern contextNamePattern = Pattern.compile("^([a-zA-Z_0-9\\-]+\\.)*[a-zA-Z_0-9\\-]+$");
    private final Map<String, String> initParams;
    private final BundleContext trackingContext;
    private final BundleContext consumingContext;
    private final String contextName;
    private final String contextPath;
    private final long contextServiceId;
    private final Set<EndpointRegistration<?>> endpointRegistrations = new ConcurrentSkipListSet();
    private final EventListeners eventListeners = new EventListeners();
    private final Set<FilterRegistration> filterRegistrations = new ConcurrentSkipListSet<FilterRegistration>();
    private final ConcurrentMap<String, HttpSessionAdaptor> activeSessions = new ConcurrentHashMap<String, HttpSessionAdaptor>();
    private final HttpServiceRuntimeImpl httpServiceRuntime;
    private final Set<ListenerRegistration> listenerRegistrations = new HashSet<ListenerRegistration>();
    private final ProxyContext proxyContext;
    private final ServiceReference<ServletContextHelper> servletContextHelperRef;
    private final String servletContextHelperRefFilter;
    private boolean shutdown;
    private String string;
    private final ServiceTracker<javax.servlet.Filter, AtomicReference<FilterRegistration>> filterServiceTracker;
    private final ServiceTracker<EventListener, AtomicReference<ListenerRegistration>> listenerServiceTracker;
    private final ServiceTracker<Servlet, AtomicReference<ServletRegistration>> servletServiceTracker;
    private final ServiceTracker<Object, AtomicReference<ResourceRegistration>> resourceServiceTracker;

    public ContextController(BundleContext trackingContextParam, BundleContext consumingContext, ServiceReference<ServletContextHelper> servletContextHelperRef, ProxyContext proxyContext, HttpServiceRuntimeImpl httpServiceRuntime, String contextName, String contextPath) {
        this.validate(contextName, contextPath);
        this.servletContextHelperRef = servletContextHelperRef;
        long serviceId = (Long)servletContextHelperRef.getProperty("service.id");
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append('(');
        filterBuilder.append("service.id");
        filterBuilder.append('=');
        filterBuilder.append(serviceId);
        filterBuilder.append(')');
        this.servletContextHelperRefFilter = filterBuilder.toString();
        this.proxyContext = proxyContext;
        this.httpServiceRuntime = httpServiceRuntime;
        this.contextName = contextName;
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.contextPath = contextPath;
        this.contextServiceId = serviceId;
        this.initParams = ServiceProperties.parseInitParams(servletContextHelperRef, "context.init.", proxyContext.getServletContext());
        this.trackingContext = trackingContextParam;
        this.consumingContext = consumingContext;
        this.listenerServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getListenerFilter(), (ServiceTrackerCustomizer)new ContextListenerTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.listenerServiceTracker.open();
        this.filterServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getFilterFilter(), (ServiceTrackerCustomizer)new ContextFilterTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.filterServiceTracker.open();
        this.servletServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getServletFilter(), (ServiceTrackerCustomizer)new ContextServletTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.servletServiceTracker.open();
        this.resourceServiceTracker = new ServiceTracker(this.trackingContext, httpServiceRuntime.getResourceFilter(), (ServiceTrackerCustomizer)new ContextResourceTrackerCustomizer(this.trackingContext, httpServiceRuntime, this));
        this.resourceServiceTracker.open();
    }

    public FilterRegistration addFilterRegistration(ServiceReference<javax.servlet.Filter> filterRef) throws ServletException {
        this.checkShutdown();
        ServiceHolder<javax.servlet.Filter> filterHolder = new ServiceHolder<javax.servlet.Filter>(this.consumingContext.getServiceObjects(filterRef));
        javax.servlet.Filter filter = (javax.servlet.Filter)filterHolder.get();
        FilterRegistration registration = null;
        boolean addedRegisteredObject = false;
        try {
            if (filter == null) {
                throw new IllegalArgumentException("Filter cannot be null");
            }
            addedRegisteredObject = this.httpServiceRuntime.getRegisteredObjects().add(filter);
            if (addedRegisteredObject) {
                registration = this.doAddFilterRegistration(filterHolder, filterRef);
            }
        }
        finally {
            if (registration == null) {
                filterHolder.release();
                if (addedRegisteredObject) {
                    this.httpServiceRuntime.getRegisteredObjects().remove(filter);
                }
            }
        }
        return registration;
    }

    private FilterRegistration doAddFilterRegistration(ServiceHolder<javax.servlet.Filter> filterHolder, ServiceReference<javax.servlet.Filter> filterRef) throws ServletException {
        Integer filterPriority;
        ClassLoader legacyTCCL = (ClassLoader)filterRef.getProperty("equinox.legacy.tccl");
        boolean asyncSupported = ServiceProperties.parseBoolean(filterRef, "osgi.http.whiteboard.filter.asyncSupported");
        List<String> dispatcherList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.dispatcher"));
        String[] dispatchers = dispatcherList.toArray(new String[dispatcherList.size()]);
        Long serviceId = (Long)filterRef.getProperty("service.id");
        if (legacyTCCL != null) {
            serviceId = -serviceId.longValue();
        }
        if ((filterPriority = (Integer)filterRef.getProperty("service.ranking")) == null) {
            filterPriority = 0;
        }
        Map<String, String> filterInitParams = ServiceProperties.parseInitParams(filterRef, "filter.init.");
        List<String> patternList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        List<String> regexList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.regex"));
        String[] regexs = regexList.toArray(new String[regexList.size()]);
        List<String> servletList = StringPlus.from(filterRef.getProperty("osgi.http.whiteboard.filter.servlet"));
        String[] servletNames = servletList.toArray(new String[servletList.size()]);
        String name = ServiceProperties.parseName(filterRef.getProperty("osgi.http.whiteboard.filter.name"), filterHolder.get());
        javax.servlet.Filter filter = filterHolder.get();
        if (!(patterns != null && patterns.length != 0 || regexs != null && regexs.length != 0 || servletNames != null && servletNames.length != 0)) {
            throw new IllegalArgumentException("Patterns, regex or servletNames must contain a value.");
        }
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                ContextController.checkPattern(pattern);
                ++n2;
            }
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        if (name == null) {
            name = filter.getClass().getName();
        }
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            if (!((javax.servlet.Filter)filterRegistration.getT()).equals(filter)) continue;
            throw new RegisteredFilterException(filter);
        }
        dispatchers = this.checkDispatcher(dispatchers);
        FilterDTO filterDTO = new FilterDTO();
        filterDTO.asyncSupported = asyncSupported;
        filterDTO.dispatcher = this.sort(dispatchers);
        filterDTO.initParams = filterInitParams;
        filterDTO.name = name;
        filterDTO.patterns = this.sort(patterns);
        filterDTO.regexs = regexs;
        filterDTO.serviceId = serviceId;
        filterDTO.servletContextId = this.contextServiceId;
        filterDTO.servletNames = this.sort(servletNames);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(filterHolder.getBundle());
        ServletContext servletContext = this.createServletContext(filterHolder.getBundle(), curServletContextHelper);
        FilterRegistration newRegistration = new FilterRegistration(filterHolder, filterDTO, filterPriority, this, legacyTCCL);
        FilterConfigImpl filterConfig = new FilterConfigImpl(name, filterInitParams, servletContext);
        newRegistration.init(filterConfig);
        this.filterRegistrations.add(newRegistration);
        return newRegistration;
    }

    public ListenerRegistration addListenerRegistration(ServiceReference<EventListener> listenerRef) throws ServletException {
        this.checkShutdown();
        ServiceHolder<EventListener> listenerHolder = new ServiceHolder<EventListener>(this.consumingContext.getServiceObjects(listenerRef));
        EventListener listener = (EventListener)listenerHolder.get();
        ListenerRegistration registration = null;
        try {
            if (listener == null) {
                throw new IllegalArgumentException("EventListener cannot be null");
            }
            registration = this.doAddListenerRegistration(listenerHolder, listenerRef);
        }
        finally {
            if (registration == null) {
                listenerHolder.release();
            }
        }
        return registration;
    }

    private ListenerRegistration doAddListenerRegistration(ServiceHolder<EventListener> listenerHolder, ServiceReference<EventListener> listenerRef) throws ServletException {
        EventListener eventListener = listenerHolder.get();
        List<Class<? extends EventListener>> classes = this.getListenerClasses(listenerRef);
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("EventListener does not implement a supported type.");
        }
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            if (!listenerRegistration.getT().equals(eventListener)) continue;
            throw new ServletException("EventListener has already been registered.");
        }
        ListenerDTO listenerDTO = new ListenerDTO();
        listenerDTO.serviceId = (Long)listenerRef.getProperty("service.id");
        listenerDTO.servletContextId = this.contextServiceId;
        listenerDTO.types = this.asStringArray(classes);
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(listenerHolder.getBundle());
        ServletContext servletContext = this.createServletContext(listenerHolder.getBundle(), curServletContextHelper);
        ListenerRegistration listenerRegistration = new ListenerRegistration(listenerHolder, classes, listenerDTO, servletContext, this);
        if (classes.contains(ServletContextListener.class)) {
            ServletContextListener servletContextListener = (ServletContextListener)listenerRegistration.getT();
            servletContextListener.contextInitialized(new ServletContextEvent(servletContext));
        }
        this.listenerRegistrations.add(listenerRegistration);
        this.eventListeners.put(classes, listenerRegistration);
        return listenerRegistration;
    }

    public ResourceRegistration addResourceRegistration(ServiceReference<?> resourceRef) {
        this.checkShutdown();
        ClassLoader legacyTCCL = (ClassLoader)resourceRef.getProperty("equinox.legacy.tccl");
        Integer rankProp = (Integer)resourceRef.getProperty("service.ranking");
        int serviceRanking = rankProp == null ? 0 : rankProp;
        List<String> patternList = StringPlus.from(resourceRef.getProperty("osgi.http.whiteboard.resource.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        Long serviceId = (Long)resourceRef.getProperty("service.id");
        if (legacyTCCL != null) {
            serviceId = -serviceId.longValue();
        }
        String prefix = (String)resourceRef.getProperty("osgi.http.whiteboard.resource.prefix");
        this.checkPrefix(prefix);
        if (patterns == null || patterns.length < 1) {
            throw new IllegalArgumentException("Patterns must contain a value.");
        }
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            ContextController.checkPattern(pattern);
            ++n2;
        }
        Bundle bundle = resourceRef.getBundle();
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(bundle);
        ResourceServlet servlet = new ResourceServlet(prefix, curServletContextHelper, AccessController.getContext());
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.patterns = this.sort(patterns);
        resourceDTO.prefix = prefix;
        resourceDTO.serviceId = serviceId;
        resourceDTO.servletContextId = this.contextServiceId;
        ServletContext servletContext = this.createServletContext(bundle, curServletContextHelper);
        ResourceRegistration resourceRegistration = new ResourceRegistration(new ServiceHolder<ResourceServlet>(servlet, bundle, serviceId, serviceRanking), resourceDTO, curServletContextHelper, this, legacyTCCL);
        ServletConfigImpl servletConfig = new ServletConfigImpl(resourceRegistration.getName(), new HashMap<String, String>(), servletContext);
        try {
            resourceRegistration.init(servletConfig);
        }
        catch (Throwable t) {
            resourceRegistration.destroy();
            return (ResourceRegistration)Throw.unchecked(t);
        }
        this.endpointRegistrations.add(resourceRegistration);
        return resourceRegistration;
    }

    public ServletRegistration addServletRegistration(ServiceReference<Servlet> servletRef) throws ServletException {
        this.checkShutdown();
        ServiceHolder<Servlet> servletHolder = new ServiceHolder<Servlet>(this.consumingContext.getServiceObjects(servletRef));
        Servlet servlet = (Servlet)servletHolder.get();
        ServletRegistration registration = null;
        boolean addedRegisteredObject = false;
        try {
            if (servlet == null) {
                throw new IllegalArgumentException("Servlet cannot be null");
            }
            addedRegisteredObject = this.httpServiceRuntime.getRegisteredObjects().add(servlet);
            if (addedRegisteredObject) {
                registration = this.doAddServletRegistration(servletHolder, servletRef);
            }
        }
        finally {
            if (registration == null) {
                servletHolder.release();
                if (addedRegisteredObject) {
                    this.httpServiceRuntime.getRegisteredObjects().remove(servlet);
                }
            }
        }
        return registration;
    }

    private ServletRegistration doAddServletRegistration(ServiceHolder<Servlet> servletHolder, ServiceReference<Servlet> servletRef) throws ServletException {
        boolean asyncSupported = ServiceProperties.parseBoolean(servletRef, "osgi.http.whiteboard.servlet.asyncSupported");
        ClassLoader legacyTCCL = (ClassLoader)servletRef.getProperty("equinox.legacy.tccl");
        List<String> errorPageList = StringPlus.from(servletRef.getProperty("osgi.http.whiteboard.servlet.errorPage"));
        String[] errorPages = errorPageList.toArray(new String[errorPageList.size()]);
        Map<String, String> servletInitParams = ServiceProperties.parseInitParams(servletRef, "servlet.init.");
        List<String> patternList = StringPlus.from(servletRef.getProperty("osgi.http.whiteboard.servlet.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        Long serviceId = (Long)servletRef.getProperty("service.id");
        if (legacyTCCL != null) {
            serviceId = -serviceId.longValue();
        }
        String servletNameFromProperties = (String)servletRef.getProperty("osgi.http.whiteboard.servlet.name");
        String generatedServletName = ServiceProperties.parseName(servletRef.getProperty("osgi.http.whiteboard.servlet.name"), servletHolder.get());
        boolean multipartEnabled = ServiceProperties.parseBoolean(servletRef, "equinox.http.multipartSupported");
        Integer multipartFileSizeThreshold = (Integer)servletRef.getProperty("equinox.http.whiteboard.servlet.multipart.fileSizeThreshold");
        String multipartLocation = (String)servletRef.getProperty("equinox.http.whiteboard.servlet.multipart.location");
        Long multipartMaxFileSize = (Long)servletRef.getProperty("equinox.http.whiteboard.servlet.multipart.maxFileSize");
        Long multipartMaxRequestSize = (Long)servletRef.getProperty("equinox.http.whiteboard.servlet.multipart.maxRequestSize");
        if (!(patterns != null && patterns.length != 0 || errorPages != null && errorPages.length != 0 || servletNameFromProperties != null)) {
            StringBuilder sb = new StringBuilder();
            sb.append("One of the service properties ");
            sb.append("osgi.http.whiteboard.servlet.errorPage");
            sb.append(", ");
            sb.append("osgi.http.whiteboard.servlet.name");
            sb.append(", ");
            sb.append("osgi.http.whiteboard.servlet.pattern");
            sb.append(" must contain a value.");
            throw new IllegalArgumentException(sb.toString());
        }
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                ContextController.checkPattern(pattern);
                ++n2;
            }
        }
        ExtendedServletDTO servletDTO = new ExtendedServletDTO();
        servletDTO.asyncSupported = asyncSupported;
        servletDTO.initParams = servletInitParams;
        servletDTO.multipartEnabled = multipartEnabled;
        servletDTO.multipartFileSizeThreshold = multipartFileSizeThreshold != null ? multipartFileSizeThreshold : 0;
        servletDTO.multipartLocation = multipartLocation != null ? multipartLocation : "";
        servletDTO.multipartMaxFileSize = multipartMaxFileSize != null ? multipartMaxFileSize : -1L;
        servletDTO.multipartMaxRequestSize = multipartMaxRequestSize != null ? multipartMaxRequestSize : -1L;
        servletDTO.name = generatedServletName;
        servletDTO.patterns = this.sort(patterns);
        servletDTO.serviceId = serviceId;
        servletDTO.servletContextId = this.contextServiceId;
        servletDTO.servletInfo = servletHolder.get().getServletInfo();
        ErrorPageDTO errorPageDTO = null;
        if (errorPages != null && errorPages.length > 0) {
            errorPageDTO = new ErrorPageDTO();
            errorPageDTO.asyncSupported = asyncSupported;
            ArrayList<String> exceptions = new ArrayList<String>();
            LinkedHashSet<Long> errorCodeSet = new LinkedHashSet<Long>();
            String[] stringArray = errorPages;
            int n = errorPages.length;
            int n3 = 0;
            while (n3 < n) {
                String errorPage = stringArray[n3];
                try {
                    long code;
                    if ("4xx".equals(errorPage)) {
                        code = 400L;
                        while (code < 500L) {
                            errorCodeSet.add(code);
                            ++code;
                        }
                    } else if ("5xx".equals(errorPage)) {
                        code = 500L;
                        while (code < 600L) {
                            errorCodeSet.add(code);
                            ++code;
                        }
                    } else {
                        code = Long.parseLong(errorPage);
                        errorCodeSet.add(code);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    exceptions.add(errorPage);
                }
                ++n3;
            }
            long[] errorCodes = new long[errorCodeSet.size()];
            int i = 0;
            for (Long code : errorCodeSet) {
                errorCodes[i] = code;
                ++i;
            }
            errorPageDTO.errorCodes = errorCodes;
            errorPageDTO.exceptions = exceptions.toArray(new String[exceptions.size()]);
            errorPageDTO.initParams = servletInitParams;
            errorPageDTO.name = generatedServletName;
            errorPageDTO.serviceId = serviceId;
            errorPageDTO.servletContextId = this.contextServiceId;
            errorPageDTO.servletInfo = servletHolder.get().getServletInfo();
        }
        ServletContextHelper curServletContextHelper = this.getServletContextHelper(servletHolder.getBundle());
        ServletContext servletContext = this.createServletContext(servletHolder.getBundle(), curServletContextHelper);
        ServletRegistration servletRegistration = new ServletRegistration(servletHolder, servletDTO, errorPageDTO, curServletContextHelper, this, servletContext, legacyTCCL);
        ServletConfigImpl servletConfig = new ServletConfigImpl(generatedServletName, servletInitParams, servletContext);
        try {
            servletRegistration.init(servletConfig);
        }
        catch (Throwable t) {
            servletRegistration.destroy();
            return (ServletRegistration)Throw.unchecked(t);
        }
        this.endpointRegistrations.add(servletRegistration);
        return servletRegistration;
    }

    public void destroy() {
        this.flushActiveSessions();
        this.resourceServiceTracker.close();
        this.servletServiceTracker.close();
        this.filterServiceTracker.close();
        this.listenerServiceTracker.close();
        this.endpointRegistrations.clear();
        this.filterRegistrations.clear();
        this.listenerRegistrations.clear();
        this.eventListeners.clear();
        this.proxyContext.destroy();
        this.shutdown = true;
    }

    public String getContextName() {
        this.checkShutdown();
        return this.contextName;
    }

    public String getContextPath() {
        this.checkShutdown();
        return this.contextPath;
    }

    public DispatchTargets getDispatchTargets(String pathString, RequestInfoDTO requestInfoDTO) {
        Path path = new Path(pathString);
        String queryString = path.getQueryString();
        String requestURI = path.getRequestURI();
        DispatchTargets dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.EXACT, requestInfoDTO);
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, path.getExtension(), queryString, Match.EXTENSION, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.REGEX, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.DEFAULT_SERVLET, requestInfoDTO);
        }
        return dispatchTargets;
    }

    private DispatchTargets getDispatchTargets(String requestURI, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.DEFAULT_SERVLET) {
            pathInfo = servletPath;
            servletPath = "/";
        }
        while (true) {
            DispatchTargets dispatchTargets;
            if ((dispatchTargets = this.getDispatchTargets(null, requestURI, servletPath, pathInfo, extension, queryString, match, requestInfoDTO)) != null) {
                return dispatchTargets;
            }
            if (match == Match.EXACT || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    public DispatchTargets getDispatchTargets(String servletName, String requestURI, String servletPath, String pathInfo, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        int x;
        this.checkShutdown();
        EndpointRegistration<?> endpointRegistration = null;
        for (EndpointRegistration<?> curEndpointRegistration : this.endpointRegistrations) {
            if (curEndpointRegistration.match(servletName, servletPath, pathInfo, extension, match) == null) continue;
            endpointRegistration = curEndpointRegistration;
            break;
        }
        if (endpointRegistration == null) {
            return null;
        }
        if (match == Match.EXTENSION) {
            servletPath = String.valueOf(servletPath) + pathInfo;
            pathInfo = null;
        }
        this.addEnpointRegistrationsToRequestInfo(endpointRegistration, requestInfoDTO);
        if (this.filterRegistrations.isEmpty()) {
            return new DispatchTargets(this, endpointRegistration, servletName, requestURI, servletPath, pathInfo, queryString);
        }
        if (requestURI != null && (x = requestURI.lastIndexOf(46)) != -1) {
            extension = requestURI.substring(x + 1);
        }
        ArrayList<FilterRegistration> matchingFilterRegistrations = new ArrayList<FilterRegistration>();
        this.collectFilters(matchingFilterRegistrations, endpointRegistration.getName(), requestURI, servletPath, pathInfo, extension);
        this.addFilterRegistrationsToRequestInfo(matchingFilterRegistrations, requestInfoDTO);
        return new DispatchTargets(this, endpointRegistration, matchingFilterRegistrations, servletName, requestURI, servletPath, pathInfo, queryString);
    }

    private void collectFilters(List<FilterRegistration> matchingFilterRegistrations, String servletName, String requestURI, String servletPath, String pathInfo, String extension) {
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            if (filterRegistration.match(servletName, requestURI, extension, null) == null || matchingFilterRegistrations.contains(filterRegistration)) continue;
            matchingFilterRegistrations.add(filterRegistration);
        }
    }

    public Map<String, HttpSessionAdaptor> getActiveSessions() {
        this.checkShutdown();
        return this.activeSessions;
    }

    public Set<EndpointRegistration<?>> getEndpointRegistrations() {
        this.checkShutdown();
        return this.endpointRegistrations;
    }

    public EventListeners getEventListeners() {
        this.checkShutdown();
        return this.eventListeners;
    }

    public Set<FilterRegistration> getFilterRegistrations() {
        this.checkShutdown();
        return this.filterRegistrations;
    }

    public String getFullContextPath() {
        List<String> endpoints = this.httpServiceRuntime.getHttpServiceEndpoints();
        if (endpoints.isEmpty()) {
            return this.proxyContext.getServletPath().concat(this.contextPath);
        }
        String defaultEndpoint = endpoints.get(0);
        if (defaultEndpoint.length() > 0 && defaultEndpoint.endsWith("/")) {
            defaultEndpoint = defaultEndpoint.substring(0, defaultEndpoint.length() - 1);
        }
        return String.valueOf(defaultEndpoint) + this.contextPath;
    }

    public HttpServiceRuntimeImpl getHttpServiceRuntime() {
        this.checkShutdown();
        return this.httpServiceRuntime;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Set<ListenerRegistration> getListenerRegistrations() {
        this.checkShutdown();
        return this.listenerRegistrations;
    }

    public ProxyContext getProxyContext() {
        this.checkShutdown();
        return this.proxyContext;
    }

    public long getServiceId() {
        this.checkShutdown();
        return this.contextServiceId;
    }

    public synchronized ServletContextDTO getServletContextDTO() {
        this.checkShutdown();
        ServletContextDTO servletContextDTO = new ServletContextDTO();
        ServletContext servletContext = this.getProxyContext().getServletContext();
        servletContextDTO.attributes = this.getDTOAttributes(servletContext);
        servletContextDTO.contextPath = this.getContextPath();
        servletContextDTO.initParams = new HashMap<String, String>(this.initParams);
        servletContextDTO.name = this.getContextName();
        servletContextDTO.serviceId = this.getServiceId();
        this.collectEndpointDTOs(servletContextDTO);
        this.collectFilterDTOs(servletContextDTO);
        this.collectListenerDTOs(servletContextDTO);
        return servletContextDTO;
    }

    public boolean matches(ServiceReference<?> whiteBoardService) {
        Filter targetFilter;
        String contextSelector = (String)whiteBoardService.getProperty("osgi.http.whiteboard.context.select");
        if (!this.visibleContextHelper(whiteBoardService)) {
            return false;
        }
        if (contextSelector == null && (contextSelector = this.httpServiceRuntime.getDefaultContextSelectFilter(whiteBoardService)) == null) {
            contextSelector = "(osgi.http.whiteboard.context.name=default)";
        }
        if (!contextSelector.startsWith("(")) {
            contextSelector = "(osgi.http.whiteboard.context.name=" + contextSelector + ")";
        }
        try {
            targetFilter = FrameworkUtil.createFilter((String)contextSelector);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return this.matches(targetFilter);
    }

    private boolean visibleContextHelper(ServiceReference<?> whiteBoardService) {
        if (this.consumingContext.getBundle().equals(this.servletContextHelperRef.getBundle())) {
            return true;
        }
        try {
            if (whiteBoardService.getBundle().getBundleContext().getAllServiceReferences(ServletContextHelper.class.getName(), this.servletContextHelperRefFilter) != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return false;
    }

    public boolean matches(Filter targetFilter) {
        return targetFilter.match(this.servletContextHelperRef);
    }

    public String toString() {
        String value = this.string;
        if (value == null) {
            this.string = value = String.valueOf(SIMPLE_NAME) + '[' + this.contextName + ", " + this.trackingContext.getBundle() + ']';
        }
        return value;
    }

    private void addEnpointRegistrationsToRequestInfo(EndpointRegistration<?> endpointRegistration, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        requestInfoDTO.servletContextId = this.getServiceId();
        if (endpointRegistration instanceof ResourceRegistration) {
            requestInfoDTO.resourceDTO = (ResourceDTO)endpointRegistration.getD();
        } else {
            requestInfoDTO.servletDTO = (ServletDTO)endpointRegistration.getD();
        }
    }

    private void addFilterRegistrationsToRequestInfo(List<FilterRegistration> matchedFilterRegistrations, RequestInfoDTO requestInfoDTO) {
        if (requestInfoDTO == null) {
            return;
        }
        FilterDTO[] filterDTOs = new FilterDTO[matchedFilterRegistrations.size()];
        int i = 0;
        while (i < filterDTOs.length) {
            FilterRegistration filterRegistration = matchedFilterRegistrations.get(i);
            filterDTOs[i] = (FilterDTO)filterRegistration.getD();
            ++i;
        }
        requestInfoDTO.filterDTOs = filterDTOs;
    }

    private String[] asStringArray(List<Class<? extends EventListener>> clazzes) {
        Object[] classesArray = new String[clazzes.size()];
        int i = 0;
        while (i < classesArray.length) {
            classesArray[i] = clazzes.get(i).getName();
            ++i;
        }
        Arrays.sort(classesArray);
        return classesArray;
    }

    private String[] checkDispatcher(String[] dispatcher) {
        if (dispatcher == null || dispatcher.length == 0) {
            return DISPATCHER;
        }
        String[] stringArray = dispatcher;
        int n = dispatcher.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            try {
                DispatcherType.valueOf((String)type);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Invalid dispatcher '" + type + "'", iae);
            }
            ++n2;
        }
        Arrays.sort(dispatcher);
        return dispatcher;
    }

    public static void checkPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        if (pattern.indexOf("*.") == 0) {
            return;
        }
        if (!pattern.startsWith("/") || pattern.endsWith("/") && !pattern.equals("/")) {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "'");
        }
    }

    private void checkPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (prefix.endsWith("/") && !prefix.equals("/")) {
            throw new IllegalArgumentException("Invalid prefix '" + prefix + "'");
        }
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Context is already shutdown");
        }
    }

    private ServletContext createServletContext(Bundle curBundle, ServletContextHelper curServletContextHelper) {
        ServletContextAdaptor adaptor = new ServletContextAdaptor(this, curBundle, curServletContextHelper, this.eventListeners, AccessController.getContext());
        return adaptor.createServletContext();
    }

    private void collectEndpointDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ErrorPageDTO> errorPageDTOs = new ArrayList<ErrorPageDTO>();
        ArrayList<ResourceDTO> resourceDTOs = new ArrayList<ResourceDTO>();
        ArrayList<ExtendedServletDTO> servletDTOs = new ArrayList<ExtendedServletDTO>();
        for (EndpointRegistration<?> endpointRegistration : this.endpointRegistrations) {
            if (endpointRegistration instanceof ResourceRegistration) {
                resourceDTOs.add(DTOUtil.clone((ResourceDTO)endpointRegistration.getD()));
                continue;
            }
            ServletRegistration servletRegistration = (ServletRegistration)endpointRegistration;
            servletDTOs.add(DTOUtil.clone((ExtendedServletDTO)((Object)servletRegistration.getD())));
            ErrorPageDTO errorPageDTO = servletRegistration.getErrorPageDTO();
            if (errorPageDTO == null) continue;
            errorPageDTOs.add(DTOUtil.clone(errorPageDTO));
        }
        servletContextDTO.errorPageDTOs = errorPageDTOs.toArray(new ErrorPageDTO[errorPageDTOs.size()]);
        servletContextDTO.resourceDTOs = resourceDTOs.toArray(new ResourceDTO[resourceDTOs.size()]);
        servletContextDTO.servletDTOs = servletDTOs.toArray(new ServletDTO[servletDTOs.size()]);
    }

    private void collectFilterDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<FilterDTO> filterDTOs = new ArrayList<FilterDTO>();
        for (FilterRegistration filterRegistration : this.filterRegistrations) {
            filterDTOs.add(DTOUtil.clone((FilterDTO)filterRegistration.getD()));
        }
        servletContextDTO.filterDTOs = filterDTOs.toArray(new FilterDTO[filterDTOs.size()]);
    }

    private void collectListenerDTOs(ServletContextDTO servletContextDTO) {
        ArrayList<ListenerDTO> listenerDTOs = new ArrayList<ListenerDTO>();
        for (ListenerRegistration listenerRegistration : this.listenerRegistrations) {
            listenerDTOs.add(DTOUtil.clone((ListenerDTO)listenerRegistration.getD()));
        }
        servletContextDTO.listenerDTOs = listenerDTOs.toArray(new ListenerDTO[listenerDTOs.size()]);
    }

    private Map<String, Object> getDTOAttributes(ServletContext servletContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, DTOUtil.mapValue(servletContext.getAttribute(name)));
        }
        return Collections.unmodifiableMap(map);
    }

    private List<Class<? extends EventListener>> getListenerClasses(ServiceReference<EventListener> serviceReference) {
        ServletContext servletContext;
        List<String> objectClassList = StringPlus.from(serviceReference.getProperty("objectClass"));
        ArrayList<Class<? extends EventListener>> classes = new ArrayList<Class<? extends EventListener>>();
        if (objectClassList.contains(ServletContextListener.class.getName())) {
            classes.add(ServletContextListener.class);
        }
        if (objectClassList.contains(ServletContextAttributeListener.class.getName())) {
            classes.add(ServletContextAttributeListener.class);
        }
        if (objectClassList.contains(ServletRequestListener.class.getName())) {
            classes.add(ServletRequestListener.class);
        }
        if (objectClassList.contains(ServletRequestAttributeListener.class.getName())) {
            classes.add(ServletRequestAttributeListener.class);
        }
        if (objectClassList.contains(HttpSessionListener.class.getName())) {
            classes.add(HttpSessionListener.class);
        }
        if (objectClassList.contains(HttpSessionAttributeListener.class.getName())) {
            classes.add(HttpSessionAttributeListener.class);
        }
        if ((servletContext = this.proxyContext.getServletContext()).getMajorVersion() >= 3 && servletContext.getMinorVersion() > 0 && objectClassList.contains(HttpSessionIdListener.class.getName())) {
            classes.add(HttpSessionIdListener.class);
        }
        return classes;
    }

    private ServletContextHelper getServletContextHelper(Bundle curBundle) {
        BundleContext context = curBundle.getBundleContext();
        return (ServletContextHelper)context.getService(this.servletContextHelperRef);
    }

    public void ungetServletContextHelper(Bundle curBundle) {
        BundleContext context = curBundle.getBundleContext();
        try {
            context.ungetService(this.servletContextHelperRef);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private String[] sort(String[] values) {
        if (values == null) {
            return null;
        }
        Arrays.sort(values);
        return values;
    }

    private void flushActiveSessions() {
        Collection httpSessionAdaptors = this.activeSessions.values();
        Iterator iterator = httpSessionAdaptors.iterator();
        while (iterator.hasNext()) {
            HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)iterator.next();
            httpSessionAdaptor.invalidate();
            iterator.remove();
        }
    }

    public void removeActiveSession(HttpSession session) {
        this.activeSessions.remove(session.getId());
    }

    public void fireSessionIdChanged(String oldSessionId) {
        ServletContext servletContext = this.proxyContext.getServletContext();
        if (servletContext.getMajorVersion() <= 3 && servletContext.getMinorVersion() < 1) {
            return;
        }
        List<HttpSessionIdListener> listeners = this.eventListeners.get(HttpSessionIdListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        for (HttpSessionAdaptor httpSessionAdaptor : this.activeSessions.values()) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
            for (HttpSessionIdListener listener : listeners) {
                listener.sessionIdChanged(httpSessionEvent, oldSessionId);
            }
        }
    }

    public HttpSessionAdaptor getSessionAdaptor(HttpSession session, ServletContext servletContext) {
        String sessionId = session.getId();
        HttpSessionAdaptor httpSessionAdaptor = (HttpSessionAdaptor)this.activeSessions.get(sessionId);
        if (httpSessionAdaptor != null) {
            return httpSessionAdaptor;
        }
        httpSessionAdaptor = HttpSessionAdaptor.createHttpSessionAdaptor(session, servletContext, this);
        HttpSessionAdaptor previousHttpSessionAdaptor = this.activeSessions.putIfAbsent(sessionId, httpSessionAdaptor);
        if (previousHttpSessionAdaptor != null) {
            return previousHttpSessionAdaptor;
        }
        List<HttpSessionListener> listeners = this.eventListeners.get(HttpSessionListener.class);
        if (listeners.isEmpty()) {
            return httpSessionAdaptor;
        }
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
        for (HttpSessionListener listener : listeners) {
            listener.sessionCreated(httpSessionEvent);
        }
        return httpSessionAdaptor;
    }

    private void validate(String preValidationContextName, String preValidationContextPath) {
        if (!contextNamePattern.matcher(preValidationContextName).matches()) {
            throw new IllegalContextNameException("The context name '" + preValidationContextName + "' does not follow Bundle-SymbolicName syntax.", 6);
        }
        try {
            new URI("http", "localhost", preValidationContextPath, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalContextPathException("The context path '" + preValidationContextPath + "' is not valid URI path syntax.", 6);
        }
    }

    public static final class ServiceHolder<S>
    implements Comparable<ServiceHolder<?>> {
        final ServiceObjects<S> serviceObjects;
        final S service;
        final Bundle bundle;
        final long serviceId;
        final int serviceRanking;

        public ServiceHolder(ServiceObjects<S> serviceObjects) {
            this.serviceObjects = serviceObjects;
            this.bundle = serviceObjects.getServiceReference().getBundle();
            this.service = serviceObjects.getService();
            this.serviceId = (Long)serviceObjects.getServiceReference().getProperty("service.id");
            Integer rankProp = (Integer)serviceObjects.getServiceReference().getProperty("service.ranking");
            this.serviceRanking = rankProp == null ? 0 : rankProp;
        }

        public ServiceHolder(S service, Bundle bundle, long serviceId, int serviceRanking) {
            this.service = service;
            this.bundle = bundle;
            this.serviceObjects = null;
            this.serviceId = serviceId;
            this.serviceRanking = serviceRanking;
        }

        public S get() {
            return this.service;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void release() {
            if (this.serviceObjects != null && this.service != null) {
                try {
                    this.serviceObjects.ungetService(this.service);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }

        public ServiceReference<S> getServiceReference() {
            return this.serviceObjects == null ? null : this.serviceObjects.getServiceReference();
        }

        @Override
        public int compareTo(ServiceHolder<?> o) {
            int thisRanking = this.serviceRanking;
            int otherRanking = o.serviceRanking;
            if (thisRanking != otherRanking) {
                if (thisRanking < otherRanking) {
                    return 1;
                }
                return -1;
            }
            long thisId = this.serviceId;
            long otherId = o.serviceId;
            if (thisId == otherId) {
                return 0;
            }
            if (thisId < otherId) {
                return -1;
            }
            return 1;
        }
    }
}

